<*/NOWARN:F*>
(*------------------------------------------------------------
   HELLOWIN.C      --- Displays "Hello, Windows 95!" in client area
                   (C) Charles Petzold, 1996
   HelloWin.mod    --- Translation to Stony Brook Modula-2
                   (C) Peter Stadler,   1997
  ------------------------------------------------------------*)
MODULE HelloWin;

IMPORT SYSTEM;
IMPORT WIN32;
IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WINX;
IMPORT MMSYSTEM;

CONST AppName = "HelloWin";

VAR  hwnd       : WIN32.HWND;
     msg        : WINUSER.MSG;
     wc         : WINUSER.WNDCLASSEX;
   
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(******************************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(******************************************************************************)

  VAR
     hdc     :   WIN32.HDC;
     ps      :   WINUSER.PAINTSTRUCT;
     rect    :   WIN32.RECT;
     hBrush  :   WIN32.HBRUSH;
BEGIN
  CASE iMsg OF
  | WINUSER.WM_CREATE:
      MMSYSTEM.PlaySound ("hellowin.wav", NIL, MMSYSTEM.SND_FILENAME BOR MMSYSTEM.SND_ASYNC);
      RETURN 0;

  | WINUSER.WM_PAINT:
      hdc := WINUSER.BeginPaint (hwnd,ps);
      hBrush := WINGDI.CreateSolidBrush(WINGDI.RGB(0,0,255));
      WINUSER.GetClientRect (hwnd, rect);
      WINUSER.FillRect(hdc,rect,hBrush);
      WINUSER.DrawText (hdc, "Hello, Windows 95!", -1, rect,
                                  WINUSER.DT_SINGLELINE BOR WINUSER.DT_CENTER BOR WINUSER.DT_VCENTER);
      WINUSER.EndPaint (hwnd, ps);
      RETURN 0;

  | WINUSER.WM_DESTROY:
      WINUSER.PostQuitMessage(0);
      RETURN 0;
  ELSE
    RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;
<*/POP*>
(******************************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(******************************************************************************)
BEGIN
   wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
   wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
   wc.lpfnWndProc   := WndProc;
   wc.cbClsExtra    := 0;
   wc.cbWndExtra    := 0;
   wc.hInstance     := WINX.Instance;
   wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
   wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
   wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
   wc.lpszMenuName  := NIL;
   wc.lpszClassName := SYSTEM.ADR (AppName);
   wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

   RETURN WINUSER.RegisterClassEx (wc) <> 0;
END InitApplication;

PROCEDURE InitMainWindow() : BOOLEAN;
BEGIN
  hwnd := WINUSER.CreateWindow (AppName,                        (* window class name            *)
                                "The Hello Program: Translation to Stony Brook Modula-2", 
                                                                (* window caption               *)
                                WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                                WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                                WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                                WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                                WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                                NIL,                            (* parent window handle         *)
                                NIL,                            (* window menu handle           *)
                                wc.hInstance,                   (* program instance handle      *)
                                NIL);                           (* creation parameters          *)

  WINUSER.ShowWindow   (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);

  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END HelloWin.
