<*/NOWARN:F*>
(*----------------------------------------------------
   SYSMETS1.C      --- System Metrics Display Program No. 1
                   (c) Charles Petzold, 1996
   SysMets1.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------------------*)


MODULE SysMets1;
IMPORT SYSTEM;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT SysMets;
IMPORT Strings;
IMPORT WINX;
CONST
  szAppName = "SysMets1";
VAR
  hwnd        :  WIN32.HWND;
  msg         :  WINUSER.MSG;
  wc          :  WINUSER.WNDCLASSEX;
  cxChar, cxCaps, cyChar: INTEGER;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE  WndProc (hwnd        : WIN32.HWND;
                    iMsg        : WIN32.UINT;
                    wParam      : WIN32.WPARAM;
                    lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(**********************************************************************)
VAR
  szBuffer    :  ARRAY[0..10] OF CHAR;
  hdc         :  WIN32.HDC;
  i           :  INTEGER;
  ps          :  WINUSER.PAINTSTRUCT;
  tm          :  WINGDI.TEXTMETRIC;
BEGIN

  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hdc := WINUSER.GetDC (hwnd);

               WINGDI.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               IF((tm.tmPitchAndFamily BAND 1)=1) THEN
                 cxCaps := 3*cxChar/2;
               ELSE
                 cxCaps := 2*cxChar/2;
               END;
               cyChar := tm.tmHeight + tm.tmExternalLeading;

               WINUSER.ReleaseDC (hwnd, hdc);
               RETURN 0;

          | WINUSER.WM_PAINT :
               hdc := WINUSER.BeginPaint (hwnd, ps);

               FOR i := 0 TO SysMets.NUMLINES-1 DO
                    WINGDI.TextOut (hdc, cxChar, cyChar * (1 + i),
                             SysMets.sysmetrics[i].szLabel,
                             LENGTH(SysMets.sysmetrics[i].szLabel));

                    WINGDI.TextOut (hdc, cxChar + 22 * cxCaps, cyChar * (1 + i),
                             SysMets.sysmetrics[i].szDesc,
                             LENGTH(SysMets.sysmetrics[i].szDesc));

                    WINGDI.SetTextAlign (hdc, WINGDI.TA_RIGHT BOR WINGDI.TA_TOP);

                    WINGDI.TextOut (hdc, cxChar + 22 * cxCaps + 40 * cxChar,
                                         cyChar * (1 + i), szBuffer,
                             WINUSER.wsprintf (szBuffer, "%5d",
                                             WINUSER.GetSystemMetrics (SysMets.sysmetrics[i].iIndex)));

                    WINGDI.SetTextAlign (hdc, WINGDI.TA_LEFT BOR WINGDI.TA_TOP);
               END;

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE

              RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc  :  INTEGER;
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx (wc);
  RETURN rc#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "Get System Metrics No. 1: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW BOR WINUSER.WS_VSCROLL, (* window style           *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END SysMets1.
