<*/NOWARN:F*>
MODULE Bezier;
(*---------------------------------------
   BEZIER.C        --- Bezier Splines Demo
                   (c) Charles Petzold, 1996
   Bezier.mod      --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ---------------------------------------*)
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;

CONST
  szAppName  =  "Bezier";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
VAR
  apt       :  ARRAY[0..4] OF WIN32.POINT;
  hdc       :  WIN32.HDC;
  cxClient  :  INTEGER;
  cyClient  :  INTEGER;
  ps        :  WINUSER.PAINTSTRUCT;
(*++++*****************************************************************)
PROCEDURE DrawBezier (hdc    :  WIN32.HDC;
                      apt    :  ARRAY OF WIN32.POINT);
(**********************************************************************)
BEGIN
  WINGDI.PolyBezier (hdc, apt, 4);

  WINGDI.MoveToEx (hdc, apt[0].x, apt[0].y, WINX.NIL_POINT);
  WINGDI.LineTo   (hdc, apt[1].x, apt[1].y);

  WINGDI.MoveToEx (hdc, apt[2].x, apt[2].y, WINX.NIL_POINT);
  WINGDI.LineTo   (hdc, apt[3].x, apt[3].y);
END DrawBezier;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];

BEGIN

  CASE (iMsg)  OF
  | WINUSER.WM_SIZE:
      cxClient := WINUSER.LOWORD (lParam);
      cyClient := WINUSER.HIWORD (lParam);

      apt[0].x := cxClient / 4;
      apt[0].y := cyClient / 2;

      apt[1].x := cxClient / 2;
      apt[1].y := cyClient / 4;

      apt[2].x :=     cxClient / 2;
      apt[2].y := 3 * cyClient / 4;

      apt[3].x := 3 * cxClient / 4;
      apt[3].y :=     cyClient / 2;

      RETURN 0;

  | WINUSER.WM_MOUSEMOVE:
      IF ((wParam BAND WINUSER.MK_LBUTTON)=1) OR ((wParam BAND WINUSER.MK_RBUTTON)=1) THEN
        hdc := WINUSER.GetDC (hwnd);
        WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.WHITE_PEN));
        DrawBezier (hdc, apt);

        IF (wParam BAND WINUSER.MK_LBUTTON=1) THEN
          apt[1].x := WINUSER.LOWORD (lParam);
          apt[1].y := WINUSER.HIWORD (lParam);
        END;

        IF (wParam BAND WINUSER.MK_RBUTTON=1) THEN
          apt[2].x := WINUSER.LOWORD (lParam);
          apt[2].y := WINUSER.HIWORD (lParam);
        END;

        WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.BLACK_PEN));
        DrawBezier (hdc, apt);
        WINUSER.ReleaseDC (hwnd, hdc);
      END;
      RETURN 0;

  | WINUSER.WM_PAINT:
      WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
      hdc := WINUSER.BeginPaint (hwnd, ps);
      DrawBezier (hdc, apt);
      WINUSER.EndPaint (hwnd, ps);
      RETURN 0;

  | WINUSER.WM_DESTROY:
      WINUSER.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;

END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                        (* window class name            *)
                       "Bezier Splines: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Bezier.
