<*/NOWARN:F*>
MODULE Clover;
(*--------------------------------------------------
   CLOVER.C        --- Clover Drawing Program using Regions
                   (c) Charles Petzold, 1996
   Clover.mod      --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  --------------------------------------------------*)



IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT RealMath;

CONST TWO_PI = 2.0 * 3.14159;
CONST szAppName = "Clover";

VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hRgnClip        :  WIN32.HRGN;
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  fAngle     :  CARDINAL;
  fRadius    :  REAL;
  fx         :  REAL;
  fy         :  REAL;
  hCursor    :  WIN32.HCURSOR;
  hdc        :  WIN32.HDC;
  hRgnTemp   :  ARRAY[0..5] OF WIN32.HRGN;
  i          :  INTEGER;
  ps         :  WINUSER.PAINTSTRUCT;

BEGIN

  CASE (iMsg)  OF
          | WINUSER.WM_SIZE:
               cxClient := WINUSER.LOWORD (lParam);
               cyClient := WINUSER.HIWORD (lParam);

               hCursor := WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_WAIT^));
               WINUSER.ShowCursor (TRUE);

               IF (hRgnClip#NIL) THEN
                    WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hRgnClip) );
               END;

               hRgnTemp[0] := WINGDI.CreateEllipticRgn (0, cyClient / 3,
                                        cxClient / 2, 2 * cyClient / 3);
               hRgnTemp[1] := WINGDI.CreateEllipticRgn (cxClient / 2, cyClient / 3,
                                        cxClient, 2 * cyClient / 3);
               hRgnTemp[2] := WINGDI.CreateEllipticRgn (cxClient / 3, 0,
                                        2 * cxClient / 3, cyClient / 2);
               hRgnTemp[3] := WINGDI.CreateEllipticRgn (cxClient / 3, cyClient / 2,
                                        2 * cxClient / 3, cyClient);
               hRgnTemp[4] := WINGDI.CreateRectRgn (0, 0, 1, 1);
               hRgnTemp[5] := WINGDI.CreateRectRgn (0, 0, 1, 1);
               hRgnClip    := WINGDI.CreateRectRgn (0, 0, 1, 1);

               WINGDI.CombineRgn (hRgnTemp[4], hRgnTemp[0], hRgnTemp[1], WINGDI.RGN_OR);
               WINGDI.CombineRgn (hRgnTemp[5], hRgnTemp[2], hRgnTemp[3], WINGDI.RGN_OR);
               WINGDI.CombineRgn (hRgnClip,    hRgnTemp[4], hRgnTemp[5], WINGDI.RGN_XOR);

               FOR i := 0 TO 6-1 DO
                    WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hRgnTemp[i]));
               END;
               WINUSER.SetCursor (hCursor);
               WINUSER.ShowCursor (FALSE);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINGDI.SetViewportOrgEx (hdc, cxClient / 2, cyClient / 2, WINX.NIL_POINT);
               WINGDI.SelectClipRgn (hdc, hRgnClip);

               fx := VAL(REAL,(cxClient*cxClient))/4.0;
               fy := VAL(REAL,(cyClient*cyClient))/4.0;
               fRadius := RealMath.sqrt(fx+fy);


               FOR fAngle := 0 TO 360-1 DO
                    WINGDI.MoveToEx (hdc, 0, 0, WINX.NIL_POINT);
                    WINGDI.LineTo (hdc, VAL(INTEGER,(fRadius * RealMath.cos (VAL(REAL,fAngle)*TWO_PI/360.) + 0.5)),
                                 VAL(INTEGER,(-fRadius * RealMath.sin (VAL(REAL,fAngle)*TWO_PI/360.) + 0.5)));
               END;

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hRgnClip));
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
        RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc  :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx(wc);
  RETURN rc #0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Draw a Clover: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Clover.
