<*/NOWARN:F*>
MODULE DevCaps1;
(*---------------------------------------------------------
   DEVCAPS1.C      --- Device Capabilities Display Program No. 1
                   (c) Charles Petzold, 1996
   DevCaps1.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ---------------------------------------------------------*)
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
CONST szAppName = "DevCaps1";
VAR
  hwnd  :  WIN32.HWND;
  msg   :  WINUSER.MSG;
  wc    :  WINUSER.WNDCLASSEX;
  cxChar:  INTEGER;
  cyChar:  INTEGER;
  cxCaps:  INTEGER;

CONST NUMLINES = 20;

TYPE
  Dev   =  RECORD
             iIndex   : INTEGER;
             szLabel  : ARRAY [0..20] OF CHAR;
             szDesc   : ARRAY [0..50] OF CHAR;
           END;
  DevCaps=  ARRAY[0..NUMLINES-1] OF Dev;
CONST
devcaps = DevCaps
{
         {WINGDI.HORZSIZE,      "HORZSIZE",     "Width in millimeters:"},
         {WINGDI.VERTSIZE,      "VERTSIZE",     "Height in millimeters:"},
         {WINGDI.HORZRES,       "HORZRES",      "Width in pixels:"},
         {WINGDI.VERTRES,       "VERTRES",      "Height in raster lines:"},
         {WINGDI.BITSPIXEL,     "BITSPIXEL",    "Color bits per pixel:"},
         {WINGDI.PLANES,        "PLANES",       "Number of color planes:"},
         {WINGDI.NUMBRUSHES,    "NUMBRUSHES",   "Number of device brushes:"},
         {WINGDI.NUMPENS,       "NUMPENS",      "Number of device pens:"},
         {WINGDI.NUMMARKERS,    "NUMMARKERS",   "Number of device markers:"},
         {WINGDI.NUMFONTS,      "NUMFONTS",     "Number of device fonts:"},
         {WINGDI.NUMCOLORS,     "NUMCOLORS",    "Number of device colors:"},
         {WINGDI.PDEVICESIZE,   "PDEVICESIZE",  "Size of device structure:"},
         {WINGDI.ASPECTX,       "ASPECTX",      "Relative width of pixel:"},
         {WINGDI.ASPECTY,       "ASPECTY",      "Relative height of pixel:"},
         {WINGDI.ASPECTXY,      "ASPECTXY",     "Relative diagonal of pixel:"},
         {WINGDI.LOGPIXELSX,    "LOGPIXELSX",   "Horizontal dots per inch:"},
         {WINGDI.LOGPIXELSY,    "LOGPIXELSY",   "Vertical dots per inch:"},
         {WINGDI.SIZEPALETTE,   "SIZEPALETTE",  "Number of palette entries:"},
         {WINGDI.NUMRESERVED,   "NUMRESERVED",  "Reserved palette entries:"},
         {WINGDI.COLORRES,      "COLORRES",     "Actual color resolution:"}
};

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  szBuffer : ARRAY[0..9] OF CHAR;
  i     :  INTEGER;
  hdc   :  WIN32.HDC;
  ps    :  WINUSER.PAINTSTRUCT;
  tm    :  WINGDI.TEXTMETRIC;

BEGIN
     CASE (iMsg) OF

          | WINUSER.WM_CREATE:
               hdc := WINUSER.GetDC (hwnd);

               WINGDI.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               IF(tm.tmPitchAndFamily=1) THEN
                 cxCaps := 3*cxChar/2;
               ELSE
                 cxCaps := 2*cxChar/2;
               END;
               cyChar := tm.tmHeight + tm.tmExternalLeading;

               WINUSER.ReleaseDC (hwnd, hdc);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               FOR i := 0 TO NUMLINES-1 DO
                    WINGDI.TextOut (hdc, cxChar, cyChar * (1 + i),
                             devcaps[i].szLabel,
                             LENGTH(devcaps[i].szLabel));

                    WINGDI.TextOut (hdc, cxChar + 22 * cxCaps, cyChar * (1 + i),
                             devcaps[i].szDesc,
                             LENGTH(devcaps[i].szDesc));

                    WINGDI.SetTextAlign (hdc, WINGDI.TA_RIGHT BOR WINGDI.TA_TOP);

                    WINGDI.TextOut (hdc, cxChar + 22 * cxCaps + 40 * cxChar,
                                         cyChar * (1 + i), szBuffer,
                             WINUSER.wsprintf (szBuffer, "%5d",
                                  WINGDI.GetDeviceCaps (hdc, devcaps[i].iIndex)));

                    WINGDI.SetTextAlign (hdc, WINGDI.TA_LEFT BOR WINGDI.TA_TOP);
               END;

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE

           RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "Device Capabilities, Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END DevCaps1.
