<*/NOWARN:F*>

MODULE EMF2;
(*-------------------------------------
   EMF2.C          --- Enhanced Metafile Demo #2
                   (c) Charles Petzold, 1996
   EMF2.mod        --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
CONST szAppName = "EMF2";
VAR
  hwnd  :  WIN32.HWND;
  msg   :  WINUSER.MSG;
  wc    :  WINUSER.WNDCLASSEX;
  hemf  :  WIN32.HENHMETAFILE;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  hdc   :  WIN32.HDC;
  hdcEMF:  WIN32.HDC;
  ps    :  WINUSER.PAINTSTRUCT;
  rect  :  WIN32.RECT;
CONST
  msg1  =  "EMF2"+""+"EMF Demo #2";
	

BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE:
               hdcEMF := WINGDI.CreateEnhMetaFile (NIL, "emf2.emf", WINX.NIL_RECT,msg1);

               WINGDI.Rectangle (hdcEMF, 100, 100, 200, 200);

               WINGDI.MoveToEx  (hdcEMF, 100, 100, WINX.NIL_POINT);
               WINGDI.LineTo    (hdcEMF, 200, 200);

               WINGDI.MoveToEx  (hdcEMF, 200, 100, WINX.NIL_POINT);
               WINGDI.LineTo    (hdcEMF, 100, 200);

               hemf := WINGDI.CloseEnhMetaFile (hdcEMF);

               WINGDI.DeleteEnhMetaFile (hemf);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINUSER.GetClientRect (hwnd, rect);

               rect.left   :=     rect.right  DIV 4;
               rect.right  := 3 * rect.right  DIV 4;
               rect.top    :=     rect.bottom DIV 4;
               rect.bottom := 3 * rect.bottom DIV 4;

               hemf := WINGDI.GetEnhMetaFile ("emf2.emf");

               WINGDI.PlayEnhMetaFile (hdc, hemf, rect);

               WINGDI.DeleteEnhMetaFile (hemf);

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
           RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "Enhanced Metafile Demo #2: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END EMF2.
