<*/NOWARN:F*>
MODULE EndJoin;
(*----------------------------------------
   ENDJOIN.C       --- Ends and Joins Demo
                   (c) Charles Petzold, 1996
   EndJoin.C       --- Translation to Stony Brook Modula-2 by
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;

CONST
  szAppName  =  "EndJoin";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   iEnd            :  ARRAY[0..2] OF INTEGER =
                             { WINGDI.PS_ENDCAP_ROUND, WINGDI.PS_ENDCAP_SQUARE,
                              WINGDI.PS_ENDCAP_FLAT };
   iJoin           :  ARRAY[0..2] OF INTEGER =
                             { WINGDI.PS_JOIN_ROUND,   WINGDI.PS_JOIN_BEVEL,
                              WINGDI.PS_JOIN_MITER };
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  hdc     :  WIN32.HDC;
  i       :  INTEGER;
  lb      :  WINGDI.LOGBRUSH;
  ps      :  WINUSER.PAINTSTRUCT;

BEGIN

  CASE (iMsg)  OF
          | WINUSER.WM_SIZE:
               cxClient := WINUSER.LOWORD (lParam);
               cyClient := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINGDI.SetMapMode (hdc, WINGDI.MM_ANISOTROPIC);
               WINGDI.SetWindowExtEx (hdc, 100, 100, WINX.NIL_SIZE);
               WINGDI.SetViewportExtEx (hdc, cxClient, cyClient, WINX.NIL_SIZE);

               lb.lbStyle := WINGDI.BS_SOLID;
               lb.lbColor := WINGDI.RGB (128, 128, 128);
               lb.lbHatch := 0;


               FOR i := 0 TO 3-1 DO
                    WINGDI.SelectObject (hdc,
                         SYSTEM.CAST(WIN32.HGDIOBJ,WINGDI.ExtCreatePen (WINGDI.PS_SOLID BOR WINGDI.PS_GEOMETRIC BOR
                                       iEnd [i] BOR iJoin [i], 10,
                                       lb, 0, WINX.NIL_DWORD)));

                    WINGDI.BeginPath (hdc);

                    WINGDI.MoveToEx (hdc, 10 + 30 * i, 25, WINX.NIL_POINT);
                    WINGDI.LineTo   (hdc, 20 + 30 * i, 75);
                    WINGDI.LineTo   (hdc, 30 + 30 * i, 25);


                    WINGDI.EndPath (hdc);

                    WINGDI.StrokePath (hdc);

                    WINGDI.DeleteObject (
                         WINGDI.SelectObject (hdc,
                              WINGDI.GetStockObject (WINGDI.BLACK_PEN)));

                    WINGDI.MoveToEx (hdc, 10 + 30 * i, 25, WINX.NIL_POINT);
                    WINGDI.LineTo   (hdc, 20 + 30 * i, 75);
                    WINGDI.LineTo   (hdc, 30 + 30 * i, 25);
               END;


               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE

          RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW   + WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Ends and Joins Demo: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END EndJoin.
