<*/NOWARN:F*>
MODULE LineDemo;
(*--------------------------------------------------
   LINEDEMO.C      --- Line-Drawing Demonstration Program
                   (c) Charles Petzold, 1996
   LineDemo.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  --------------------------------------------------*)
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;

CONST
  szAppName  =  "LineDemo";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  hdc     :  WIN32.HDC;
  ps      :  WINUSER.PAINTSTRUCT;

BEGIN

  CASE (iMsg)  OF
          | WINUSER.WM_SIZE:
               cxClient := WINUSER.LOWORD (lParam);
               cyClient := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINGDI.Rectangle (hdc,     cxClient DIV 8,     cyClient DIV 8,
                                      7 * cxClient DIV 8, 7 * cyClient DIV 8);

               WINGDI.MoveToEx  (hdc,        0,        0, WINX.NIL_POINT);
               WINGDI.LineTo    (hdc, cxClient, cyClient);

               WINGDI.MoveToEx  (hdc,        0, cyClient, WINX.NIL_POINT);
               WINGDI.LineTo    (hdc, cxClient,        0);

               WINGDI.Ellipse   (hdc,     cxClient DIV 8,     cyClient DIV 8,
                                      7 * cxClient DIV 8, 7 * cyClient DIV 8);

               WINGDI.RoundRect (hdc,     cxClient DIV 4,     cyClient DIV 4,
                                      3 * cxClient DIV 4, 3 * cyClient DIV 4,
                                          cxClient DIV 4,     cyClient DIV 4);

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Line Demonstration: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END LineDemo.
