<*/NOWARN:F*>
(*----------------------------------------------
   METAFILE.C      ---  Metafile Demonstration Program
                   (c)  Charles Petzold, 1996
   MetaFile.mod    ---  Translation to Stony Brook Modula-2
                   (c)  Peter Stadler,   1997
  ----------------------------------------------*)
MODULE MetaFile;

IMPORT WIN32;
IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WINX;
IMPORT SYSTEM;

CONST AppName = "MetaFile";
VAR
  hwnd     :   WIN32.HWND;
  msg      :   WINUSER.MSG;
  wc       :   WINUSER.WNDCLASSEX;
VAR (* static in WndProc *)
  hmf      :   WIN32.HMETAFILE;
  cxClient :   INTEGER;
  cyClient :   INTEGER;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++**********************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(***************************************************************************)
VAR
   hBrush         :   WIN32.HBRUSH;
   hdc            :   WIN32.HDC;
   hdcMeta        :   WIN32.HDC;
   x              :   INTEGER;
   y              :   INTEGER;
   ps             :   WINUSER.PAINTSTRUCT;
BEGIN

  CASE (iMsg) OF
  | WINUSER.WM_CREATE:
       hdcMeta := WINGDI.CreateMetaFile (WINX.NIL_ASTR);
       hBrush  := WINGDI.CreateSolidBrush (WINGDI.RGB (0, 0, 255));

       WINGDI.Rectangle (hdcMeta, 0, 0, 100, 100);

       WINGDI.MoveToEx (hdcMeta,   0,   0, WINX.NIL_POINT);
       WINGDI.LineTo   (hdcMeta, 100, 100);
       WINGDI.MoveToEx (hdcMeta,   0, 100, WINX.NIL_POINT);
       WINGDI.LineTo   (hdcMeta, 100,   0);

       WINGDI.SelectObject (hdcMeta, SYSTEM.CAST(WIN32.HGDIOBJ,hBrush));
       WINGDI.Ellipse (hdcMeta, 20, 20, 80, 80);

       hmf := WINGDI.CloseMetaFile (hdcMeta);

       WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hBrush));
       RETURN 0;

  | WINUSER.WM_SIZE:
       cxClient := WINUSER.LOWORD (lParam);
       cyClient := WINUSER.HIWORD (lParam);
       RETURN 0;

  | WINUSER.WM_PAINT:
      hdc := WINUSER.BeginPaint (hwnd, ps);

      WINGDI.SetMapMode (hdc,WINGDI.MM_ANISOTROPIC);
      WINGDI.SetWindowExtEx (hdc, 1000, 1000, WINX.NIL_SIZE);
      WINGDI.SetViewportExtEx (hdc, cxClient, cyClient, WINX.NIL_SIZE);

      FOR  x := 0 TO 10-1 DO
           FOR y := 0 TO 10-1 DO
                WINGDI.SetWindowOrgEx (hdc, -100 * x, -100 * y,WINX.NIL_POINT);
                WINGDI.PlayMetaFile (hdc, hmf);
           END;
      END;

      WINUSER.EndPaint (hwnd, ps);
      RETURN 0;

  | WINUSER.WM_DESTROY:
      WINGDI.DeleteMetaFile (hmf);
      WINUSER.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;
<*/POP*>
(*+++******************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(AppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx (wc);
  RETURN rc #0;
END InitApplication;

(*+++******************************************************************)
PROCEDURE InitMainWindow() : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (AppName,
                       "MetaFile Demonstration: Translation to Stony Brook Modula-2",
                       WINUSER.WS_OVERLAPPEDWINDOW,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       WINX.Instance,
                       NIL);

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (WINUSER.GetMessage (msg, NIL, 0, 0)) DO
      WINUSER.TranslateMessage (msg);
      WINUSER.DispatchMessage (msg);
    END;
  END;
END MetaFile.
