<*/NOWARN:F*>
MODULE SCRAMBLE;
(*------------------------------------------------
   SCRAMBLE.C   -- Scramble (and Unscramble) Screen
                   (c) Charles Petzold, 1996
   SCRAMBLE.MOD -- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT Lib;

CONST NUM = 200;

VAR
  iKeep   : ARRAY[0..NUM-1],[0..3] OF INTEGER;
  hdc     : WIN32.HDC;
  hdcMem  : WIN32.HDC;
  cx      : INTEGER;
  cy      : INTEGER;
  hBitmap : WIN32.HBITMAP;
  i       : INTEGER;
  j       : INTEGER;
  x1      : INTEGER;
  y1      : INTEGER;
  x2      : INTEGER;
  y2      : INTEGER;
BEGIN

     IF (WINUSER.LockWindowUpdate (WINUSER.GetDesktopWindow ())) THEN
          hdc     := WINGDI.CreateDC ("DISPLAY", "", "", WINX.NIL_DEVMODEA) ;
          hdcMem  := WINGDI.CreateCompatibleDC (hdc) ;
          cx  := WINUSER.GetSystemMetrics (WINUSER.SM_CXSCREEN) / 10 ;
          cy  := WINUSER.GetSystemMetrics (WINUSER.SM_CYSCREEN) / 10 ;
          hBitmap := WINGDI.CreateCompatibleBitmap (hdc, cx, cy) ;

          WINGDI.SelectObject (hdcMem, SYSTEM.CAST(WIN32.HGDIOBJ,hBitmap)) ;

          (*srand ((int) GetCurrentTime ()) ;*)

          FOR i := 0  TO 2-1 DO
               FOR  j := 0 TO NUM-1 DO
                    IF (i = 0) THEN
                         x1 := cx * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,0] := x1;
                         y1 := cy * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,1] := y1;
                         x2 := cx * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,2] := x2;
                         y2 := cy * VAL(INTEGER,(Lib.RANDOM (10) MOD 10));
                         iKeep [j,3] := y2;
                    ELSE
                         x1 := iKeep [NUM - 1 - j] [0] ;
                         y1 := iKeep [NUM - 1 - j] [1] ;
                         x2 := iKeep [NUM - 1 - j] [2] ;
                         y2 := iKeep [NUM - 1 - j] [3] ;
                    END;
                    WINGDI.BitBlt (hdcMem, 0, 0, cx, cy, hdc,  x1, y1, WINGDI.SRCCOPY) ;
                    WINGDI.BitBlt (hdc,  x1, y1, cx, cy, hdc,  x2, y2, WINGDI.SRCCOPY) ;
                    WINGDI.BitBlt (hdc,  x2, y2, cx, cy, hdcMem, 0, 0, WINGDI.SRCCOPY) ;

                    WIN32.Sleep (10) ;
               END;
          END;
          WINGDI.DeleteDC (hdcMem) ;
          WINGDI.DeleteDC (hdc) ;
          WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hBitmap));

          WINUSER.LockWindowUpdate (NIL) ;
     END;
END SCRAMBLE.
