<*/NOWARN:F*>

MODULE SineWave;
(*-----------------------------------------
   SINEWAVE.C      --- Sine Wave Using Polyline
                   (c) Charles Petzold, 1996
   SineWave.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)


IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT Lib;
IMPORT RealMath;


CONST NUM =  1000;
CONST TWOPI = (2.0 * 3.14159);

CONST szAppName = "SineWave";
VAR
  hwnd  :  WIN32.HWND;
  msg   :  WINUSER.MSG;
  wc    :  WINUSER.WNDCLASSEX;
  cxClient : INTEGER;
  cyClient : INTEGER;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  hdc   :  WIN32.HDC;
  i     :  INTEGER;
  ps    :  WINUSER.PAINTSTRUCT;
  pt    :  ARRAY[0..NUM] OF WIN32.POINT;

BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_SIZE:
               cxClient := WINUSER.LOWORD (lParam);
               cyClient := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINGDI.MoveToEx (hdc, 0,        cyClient / 2, WINX.NIL_POINT);
               WINGDI.LineTo   (hdc, cxClient, cyClient / 2);

               FOR i := 0 TO NUM-1 DO
                    pt[i].x := i * cxClient / NUM;
                    pt[i].y := VAL(INTEGER,(FLOAT(cyClient) / 2.0 * (1.0 - RealMath.sin(TWOPI * FLOAT(i) / FLOAT(NUM)))));
               END;

               WINGDI.Polyline (hdc, pt, NUM);

               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE

               RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);

     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "Sine Wave Using Polyline: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END SineWave.
