<*/NOWARN:F*>

MODULE WhatSize;
(*-----------------------------------------
   WHATSIZE.C   -- What Size is the Window?
                 (c) Charles Petzold, 1996
   WhatSize.MOD -- Translation to Stony Brook Modula-2
                 (c) Peter Stadler 27.09.1997
  -----------------------------------------                                  *)


IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;

CONST szAppName = "WhatSize";
VAR
  hwnd  :  WIN32.HWND;
  msg   :  WINUSER.MSG;
  wc    :  WINUSER.WNDCLASSEX;
CONST             szHeading     =
                    "Mapping Mode            Left   Right     Top  Bottom";
                  szUndLine     =
                    "************            ***-   ***--     ***  ******";
VAR
   cxChar, cyChar : INTEGER;
(*++++*****************************************************************)
PROCEDURE Show (hwnd : WIN32.HWND; hdc : WIN32.HDC; xText,yText : INTEGER; iMapMode : INTEGER;
                szMapMode : ARRAY OF CHAR);
(**********************************************************************)
VAR
  szBuffer : ARRAY[0..59] OF CHAR;
  rect     : WIN32.RECT;
TYPE 
  PointArray = ARRAY[0..1] OF WIN32.POINT;
BEGIN
     WINGDI.SaveDC (hdc);

     WINGDI.SetMapMode (hdc, iMapMode);
     WINUSER.GetClientRect (hwnd, rect);
     WINGDI.DPtoLP (hdc, SYSTEM.CAST(PointArray,rect), 2);

     WINGDI.RestoreDC (hdc, -1);

     WINGDI.TextOut (hdc, xText, yText, szBuffer,
               WINUSER.wsprintf (szBuffer, "%-20s %7d %7d %7d %7d", SYSTEM.ADR(szMapMode),
                    rect.left, rect.right, rect.top, rect.bottom));
END Show;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  hdc   :  WIN32.HDC;
  ps    :  WINUSER.PAINTSTRUCT;
  tm    :  WINGDI.TEXTMETRIC;

BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE:
               hdc := WINUSER.GetDC (hwnd);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));

               WINGDI.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               cyChar := tm.tmHeight + tm.tmExternalLeading;

               WINUSER.ReleaseDC (hwnd, hdc);
               RETURN 0;

          | WINUSER.WM_PAINT:
               hdc := WINUSER.BeginPaint (hwnd, ps);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));

               WINGDI.SetMapMode (hdc, WINGDI.MM_ANISOTROPIC);
               WINGDI.SetWindowExtEx (hdc, 1, 1, WINX.NIL_SIZE);
               WINGDI.SetViewportExtEx (hdc, cxChar, cyChar, WINX.NIL_SIZE);

               WINGDI.TextOut (hdc, 1, 1, szHeading, LENGTH(szHeading));
               WINGDI.TextOut (hdc, 1, 2, szUndLine, LENGTH(szUndLine));

               Show (hwnd, hdc, 1, 3, WINGDI.MM_TEXT,      "TEXT (pixels)");
               Show (hwnd, hdc, 1, 4, WINGDI.MM_LOMETRIC,  "LOMETRIC (.1 mm)");
               Show (hwnd, hdc, 1, 5, WINGDI.MM_HIMETRIC,  "HIMETRIC (.01 mm)");
               Show (hwnd, hdc, 1, 6, WINGDI.MM_LOENGLISH, "LOENGLISH (.01 in)");
               Show (hwnd, hdc, 1, 7, WINGDI.MM_HIENGLISH, "HIENGLISH (.001 in)");
               Show (hwnd, hdc, 1, 8, WINGDI.MM_TWIPS,     "TWIPS (1\1440 in)");

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY:
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
          RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "What Size is the Window: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END WhatSize.
