<*/NOWARN:F*>

IMPLEMENTATION MODULE ezfont;
(*---------------------------------------
   EZFONT.C        --- Easy Font Creation
                   (c) Charles Petzold, 1996
   ezfont.mod      --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
   ---------------------------------------*)
IMPORT WIN32;  
IMPORT WINUSER;
IMPORT COMMDLG;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT Str;
IMPORT WINX;

PROCEDURE EzCreateFont (hdc            :  WIN32.HDC;
                        szFaceName     :  ARRAY OF CHAR;
                        iDeciPtHeight  :  INTEGER;
                        iDeciPtWidth   :  INTEGER;
                        iAttributes    :  INTEGER;
                        fLogRes        :  BOOLEAN) : WIN32.HFONT;
VAR
  cxDpi,cyDpi   :  REAL;
  hFont         :  WIN32.HFONT;
  lf            :  WINGDI.LOGFONT;
  pt            :  WIN32.POINT;
  tm            :  WINGDI.TEXTMETRIC;

BEGIN
     WINGDI.SaveDC (hdc);

     WINGDI.SetGraphicsMode (hdc, WINGDI.GM_ADVANCED);
     WINGDI.ModifyWorldTransform (hdc, WINX.NIL_XFORM, WINGDI.MWT_IDENTITY);
     WINGDI.SetViewportOrgEx (hdc, 0, 0, WINX.NIL_POINT);
     WINGDI.SetWindowOrgEx   (hdc, 0, 0, WINX.NIL_POINT);

     IF (fLogRes) THEN
          cxDpi := SYSTEM.CAST(REAL,WINGDI.GetDeviceCaps (hdc, WINGDI.LOGPIXELSX));
          cyDpi := SYSTEM.CAST(REAL,WINGDI.GetDeviceCaps (hdc, WINGDI.LOGPIXELSY));
     ELSE
          cxDpi := 25.4 * SYSTEM.CAST(REAL,WINGDI.GetDeviceCaps (hdc, WINGDI.HORZRES) /
                                  WINGDI.GetDeviceCaps (hdc, WINGDI.HORZSIZE));

          cyDpi := 25.4 * SYSTEM.CAST(REAL,WINGDI.GetDeviceCaps (hdc, WINGDI.VERTRES) /
                                  WINGDI.GetDeviceCaps (hdc, WINGDI.VERTSIZE));
     END;

     pt.x := VAL(INTEGER,FLOAT(iDeciPtWidth)  * cxDpi / 72.);
     pt.y := VAL(INTEGER,FLOAT(iDeciPtHeight) * cyDpi / 72.);

     WINGDI.DPtoLP (hdc, pt, 1);

     lf.lfHeight         := - VAL(INTEGER,FLOAT(ABS(pt.y)) / 10.0 + 0.5);
     lf.lfWidth          := 0;
     lf.lfEscapement     := 0;
     lf.lfOrientation    := 0;

     IF (iAttributes - EZ_ATTR_BOLD=1) THEN
       lf.lfWeight := 700;
     ELSE
       lf.lfWeight := 0;
     END;

     IF (iAttributes - EZ_ATTR_ITALIC=1) THEN
       lf.lfItalic := TRUE;
     ELSE
       lf.lfItalic := FALSE;
     END;

     IF (iAttributes - EZ_ATTR_UNDERLINE=1) THEN
       lf.lfUnderline := TRUE;
     ELSE
       lf.lfUnderline := FALSE;
     END;

     IF (iAttributes - EZ_ATTR_STRIKEOUT=1) THEN
       lf.lfStrikeOut := TRUE;
     ELSE
       lf.lfStrikeOut := FALSE;
     END;

     lf.lfCharSet        := 0;
     lf.lfOutPrecision   := 0;
     lf.lfClipPrecision  := 0;
     lf.lfQuality        := 0;
     lf.lfPitchAndFamily := 0;

     Str.Copy(lf.lfFaceName, szFaceName);

     hFont := WINGDI.CreateFontIndirect (lf);

     IF (iDeciPtWidth # 0) THEN
          hFont := SYSTEM.CAST(WIN32.HFONT,WINGDI.SelectObject (hdc, SYSTEM.CAST(WIN32.HGDIOBJ,hFont)));

          WINGDI.GetTextMetrics (hdc, tm);

          WINGDI.DeleteObject (WINGDI.SelectObject (hdc, SYSTEM.CAST(WIN32.HGDIOBJ,hFont)));

          lf.lfWidth := VAL(INTEGER,FLOAT(tm.tmAveCharWidth) *
                              FLOAT(ABS(pt.x)) / FLOAT(ABS(pt.y)) + 0.5);

          hFont := WINGDI.CreateFontIndirect (lf);
     END;

     WINGDI.RestoreDC (hdc, -1);

     RETURN hFont;
END EzCreateFont;
BEGIN
END ezfont.
