<*/NOWARN:F*>
(*-----------------------------------------
   BLOKOUT1.C      --- Mouse Button Demo Program
                   (c) Charles Petzold, 1996
   BlokOut1.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)
MODULE BlokOut2;
IMPORT WINUSER;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT SYSTEM;

CONST
   szAppName = "BlokOut2";
VAR
  hwnd       :  WIN32.HWND;
  msg        :  WINUSER.MSG;
  wc         :  WINUSER.WNDCLASSEX;
  fBlocking  :  BOOLEAN;
  fValidBox  :  BOOLEAN;
  ptBeg      :  WIN32.POINT;
  ptEnd      :  WIN32.POINT;
  ptBoxBeg   :  WIN32.POINT;
  ptBoxEnd   :  WIN32.POINT;

(*++++**********************************************************************)
PROCEDURE DrawBoxOutline (hwnd : WIN32.HWND; ptBeg,ptEnd : WIN32.POINT);
(***************************************************************************)
VAR
  hdc  :  WIN32.HDC;

BEGIN
     hdc := WINUSER.GetDC (hwnd);

     WINGDI.SetROP2 (hdc, WINGDI.R2_NOT);
     WINGDI.SelectObject (hdc, WINGDI.GetStockObject (0));
     WINGDI.Rectangle (hdc, ptBeg.x, ptBeg.y, ptEnd.x, ptEnd.y);

     WINUSER.ReleaseDC (hwnd, hdc);
END DrawBoxOutline;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++**********************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(***************************************************************************)
VAR
  hdc     :  WIN32.HDC;
  ps      :  WINUSER.PAINTSTRUCT;
BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_LBUTTONDOWN :
               ptBeg.x := WINUSER.LOWORD (lParam);
               ptEnd.x := WINUSER.LOWORD (lParam);
               ptBeg.y := WINUSER.HIWORD (lParam);
               ptEnd.y := WINUSER.HIWORD (lParam);

               DrawBoxOutline (hwnd, ptBeg, ptEnd);
               WINUSER.SetCapture(hwnd);
               WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_CROSS^));

               fBlocking := TRUE;
               RETURN 0;

          | WINUSER.WM_MOUSEMOVE :
               IF (fBlocking) THEN
                    WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_CROSS^));

                    DrawBoxOutline (hwnd, ptBeg, ptEnd);

                    ptEnd.x := WINUSER.LOWORD (lParam);
                    ptEnd.y := WINUSER.HIWORD (lParam);

                    DrawBoxOutline (hwnd, ptBeg, ptEnd);
               END;
               RETURN 0;

          | WINUSER.WM_LBUTTONUP :
               IF (fBlocking) THEN
                    DrawBoxOutline (hwnd, ptBeg, ptEnd);

                    ptBoxBeg   := ptBeg;
                    ptBoxEnd.x := WINUSER.LOWORD (lParam);
                    ptBoxEnd.y := WINUSER.HIWORD (lParam);

                    WINUSER.ReleaseCapture();
                    WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^));

                    fBlocking := FALSE;
                    fValidBox  := TRUE;

                    WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
               END;
               RETURN 0;

          | WINUSER.WM_CHAR :
               IF (VAL(WIN32.UINT,fBlocking) BAND wParam = 27) THEN       (* ie, Escape           *)
                    DrawBoxOutline (hwnd, ptBeg, ptEnd);
                    WINUSER.ReleaseCapture();
                    WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^));

                    fBlocking := FALSE;
               END;
               RETURN 0;

          | WINUSER.WM_PAINT :
               hdc := WINUSER.BeginPaint (hwnd, ps);

               IF (fValidBox) THEN
                    WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.BLACK_BRUSH));
                    WINGDI.Rectangle (hdc, ptBoxBeg.x, ptBoxBeg.y,
                                    ptBoxEnd.x, ptBoxEnd.y);
               END;

               IF (fBlocking) THEN
                    WINGDI.SetROP2 (hdc, WINGDI.R2_NOT);
                    WINGDI.SelectObject (hdc, WINGDI.GetStockObject (0));
                    WINGDI.Rectangle (hdc, ptBeg.x, ptBeg.y, ptEnd.x, ptEnd.y);
               END;

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
        RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
BEGIN
  wc.cbSize         := SIZE(WINUSER.WNDCLASSEX);
  wc.style          := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := WINX.Instance;
  wc.hIcon          := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor        := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground  := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := WINUSER.CreateWindow (szAppName,
                       "Mouse Button & Capture Demo: Translation to Stony Brook Modula-2",
                       WINUSER.WS_OVERLAPPEDWINDOW,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (WINUSER.GetMessage (msg, NIL, 0, 0)) DO
      WINUSER.TranslateMessage (msg);
      WINUSER.DispatchMessage (msg);
    END;
  END;
END BlokOut2.
