<*/NOWARN:F*>
(*-------------------------------------------------
   CHECKER3.C      --- Mouse Hit-Test Demo Program No. 3
                   (c) Charles Petzold, 1996
   Checker3.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------------------*)
MODULE Checker3;
IMPORT WINUSER;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT SYSTEM;

CONST
   szAppName = "Checker3";
   szChildClass = "Checker3_Child";
   DIVISIONS=5;
VAR
  hwnd       :  WIN32.HWND;
  msg        :  WINUSER.MSG;
  wc         :  WINUSER.WNDCLASSEX;
VAR
  hwndChild  :  ARRAY[0..DIVISIONS-1],[0..DIVISIONS-1] OF WIN32.HWND;
  
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++**********************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(***************************************************************************)
VAR
  x       :  INTEGER;
  y       :  INTEGER;
  cxBlock :  INTEGER;
  cyBlock :  INTEGER;
BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               FOR x := 0 TO DIVISIONS-1 DO
                    FOR y := 0 TO DIVISIONS-1 DO
                         hwndChild[x][y] := WINUSER.CreateWindow (szChildClass, "",
                              WINUSER.WS_CHILDWINDOW BOR WINUSER.WS_VISIBLE,
                              0, 0, 0, 0,
                              hwnd, SYSTEM.CAST(WIN32.HMENU, (y SHL 8 BOR x)),
                              SYSTEM.CAST(WIN32.HINSTANCE,WINUSER.GetWindowLong (hwnd,WINUSER.GWL_HINSTANCE)),
                              NIL);
                    END;
               END;
               RETURN 0;

          | WINUSER.WM_SIZE :
               cxBlock := VAL(INTEGER,WINUSER.LOWORD (lParam)) DIV DIVISIONS;
               cyBlock := VAL(INTEGER,WINUSER.HIWORD (lParam)) DIV DIVISIONS;

               FOR x := 0 TO DIVISIONS-1 DO
                    FOR y := 0 TO DIVISIONS-1 DO
                         WINUSER.MoveWindow (hwndChild[x][y],
                              x * cxBlock, y * cyBlock,
                              cxBlock, cyBlock, TRUE);
                    END;
               END;
               RETURN 0;

          | WINUSER.WM_LBUTTONDOWN :
               WINUSER.MessageBeep (0);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++**********************************************************************)
PROCEDURE ChildWndProc (hwnd        : WIN32.HWND;
                        iMsg        : WIN32.UINT;
                        wParam      : WIN32.WPARAM;
                        lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(***************************************************************************)
VAR
  hdc     :  WIN32.HDC;
  ps      :  WINUSER.PAINTSTRUCT;
  rect    :  WIN32.RECT;
BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               WINUSER.SetWindowWord (hwnd, 0, 0);       (* on\off flag               *)
               RETURN 0;

          | WINUSER.WM_LBUTTONDOWN :
               WINUSER.SetWindowWord (hwnd, 0, 1 BXOR WINUSER.GetWindowWord (hwnd, 0));
               WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, FALSE);
               RETURN 0;

          | WINUSER.WM_PAINT :
               hdc := WINUSER.BeginPaint (hwnd, ps);

               WINUSER.GetClientRect (hwnd, rect);
               WINGDI.Rectangle (hdc, 0, 0, rect.right, rect.bottom);

               IF (WINUSER.GetWindowWord (hwnd, 0)=1) THEN
                    WINGDI.MoveToEx (hdc, 0,          0,WINX.NIL_POINT);
                    WINGDI.LineTo (hdc, rect.right, rect.bottom);
                    WINGDI.MoveToEx (hdc, 0,          rect.bottom,WINX.NIL_POINT);
                    WINGDI.LineTo (hdc, rect.right, 0);
                END;

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END ChildWndProc;
<*/POP*>
(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize         := SIZE(WINUSER.WNDCLASSEX);
  wc.style          := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := WINX.Instance;
  wc.hIcon          := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor        := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground  := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  rc := WINUSER.RegisterClassEx(wc);

  wc.lpfnWndProc    := ChildWndProc;
  wc.cbWndExtra     := SIZE(WIN32.WORD);
  wc.hIcon          := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szChildClass);
  wc.hIconSm        := NIL;
  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := WINUSER.CreateWindow (szAppName,
                       "Checker3 Mouse Hit-Test Demo: Translation to Stony Brook Modula-2",
                       WINUSER.WS_OVERLAPPEDWINDOW,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (WINUSER.GetMessage (msg, NIL, 0, 0)) DO
      WINUSER.TranslateMessage (msg);
      WINUSER.DispatchMessage (msg);
    END;
  END;
END Checker3.
