<*/NOWARN:F*>
(*--------------------------------------------------------------
   CONNECT.C       --- Connect-the-Dots Mouse Demo Program
                   (c) Charles Petzold, 1996
   Connect.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------------------------*)
MODULE Connect;
IMPORT WINUSER;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT SYSTEM;

CONST
   MAXPOINTS  = 1000;
CONST
   szAppName = "Connect_the_Dots";

 VAR
  hwnd       :  WIN32.HWND;
  msg        :  WINUSER.MSG;
  wc         :  WINUSER.WNDCLASSEX;
  iCount     :  INTEGER;
  points     :  ARRAY[0..MAXPOINTS] OF WIN32.POINT;
  hdc        :  WIN32.HDC;
  ps         :  WINUSER.PAINTSTRUCT;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++**********************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(***************************************************************************)
VAR
  i,j     :  INTEGER;
BEGIN
  CASE (iMsg) OF
  | WINUSER.WM_LBUTTONDOWN :
      iCount  := 0;
      WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
      RETURN 0;
  | WINUSER.WM_MOUSEMOVE :
     IF (wParam BAND WINUSER.MK_LBUTTON=1)  AND (iCount < 1000) THEN
       points[iCount].x  := WINUSER.LOWORD (lParam);
       points[iCount].y  := WINUSER.HIWORD (lParam);
       INC(iCount);

       hdc  := WINUSER.GetDC (hwnd);
       WINGDI.SetPixel (hdc, WINUSER.LOWORD (lParam), WINUSER.HIWORD (lParam), 0000h);
       WINUSER.ReleaseDC (hwnd, hdc);
     END;
     RETURN 0;
  | WINUSER.WM_LBUTTONUP :
      WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, FALSE);
      RETURN 0;
  | WINUSER.WM_PAINT :
      hdc  := WINUSER.BeginPaint (hwnd, ps);
      WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_WAIT^));
      WINUSER.ShowCursor (TRUE);
      FOR i := 0 TO iCount - 2 DO
        FOR j  := i + 1 TO  iCount-1 DO
          WINGDI.MoveToEx (hdc, points[i].x, points[i].y,WINX.NIL_POINT);
          WINGDI.LineTo (hdc, points[j].x, points[j].y);
        END;
      END;
      WINUSER.ShowCursor (FALSE);
      WINUSER.SetCursor (WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^));
      WINUSER.EndPaint (hwnd, ps);
      RETURN 0;
  | WINUSER.WM_DESTROY :
      WINUSER.PostQuitMessage (0);
      RETURN 0;
  ELSE
    RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
END WndProc;
<*/POP*>
(*+++***********************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(***************************************************************************)
BEGIN
  wc.cbSize         := SIZE(WINUSER.WNDCLASSEX);
  wc.style          := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc    := WndProc;
  wc.cbClsExtra     := 0;
  wc.cbWndExtra     := 0;
  wc.hInstance      := WINX.Instance;
  wc.hIcon          := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor        := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground  := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName   := NIL;
  wc.lpszClassName  := SYSTEM.ADR(szAppName);
  wc.hIconSm        := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;
(*+++***********************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(***************************************************************************)
BEGIN
  hwnd  := WINUSER.CreateWindow (szAppName,
                       "Connect-the-Points Mouse Demo: Translation to Stony Brook Modula-2",
                       WINUSER.WS_OVERLAPPEDWINDOW,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       WINUSER.CW_USEDEFAULT,
                       NIL,
                       NIL,
                       wc.hInstance,
                       NIL);

  IF hwnd = NIL THEN
     RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
BEGIN
  IF InitApplication() AND InitMainWindow() THEN
    WHILE (WINUSER.GetMessage (msg, NIL, 0, 0)) DO
      WINUSER.TranslateMessage (msg);
      WINUSER.DispatchMessage (msg);
    END;
  END;
END Connect.
