<*/NOWARN:F*>
MODULE BtnLook;
(*----------------------------------------
   BTNLOOK.C       --- Button Look Program
                   (c) Charles Petzold, 1996
   BtnLook.MOD     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WINUSER;
IMPORT SYSTEM;


CONST
  szAppName    =  "BtnLook";

TYPE
  Button    =  RECORD
                 style  :  WIN32.LONG;
                 lpText :  WIN32.LPSTR;
               END;
  ButtonArr =   ARRAY[0..9] OF Button;



VAR
  button    :  ButtonArr;

CONST NUM = SIZE(button) DIV SIZE(button[0]);
VAR
  hwnd         :  WIN32.HWND;
  msg          :  WINUSER.MSG;
  wc           :  WINUSER.WNDCLASSEX;

(* static in WndProc *)
CONST
  szTop     = "iMsg            wParam       lParam";
  szUnd     = "____            ______       ______";
  szFormat  = "%-16s%04X-%04X    %04X-%04X";
VAR
  szBuffer  : ARRAY[0..49] OF CHAR;
  hwndButton: ARRAY[0..NUM-1] OF WIN32.HWND;
  rect      : WIN32.RECT;
  cxChar    : INTEGER;
  cyChar    : INTEGER;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  i    :  INTEGER;
  tm   :  WINGDI.TEXTMETRIC;
  hdc  :  WIN32.HDC;
  ps   :  WINUSER.PAINTSTRUCT;
  lpcr :  WINUSER.LPCREATESTRUCT;
BEGIN
  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hdc := WINUSER.GetDC (hwnd);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.GetTextMetrics (hdc, tm);
               cxChar := tm.tmAveCharWidth;
               cyChar := tm.tmHeight + tm.tmExternalLeading;
               WINUSER.ReleaseDC (hwnd, hdc);

               FOR i := 0 TO NUM-1 DO
	            lpcr := SYSTEM.CAST(WINUSER.LPCREATESTRUCT,lParam);
                    hwndButton[i] := WINUSER.CreateWindow ("button", button[i].lpText^,
                              WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR button[i].style,
                              cxChar, cyChar * (1 + 2 * i),
                              20 * cxChar, 7 * cyChar DIV 4,
                              hwnd, SYSTEM.CAST(WIN32.HMENU,i),
                              lpcr^.hInstance,
                              NIL);
               END;
               RETURN 0;

          | WINUSER.WM_SIZE :
               rect.left   := 24 * cxChar;
               rect.top    :=  2 * cyChar;
               rect.right  := WINUSER.LOWORD (lParam);
               rect.bottom := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_PAINT :
               WINUSER.InvalidateRect (hwnd, rect, TRUE);

               hdc := WINUSER.BeginPaint (hwnd, ps);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.SetBkMode (hdc, WINGDI.TRANSPARENT);

               WINGDI.TextOut (hdc, 24 * cxChar, cyChar, szTop, SIZE (szTop) - 1);
               WINGDI.TextOut (hdc, 24 * cxChar, cyChar, szUnd, SIZE (szUnd) - 1);

               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DRAWITEM :
               WINUSER.ScrollWindow (hwnd, 0, -cyChar, rect, rect);

               hdc := WINUSER.GetDC (hwnd);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.TextOut (hdc, 24 * cxChar, cyChar * (rect.bottom DIV cyChar - 1),
                        szBuffer,
                        WINUSER.wsprintf (szBuffer, szFormat,
                        "WM_DRAWITEM",
                        WINUSER.HIWORD (wParam), WINUSER.LOWORD (wParam),
                        WINUSER.HIWORD (lParam), WINUSER.LOWORD (lParam)));
               WINUSER.ReleaseDC (hwnd, hdc);
               WINUSER.ValidateRect (hwnd, rect);
               RETURN 0;
          | WINUSER.WM_COMMAND :
              WINUSER.ScrollWindow (hwnd, 0, -cyChar, rect, rect);

               hdc := WINUSER.GetDC (hwnd);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.TextOut (hdc, 24 * cxChar, cyChar * (rect.bottom DIV cyChar - 1),
                        szBuffer,
                        WINUSER.wsprintf (szBuffer, szFormat,
                        "WM_COMMAND",
                        WINUSER.HIWORD (wParam), WINUSER.LOWORD (wParam),
                        WINUSER.HIWORD (lParam), WINUSER.LOWORD (lParam)));
               WINUSER.ReleaseDC (hwnd, hdc);
               WINUSER.ValidateRect (hwnd, rect);
               RETURN 0;
          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
     RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;
<*/POP*>

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH,WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Button Look: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
   button := ButtonArr
   {
      {WINUSER.BS_PUSHBUTTON,      SYSTEM.ADR("PUSHBUTTON")},
      {WINUSER.BS_DEFPUSHBUTTON,   SYSTEM.ADR("DEFPUSHBUTTON")},
      {WINUSER.BS_CHECKBOX,        SYSTEM.ADR("CHECKBOX")},
      {WINUSER.BS_AUTOCHECKBOX,    SYSTEM.ADR("AUTOCHECKBOX")},
      {WINUSER.BS_RADIOBUTTON,     SYSTEM.ADR("RADIOBUTTON")},
      {WINUSER.BS_3STATE,          SYSTEM.ADR("3STATE")},
      {WINUSER.BS_AUTO3STATE,      SYSTEM.ADR("AUTO3STATE")},
      {WINUSER.BS_GROUPBOX,        SYSTEM.ADR("GROUPBOX")},
      {WINUSER.BS_AUTORADIOBUTTON, SYSTEM.ADR("AUTORADIO")},
      {WINUSER.BS_OWNERDRAW,       SYSTEM.ADR("OWNERDRAW")}
     };

  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END BtnLook.
