<*/NOWARN:F*>
MODULE Environ;
(*----------------------------------------
   ENVIRON.C       --- Environment List Box
                   (c) Charles Petzold, 1996
   Environ.MOD     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WINUSER;
IMPORT SYSTEM;
IMPORT Str;
IMPORT Environment;

CONST MAXENV =4096;
  szAppName    =  "Environ";
VAR
  hwnd         :  WIN32.HWND;
  msg          :  WINUSER.MSG;
  wc           :  WINUSER.WNDCLASSEX;
VAR
  lpszBuffer   :  WIN32.LPSTR;
  hwndList     :  WIN32.HWND;
  hwndText     :  WIN32.HWND;
  item         :  ARRAY[0..100] OF CHAR;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  i,j  :  INTEGER;
  tm   :  WINGDI.TEXTMETRIC;
  hdc  :  WIN32.HDC;
  ok   :  BOOLEAN;
BEGIN
  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hdc := WINUSER.GetDC (hwnd);
               WINGDI.GetTextMetrics (hdc, tm);
               WINUSER.ReleaseDC (hwnd, hdc);

               hwndList := WINUSER.CreateWindow ("listbox", "",
                              WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR WINUSER.LBS_STANDARD,
                              tm.tmAveCharWidth, tm.tmHeight * 3,
                              tm.tmAveCharWidth * 16 +
                              WINUSER.GetSystemMetrics (WINUSER.SM_CXVSCROLL),
                              tm.tmHeight * 5,
                              hwnd, SYSTEM.CAST(WIN32.HMENU,1),
                              SYSTEM.CAST(WIN32.HINSTANCE,WINUSER.GetWindowLong (hwnd, WINUSER.GWL_HINSTANCE)),
                              NIL);

               hwndText := WINUSER.CreateWindow ("static", "",
                              WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR WINUSER.SS_LEFT,
                              tm.tmAveCharWidth,          tm.tmHeight,
                              tm.tmAveCharWidth * MAXENV, tm.tmHeight,
                              hwnd, SYSTEM.CAST(WIN32.HMENU,2),
                              SYSTEM.CAST(WIN32.HINSTANCE,WINUSER.GetWindowLong (hwnd, WINUSER.GWL_HINSTANCE)),
                              NIL);


               lpszBuffer:= WIN32.GetEnvironmentStrings();
               i := 0;
	       item[0] := '';
               LOOP
                 LOOP
                   IF(lpszBuffer^[i]='') THEN
                     INC(i);
		     EXIT;
                   END;
                   Str.Append(item,lpszBuffer^[i]);
                   INC(i);
                 END;
                 IF(lpszBuffer^[i+1]='') THEN
                     EXIT;
                 END;
	         j := 0;
		 LOOP
		   IF(item[j]='=') THEN
		     item[j] := '';
		     EXIT;
		   END;  
                   INC(j);
		 END;
                 WINUSER.SendMessage (hwndList, WINUSER.LB_ADDSTRING, 0, SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(item)));
	
                 item[0] := '';
	       END;
               RETURN 0;

          | WINUSER.WM_SETFOCUS :
               WINUSER.SetFocus (hwndList);
               RETURN 0;

          | WINUSER.WM_COMMAND :
               IF (WINUSER.LOWORD (wParam) = 1) AND (WINUSER.HIWORD (wParam) = WINUSER.LBN_SELCHANGE) THEN
                    i := WINUSER.SendMessage (hwndList, WINUSER.LB_GETCURSEL, 0, 0);
                    i := WINUSER.SendMessage (hwndList, WINUSER.LB_GETTEXT, i,
                                               SYSTEM.CAST(WIN32.LPARAM,lpszBuffer));   
		    ok := Environment.GetSymbol(lpszBuffer^,item);
		    Str.Append(lpszBuffer^,'=');
		    Str.Append(lpszBuffer^,item);
                    WINUSER.SetWindowText (hwndText, lpszBuffer^);
               END;
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
          RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc  :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINUSER.COLOR_WINDOW+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

 rc := WINUSER.RegisterClassEx(wc);
 RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Environment List Box: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Environ.
