<*/NOWARN:F*>
MODULE Head;
(*---------------------------------------------
   HEAD.C          --- Displays beginning (head) of file
                   (c) Charles Petzold, 1996
   Head.mod        --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1998
  ---------------------------------------------*)
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WINUSER;
IMPORT SYSTEM;
IMPORT FIO;
IMPORT Str;

CONST
  MAXPATH  =  256;
  MAXREAD  = 8192;

CONST
  szAppName    =  "Head";

VAR
  hwnd         :  WIN32.HWND;
  msg          :  WINUSER.MSG;
  wc           :  WINUSER.WNDCLASSEX;
  bValidFile   :  BOOLEAN;
  sReadBuffer  :  ARRAY[0..MAXREAD-1] OF CHAR;
  szFile       :  ARRAY[0..MAXPATH-1] OF CHAR;
  hwndList     :  WIN32.HWND;
  hwndText     :  WIN32.HWND;
  rect         :  WIN32.RECT;
  fnOldList    :  WINUSER.WNDPROC;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  i       :  INTEGER;
  iHandle : INTEGER;
  tm      :  WINGDI.TEXTMETRIC;
  hdc     :  WIN32.HDC;
  ps      :  WINUSER.PAINTSTRUCT;
  szBuffer:  ARRAY[0..MAXPATH] OF CHAR;
BEGIN
  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hdc := WINUSER.GetDC (hwnd);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.GetTextMetrics (hdc, tm);
               WINUSER.ReleaseDC (hwnd, hdc);

               rect.left := 20 * tm.tmAveCharWidth;
               rect.top  :=  3 * tm.tmHeight;

               hwndList := WINUSER.CreateWindow ("listbox", "",
                              WINUSER.WS_CHILDWINDOW BOR WINUSER.WS_VISIBLE BOR WINUSER.LBS_STANDARD,
                              tm.tmAveCharWidth, tm.tmHeight * 3,
                              tm.tmAveCharWidth * 13 +
                                   WINUSER.GetSystemMetrics (WINUSER.SM_CXVSCROLL),
                              tm.tmHeight * 10,
                              hwnd, SYSTEM.CAST(WIN32.HMENU,1),
                              SYSTEM.CAST(WIN32.HINSTANCE, WINUSER.GetWindowLong (hwnd, WINUSER.GWL_HINSTANCE)),
                              NIL);
	       FIO.GetDir(1,szBuffer);
               hwndText := WINUSER.CreateWindow ("static",szBuffer ,
                              WINUSER.WS_CHILDWINDOW BOR WINUSER.WS_VISIBLE BOR WINUSER.SS_LEFT,
                              tm.tmAveCharWidth,           tm.tmHeight,
                              tm.tmAveCharWidth * MAXPATH, tm.tmHeight,
                              hwnd, SYSTEM.CAST(WIN32.HMENU,2),
                              SYSTEM.CAST(WIN32.HINSTANCE,WINUSER.GetWindowLong (hwnd, WINUSER.GWL_HINSTANCE)),
                              NIL);

               fnOldList := SYSTEM.CAST(WINUSER.WNDPROC,WINUSER.SetWindowLong (hwndList, WINUSER.GWL_WNDPROC,
                                                    SYSTEM.CAST(WIN32.LPARAM,ListProc)));

               WINUSER.SendMessage (hwndList, WINUSER.LB_DIR, 37h, SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR("*.*")));
               RETURN 0;

          | WINUSER.WM_SIZE :
               rect.right  := WINUSER.LOWORD (lParam);
               rect.bottom := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_SETFOCUS :
               WINUSER.SetFocus (hwndList);
               RETURN 0;

          | WINUSER.WM_COMMAND :
               IF (WINUSER.LOWORD (wParam)  = 1) AND (WINUSER.HIWORD (wParam) = WINUSER.LBN_DBLCLK) THEN
                    i := WINUSER.SendMessage (hwndList,WINUSER.LB_GETCURSEL, 0, 0h);
		    IF (WINUSER.LB_ERR # i) THEN
                      WINUSER.SendMessage (hwndList, WINUSER.LB_GETTEXT, i, SYSTEM.CAST(WIN32.LPARAM,szBuffer));

                      IF (0 # FIO.Open(szBuffer)) THEN
                         bValidFile := TRUE;
                         Str.Copy(szFile,szBuffer);
			 FIO.GetDir(1,szBuffer);
			 (*
                         IF (szBuffer [LENGTH (szBuffer)  - 1] # '( *') THEN
                              Str.Append(szBuffer, "( *");
                         END;
			 *)
                         Str.Append(szBuffer,szFile);
			 WINUSER.SetWindowText (hwndText, szBuffer);

                      ELSE

                         bValidFile := FALSE;
                         szBuffer [LENGTH(szBuffer) - 1] := '';
                         FIO.ChDir(szBuffer (* + 1*));
			 FIO.GetDir(1,szBuffer);
                         WINUSER.SetWindowText (hwndText, szBuffer);
                         WINUSER.SendMessage (hwndList, WINUSER.LB_RESETCONTENT, 0, 0h);
                         WINUSER.SendMessage (hwndList, WINUSER.LB_DIR, 37h, SYSTEM.CAST(WIN32.LONG, SYSTEM.ADR("*.*")));
                      END;
                      WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
	              RETURN 0;
		    END;
	       END;    

          | WINUSER.WM_PAINT :
               hdc := WINUSER.BeginPaint (hwnd, ps);
               WINGDI.SelectObject (hdc, WINGDI.GetStockObject (WINGDI.SYSTEM_FIXED_FONT));
               WINGDI.SetTextColor (hdc, WINUSER.GetSysColor (WINUSER.COLOR_BTNTEXT));
               WINGDI.SetBkColor   (hdc, WINUSER.GetSysColor (WINUSER.COLOR_BTNFACE));

               IF(szFile[0]#'') THEN
                 iHandle := FIO.Open(szFile);
	       ELSE
	         bValidFile := FALSE;
	       END;	 	 
	       IF (bValidFile) AND (0#iHandle ) THEN
                    i := FIO.RdBin(iHandle, sReadBuffer, MAXREAD);
                    FIO.Close (iHandle);
                    WINUSER.DrawText (hdc, sReadBuffer, i, rect, WINUSER.DT_WORDBREAK BOR
                                   WINUSER.DT_EXPANDTABS BOR WINUSER.DT_NOCLIP BOR WINUSER.DT_NOPREFIX);

               ELSE
                    bValidFile := FALSE;
               END;
               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>


<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE ListProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                    iMsg        : WIN32.UINT;
                    wParam      : WIN32.WPARAM;
                    lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
BEGIN
     IF (iMsg = WINUSER.WM_KEYDOWN) AND (wParam = WINUSER.VK_RETURN) THEN

          WINUSER.SendMessage (WINUSER.GetParent (hwnd), WINUSER.WM_COMMAND, 1,
                       WINUSER.MAKELONG (SYSTEM.CAST(WIN32.WORD,hwnd), WINUSER.LBN_DBLCLK));
     END;
     RETURN WINUSER.CallWindowProc (fnOldList, hwnd, iMsg, wParam, lParam);
END ListProc;
<*/POP*>

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH,WINUSER.COLOR_BTNFACE+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "File Head: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Head.
