<*/NOWARN:F*>
MODULE PopPad1;
(*-------------------------------------------------------
   POPPAD1.C       --- Popup Editor using child window edit box
                   (c) Charles Petzold, 1996
   PopPad1.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1998
  -------------------------------------------------------*)
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT WINUSER;
IMPORT SYSTEM;

CONST
  szAppName    =  "PopPad1";

VAR
  hwnd         :  WIN32.HWND;
  msg          :  WINUSER.MSG;
  wc           :  WINUSER.WNDCLASSEX;
  hwndEdit     :  WIN32.HWND;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  lpcr    : WINUSER.LPCREATESTRUCT;
BEGIN
  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               lpcr := SYSTEM.CAST(WINUSER.LPCREATESTRUCT,lParam);
               hwndEdit := WINUSER.CreateWindow ("edit",
                         "",
                         WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR WINUSER.WS_HSCROLL BOR WINUSER.WS_VSCROLL BOR
                              WINUSER.WS_BORDER BOR WINUSER.ES_LEFT BOR WINUSER.ES_MULTILINE BOR
                              WINUSER.ES_AUTOHSCROLL BOR WINUSER.ES_AUTOVSCROLL,
                         0,
                         0,
                         0,
                         0,
                         hwnd,
                         SYSTEM.CAST(WIN32.HMENU,1),
                         (* statt
                         (SYSTEM.CAST(WINUSER.LPCREATESTRUCT, lParam) ^. hInstance, NIL);
                         *)    
                         lpcr^.hInstance,
                         NIL);
                               
               RETURN 0;

          | WINUSER.WM_SETFOCUS :
               WINUSER.SetFocus (hwndEdit);
               RETURN 0;

          | WINUSER.WM_SIZE :
               WINUSER.MoveWindow (hwndEdit, 0, 0, WINUSER.LOWORD (lParam),
                                           WINUSER.HIWORD (lParam), TRUE);
               RETURN 0;

          | WINUSER.WM_COMMAND :
               IF (WINUSER.LOWORD (wParam) = 1) THEN
                    IF (WINUSER.HIWORD (wParam) = WINUSER.EN_ERRSPACE) OR
                       (WINUSER.HIWORD (wParam) = WINUSER.EN_MAXTEXT) THEN
                              WINUSER.MessageBox (hwnd, "Edit control out of space.",
                                          szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONSTOP);
                    END;
	       END;
	       RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc   :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH,WINGDI.GetStockObject(WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx(wc);
  RETURN rc#0;           END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "PopPad1: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END PopPad1.
