<*/NOWARN:F*>
MODULE Resourc1;
(*-----------------------------------------------------------
   RESOURC1.C      --- Icon and Cursor Demonstration Program No. 1
                   (c) Charles Petzold, 1996
   Resourc1.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------------------------*)

%IF WIN32 %THEN
    <*/Resource:Resourc1.RES*>
%ELSE
%END
IMPORT WIN32;
IMPORT WINGDI;
IMPORT WINUSER;
IMPORT WINX;
IMPORT SYSTEM;

CONST
     szAppName = "Resourc1";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hInst           :  WIN32.HINSTANCE;
   hIcon           :  WIN32.HICON;
   cxIcon          :  INTEGER;
   cyIcon          :  INTEGER;
   cxClient        :  INTEGER;
   cyClient        :  INTEGER;
   hdc             :  WIN32.HDC;
   ps              :  WINUSER.PAINTSTRUCT;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
   x               :  INTEGER;
   y               :  INTEGER;
BEGIN
     CASE (iMsg) OF
     | WINUSER.WM_CREATE :
          hIcon := WINUSER.LoadIcon (hInst, szAppName);
          cxIcon := WINUSER.GetSystemMetrics (WINUSER.SM_CXICON);
          cyIcon := WINUSER.GetSystemMetrics (WINUSER.SM_CYICON);
          RETURN 0;
     | WINUSER.WM_SIZE :
          cxClient := WINUSER.LOWORD (lParam);
          cyClient := WINUSER.HIWORD (lParam);
          RETURN 0;
     | WINUSER.WM_PAINT :
          hdc := WINUSER.BeginPaint (hwnd, ps);
          y := cyIcon;
          LOOP
             x := cxIcon;
             LOOP 
                WINUSER.DrawIcon (hdc, x, y, hIcon);
                INC(x,2*cxIcon);
                IF(x > cxClient) THEN
                   EXIT;
                END;
             END;
             INC(y,2*cyIcon);
             IF(y > cyClient) THEN
                EXIT;
             END;
          END;
          WINUSER.EndPaint (hwnd, ps);
          RETURN 0;
     | WINUSER.WM_DESTROY :
          WINUSER.PostQuitMessage (0);
          RETURN 0;
     ELSE
       RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)

BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BAND WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (WINX.Instance, szAppName);
  wc.hCursor       := WINUSER.LoadCursor (WINX.Instance, szAppName);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINUSER.COLOR_WINDOW+1);
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (WINX.Instance, szAppName);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hInst := WINX.Instance;
  hwnd := WINUSER.CreateWindow (szAppName,
                        "Icon and Cursor Demo 1: Translation to Stony Brook Modula-2",
                        WINUSER.WS_OVERLAPPEDWINDOW,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        WINX.Instance,
                        NIL);

  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;

BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Resourc1.
