<*/NOWARN:F*>
MODULE NoPopUps;
(*-------------------------------------------------
   NOPOPUPS.C      --- Demonstrates No-Popup Nested Menu
                   (c) Charles Petzold, 1996
   NoPopUps.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -------------------------------------------------*)
%IF WIN32 %THEN
    <*/Resource:NOPOPUPS.RES*>
%ELSE
%END
IMPORT h2d_NoPopUps;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
CONST
   szAppName = "NoPopUps";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hMenuMain       :  WIN32.HMENU;
   hMenuEdit       :  WIN32.HMENU;
   hMenuFile       :  WIN32.HMENU;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE  WndProc (hwnd        : WIN32.HWND;
                    iMsg        : WIN32.UINT;
                    wParam      : WIN32.WPARAM;
                    lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(**********************************************************************)
VAR
   hInstance   :  WIN32.HINSTANCE;
BEGIN

  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hInstance := SYSTEM.CAST(WIN32.HINSTANCE,WINUSER.GetWindowLong (hwnd, WINUSER.GWL_HINSTANCE));

               hMenuMain := WINUSER.LoadMenu (hInstance, "MenuMain");
               hMenuFile := WINUSER.LoadMenu (hInstance, "MenuFile");
               hMenuEdit := WINUSER.LoadMenu (hInstance, "MenuEdit");

               WINUSER.SetMenu (hwnd, hMenuMain);
               RETURN 0;

          | WINUSER.WM_COMMAND :
               CASE (WINUSER.LOWORD (wParam))                                                                                                                                                          OF
                    | h2d_NoPopUps.IDM_MAIN :
                         WINUSER.SetMenu (hwnd, hMenuMain);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_FILE :
                         WINUSER.SetMenu (hwnd, hMenuFile);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_EDIT :
                         WINUSER.SetMenu (hwnd, hMenuEdit);
                         RETURN 0;

                    | h2d_NoPopUps.IDM_NEW :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_OPEN :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_SAVE :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_SAVEAS :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_UNDO :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_CUT :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_COPY :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_PASTE :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_NoPopUps.IDM_DEL :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
               ELSE
                 RETURN 0;
               END;

          | WINUSER.WM_DESTROY :
               WINUSER.SetMenu (hwnd, hMenuMain);
               WINUSER.DestroyMenu (hMenuFile);
               WINUSER.DestroyMenu (hMenuEdit);

               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "No-Popup Nested Menu Demonstration: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END NoPopUps.
