<*/NOWARN:F*>
MODULE PoorMenu;
(*-----------------------------------------
   POORMENU.C      --- The Poor Person's Menu
                   (c) Charles Petzold, 1996
   PoorMenu.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1998
  -----------------------------------------*)

IMPORT h2d_PopMenu;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
CONST
   szAppName = "PoorMenu";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hMenu           :  WIN32.HMENU;
CONST IDM_ABOUT  = 1;
CONST IDM_HELP   = 2;
CONST IDM_REMOVE = 3;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE  WndProc (hwnd        : WIN32.HWND;
                    iMsg        : WIN32.UINT;
                    wParam      : WIN32.WPARAM;
                    lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(**********************************************************************)
BEGIN

  CASE (iMsg) OF
          | WINUSER.WM_SYSCOMMAND :
               CASE (WINUSER.LOWORD (wParam)) OF
                    | IDM_ABOUT :
                         WINUSER.MessageBox (hwnd, "A Poor-Person's Menu Program.",
                                     szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONINFORMATION);
                         RETURN 0;

                    | IDM_HELP :
                         WINUSER.MessageBox (hwnd, "Help not yet implemented!",
                                     szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONEXCLAMATION);
                         RETURN 0;

                    | IDM_REMOVE :
                         WINUSER.GetSystemMenu (hwnd, TRUE);
                         RETURN 0;
               ELSE
               END;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
  ELSE
        RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
  END;
  RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc    :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx (wc);
  RETURN rc #0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (szAppName,
           "The Poor-Person's Menu: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  hMenu := WINUSER.GetSystemMenu (hwnd, FALSE);

  WINUSER.AppendMenu (hMenu, WINUSER.MF_SEPARATOR, 0,          WINX.NIL_ASTR);
  WINUSER.AppendMenu (hMenu, WINUSER.MF_STRING,    IDM_ABOUT,  "About...");
  WINUSER.AppendMenu (hMenu, WINUSER.MF_STRING,    IDM_HELP,   "Help...");
  WINUSER.AppendMenu (hMenu, WINUSER.MF_STRING,    IDM_REMOVE, "Remove Additions");

  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END PoorMenu.
