<*/NOWARN:F*>
MODULE PopMenu;
(*----------------------------------------
   POPMENU.C       --- Popup Menu Demonstration
                   (c) Charles Petzold, 1996
   PopMenu.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ----------------------------------------*)
%IF WIN32 %THEN
    <*/Resource:POPMENU.RES*>
%ELSE
%END
IMPORT h2d_PopMenu;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
CONST
   szAppName = "PopMenu";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hInst           :  WIN32.HINSTANCE;
TYPE
   Color           =  INTEGER;
   ColorArr        =  ARRAY[0..4] OF Color;
CONST
   iColorID          =  ColorArr
                                { WINGDI.WHITE_BRUSH,  WINGDI.LTGRAY_BRUSH, WINGDI.GRAY_BRUSH,
                                 WINGDI.DKGRAY_BRUSH, WINGDI.BLACK_BRUSH };
VAR
   iSelection      :  INTEGER  =  h2d_PopMenu.IDM_WHITE;
   hMenu       :  WIN32.HMENU;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE  WndProc (hwnd        : WIN32.HWND;
                    iMsg        : WIN32.UINT;
                    wParam      : WIN32.WPARAM;
                    lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
(**********************************************************************)
VAR
  point   :  WIN32.POINT;
BEGIN

  CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               hMenu := WINUSER.LoadMenu (hInst, szAppName);
               hMenu := WINUSER.GetSubMenu (hMenu, 0);
               RETURN 0;

          | WINUSER.WM_RBUTTONDOWN :
               point.x := WINUSER.LOWORD (lParam);
               point.y := WINUSER.HIWORD (lParam);
               WINUSER.ClientToScreen (hwnd, point);
               WINUSER.TrackPopupMenu (hMenu, 0, point.x, point.y, 0, hwnd, WINX.NIL_RECT);
               RETURN 0;

          | WINUSER.WM_COMMAND :
               CASE (WINUSER.LOWORD (wParam))                                                                                                                                                          OF
                    | h2d_PopMenu.IDM_NEW :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_OPEN :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_SAVE :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_SAVEAS :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_UNDO :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_CUT :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_COPY :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_PASTE :
                         WINUSER.MessageBeep (0);
                         RETURN 0;
                    | h2d_PopMenu.IDM_DEL :
                         WINUSER.MessageBeep (0);
                         RETURN 0;

                    | h2d_PopMenu.IDM_WHITE :          (* Note: Logic below             *)
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_UNCHECKED);
                         iSelection := WINUSER.LOWORD (wParam);
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_CHECKED);

                         WINUSER.SetClassLong (hwnd, WINUSER.GCL_HBRBACKGROUND,
                              SYSTEM.CAST(WIN32.LONG, WINGDI.GetStockObject
                                                             (iColorID[WINUSER.LOWORD (wParam) - h2d_PopMenu.IDM_WHITE])));

                         WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
                         RETURN 0;

                    | h2d_PopMenu.IDM_LTGRAY :         (*   assumes that h2d_PopMenu.IDM_WHITE      *)
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_UNCHECKED);
                         iSelection := WINUSER.LOWORD (wParam);
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_CHECKED);

                         WINUSER.SetClassLong (hwnd, WINUSER.GCL_HBRBACKGROUND,
                              SYSTEM.CAST(WIN32.LONG, WINGDI.GetStockObject
                                                             (iColorID[WINUSER.LOWORD (wParam) - h2d_PopMenu.IDM_WHITE])));

                         WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
                         RETURN 0;

                    | h2d_PopMenu.IDM_GRAY :           (*   through h2d_PopMenu.IDM_BLACK are       *)
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_UNCHECKED);
                         iSelection := WINUSER.LOWORD (wParam);
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_CHECKED);

                         WINUSER.SetClassLong (hwnd, WINUSER.GCL_HBRBACKGROUND,
                              SYSTEM.CAST(WIN32.LONG, WINGDI.GetStockObject
                                                             (iColorID[WINUSER.LOWORD (wParam) - h2d_PopMenu.IDM_WHITE])));

                         WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
                         RETURN 0;

                    | h2d_PopMenu.IDM_DKGRAY :         (*   consecutive numbers in      *)
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_UNCHECKED);
                         iSelection := WINUSER.LOWORD (wParam);
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_CHECKED);

                         WINUSER.SetClassLong (hwnd, WINUSER.GCL_HBRBACKGROUND,
                              SYSTEM.CAST(WIN32.LONG, WINGDI.GetStockObject
                                                             (iColorID[WINUSER.LOWORD (wParam) - h2d_PopMenu.IDM_WHITE])));

                         WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
                         RETURN 0;

                    | h2d_PopMenu.IDM_BLACK :          (*   the order shown here.       *)

                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_UNCHECKED);
                         iSelection := WINUSER.LOWORD (wParam);
                         WINUSER.CheckMenuItem (hMenu, iSelection, WINUSER.MF_CHECKED);

                         WINUSER.SetClassLong (hwnd, WINUSER.GCL_HBRBACKGROUND,
                              SYSTEM.CAST(WIN32.LONG, WINGDI.GetStockObject
                                                             (iColorID[WINUSER.LOWORD (wParam) - h2d_PopMenu.IDM_WHITE])));

                         WINUSER.InvalidateRect (hwnd, WINX.NIL_RECT, TRUE);
                         RETURN 0;

                    | h2d_PopMenu.IDM_ABOUT :
                         WINUSER.MessageBox (hwnd, "Popup Menu Demonstration Program.",
                                     szAppName, WINUSER.MB_ICONINFORMATION BOR WINUSER.MB_OK);
                         RETURN 0;

                    | h2d_PopMenu.IDM_EXIT :
                         WINUSER.SendMessage (hwnd, WINUSER.WM_CLOSE, 0, 0);
                         RETURN 0;

                    | h2d_PopMenu.IDM_HELP :
                         WINUSER.MessageBox (hwnd, "Help not yet implemented!",
                                     szAppName, WINUSER.MB_ICONEXCLAMATION BOR WINUSER.MB_OK);
                         RETURN 0;
               ELSE
                   RETURN 0;
               END;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
         RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(WINUSER.WNDCLASSEX);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx (wc)#0;
END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hInst := WINX.Instance;
  hwnd := WINUSER.CreateWindow
           (szAppName,                           (* window class name            *)
           "Popup Menu Demonstration: Translation to Stony Brook Modula-2",
                                                 (* window caption               *)
           WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
           WINUSER.CW_USEDEFAULT,                (* initial x position           *)
           WINUSER.CW_USEDEFAULT,                (* initial y position           *)
           WINUSER.CW_USEDEFAULT,                (* initial x size               *)
           WINUSER.CW_USEDEFAULT,                (* initial y size               *)
           NIL,                                  (* parent window handle         *)
           NIL,                                  (* window menu handle           *)
           WINX.Instance,                        (* program instance handle      *)
           NIL);                                 (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;
(*++++*****************************************************************)
BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END PopMenu.
