<*/NOWARN:F*>
MODULE PopPad2;
(*-----------------------------------------------------
   POPPAD2.C       --- Popup Editor Version 2 (includes menu)
                   (c) Charles Petzold, 1996
   PopPad2.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------------------*)

%IF WIN32 %THEN
    <*/Resource:PopPad2.RES*>
%ELSE
%END
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT h2d_poppad2;
IMPORT SYSTEM;
CONST
   szAppName = "PopPad2";
   szAppTitle = "PopPad2: Translation to Stony Brook Modula-2";

VAR
   hAccel          :  WIN32.HACCEL;
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hwndEdit        :  WIN32.HWND;
   iSelect         :  INTEGER;
   iEnable         :  INTEGER;

PROCEDURE AskConfirmation (hwnd : WIN32.HWND) : INTEGER;
BEGIN
     RETURN WINUSER.MessageBox (hwnd, "Really want to close PopPad2?",
                        szAppName, WINUSER.MB_YESNO BOR WINUSER.MB_ICONQUESTION);
END AskConfirmation;
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];

VAR
  bo   :  WIN32.BOOL;
  lr   :  WIN32.LRESULT;
  mf   :  INTEGER;
  lpcr    : WINUSER.LPCREATESTRUCT;
BEGIN

     CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               lpcr := SYSTEM.CAST(WINUSER.LPCREATESTRUCT,lParam);
               hwndEdit := WINUSER.CreateWindow ("edit",
                         "",
                         WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR WINUSER.WS_HSCROLL BOR WINUSER.WS_VSCROLL BOR
                              WINUSER.WS_BORDER BOR WINUSER.ES_LEFT BOR WINUSER.ES_MULTILINE BOR
                              WINUSER.ES_AUTOHSCROLL BOR WINUSER.ES_AUTOVSCROLL,
                         0,
                         0,
                         0,
                         0,
                         hwnd,
                         SYSTEM.CAST(WIN32.HMENU,1),
                         (* statt
                         (SYSTEM.CAST(WINUSER.LPCREATESTRUCT, lParam) ^. hInstance, NIL);
                         *)    
                         lpcr^.hInstance,
                         NIL);
               RETURN 0;

          | WINUSER.WM_SETFOCUS :
               WINUSER.SetFocus (hwndEdit);
               RETURN 0;

          | WINUSER.WM_SIZE :
               WINUSER.MoveWindow (hwndEdit, 0, 0, WINUSER.LOWORD (lParam),
                                           WINUSER.HIWORD (lParam), TRUE);
               RETURN 0;

          | WINUSER.WM_INITMENUPOPUP :
               IF (lParam = 1) THEN
                    lr := WINUSER.SendMessage (hwndEdit, WINUSER.EM_CANUNDO, 0, 0);
                    IF(lr=1) THEN
                      mf := WINUSER.MF_ENABLED;
                    ELSIF(lr=0) THEN
                      mf := WINUSER.MF_GRAYED;
                    END;
                    WINUSER.EnableMenuItem (SYSTEM.CAST(WIN32.HMENU,wParam), h2d_poppad2.IDM_UNDO,mf);
                    bo := WINUSER.IsClipboardFormatAvailable (WINUSER.CF_TEXT);
                    IF(bo=TRUE) THEN
                      mf := WINUSER.MF_ENABLED;
                    ELSIF(bo=FALSE) THEN
                      mf := WINUSER.MF_GRAYED;
                    END;
                    WINUSER.EnableMenuItem (SYSTEM.CAST(WIN32.HMENU,wParam), h2d_poppad2.IDM_PASTE,mf);
                    iSelect := WINUSER.SendMessage (hwndEdit, WINUSER.EM_GETSEL, 0, 0);

                    IF (WINUSER.HIWORD (iSelect) = WINUSER.LOWORD (iSelect)) THEN
                         iEnable := SYSTEM.CAST(INTEGER,WINUSER.MF_GRAYED);
                    ELSE
                         iEnable := SYSTEM.CAST(INTEGER,WINUSER.MF_ENABLED);
                    END;
                    WINUSER.EnableMenuItem (SYSTEM.CAST(WIN32.HMENU,wParam), h2d_poppad2.IDM_CUT,   iEnable);
                    WINUSER.EnableMenuItem (SYSTEM.CAST(WIN32.HMENU,wParam), h2d_poppad2.IDM_COPY,  iEnable);
                    WINUSER.EnableMenuItem (SYSTEM.CAST(WIN32.HMENU,wParam), h2d_poppad2.IDM_DEL,   iEnable);
                    RETURN 0;
               END;
          | WINUSER.WM_COMMAND :

               IF (lParam=1) THEN
                    IF (WINUSER.LOWORD (lParam) = 1) AND
                         ((WINUSER.HIWORD (wParam) = WINUSER.EN_ERRSPACE) OR (WINUSER.HIWORD (wParam) = WINUSER.EN_MAXTEXT)) THEN
                              WINUSER.MessageBox (hwnd, "Edit control out of space.",
                                          szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONSTOP);
                    RETURN 0;
                    END;
               ELSE
                 CASE (WINUSER.LOWORD (wParam)) OF
                         | h2d_poppad2.IDM_NEW :
                         | h2d_poppad2.IDM_OPEN :
                         | h2d_poppad2.IDM_SAVE :
                         | h2d_poppad2.IDM_SAVEAS :
                         | h2d_poppad2.IDM_PRINT :
                              WINUSER.MessageBeep (0);
                              RETURN 0;

                         | h2d_poppad2.IDM_EXIT :
                              WINUSER.SendMessage (hwnd, WINUSER.WM_CLOSE, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_UNDO :
                              WINUSER.SendMessage (hwndEdit, WINUSER.WM_UNDO, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_CUT :
                              WINUSER.SendMessage (hwndEdit, WINUSER.WM_CUT, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_COPY :
                              WINUSER.SendMessage (hwndEdit, WINUSER.WM_COPY, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_PASTE :
                              WINUSER.SendMessage (hwndEdit, WINUSER.WM_PASTE, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_DEL :
                              WINUSER.SendMessage (hwndEdit, WINUSER.WM_CLEAR, 0, 0);
                              RETURN 0;

                         | h2d_poppad2.IDM_SELALL :
                              WINUSER.SendMessage (hwndEdit, WINUSER.EM_SETSEL, 0,-1);
                              RETURN 0;

                         | h2d_poppad2.IDM_HELP :
                              WINUSER.MessageBox (hwnd, "Help not yet implemented!",
                                   szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONEXCLAMATION);
                              RETURN 0;

                         | h2d_poppad2.IDM_ABOUT :
                              WINUSER.MessageBox (hwnd,
                                   "POPPAD2 (c) Charles Petzold, 1996, Translation to Stony Brook Modula-2 (c) Peter Stadler, 1997",
                                   szAppName, WINUSER.MB_OK BOR WINUSER.MB_ICONINFORMATION);
                              RETURN 0;
                 ELSE
                              RETURN 0;
                 END;
               END;
          | WINUSER.WM_CLOSE :
               IF (WINUSER.IDYES = AskConfirmation (hwnd)) THEN
                    WINUSER.DestroyWindow (hwnd);
               END;
               RETURN 0;

          | WINUSER.WM_QUERYENDSESSION :
               IF (WINUSER.IDYES = AskConfirmation (hwnd)) THEN
                    RETURN 1;
               ELSE
                    RETURN 0;
               END;
          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
       RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
     RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (WINX.Instance, szAppName);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := SYSTEM.ADR(szAppName);
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);
  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       szAppTitle,                     (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,          (* window style                 *)
                       WINUSER.GetSystemMetrics (WINUSER.SM_CXSCREEN) / 4,
                       WINUSER.GetSystemMetrics (WINUSER.SM_CYSCREEN) / 4,
                       WINUSER.GetSystemMetrics (WINUSER.SM_CXSCREEN) / 2,
                       WINUSER.GetSystemMetrics (WINUSER.SM_CYSCREEN) / 2,
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  hAccel := WINUSER.LoadAccelerators (wc.hInstance, szAppName);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      IF (WINUSER.TranslateAccelerator (hwnd, hAccel, msg)=0) THEN
        WINUSER.TranslateMessage(msg);
        WINUSER.DispatchMessage(msg);
      END;
    END;
  END;
END PopPad2.
