<*/NOWARN:F*>
IMPLEMENTATION MODULE PopFile;
(*------------------------------------------
   POPFILE.C -- Popup Editor File Functions
  ------------------------------------------*)

IMPORT Storage;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT Strings;
IMPORT COMMDLG;
IMPORT SYSTEM;
IMPORT FIO;
IMPORT MemUtils;
IMPORT WINX;

VAR
  ofn    :   COMMDLG.OPENFILENAME;
CONST
   szFilter : ARRAY[0..100] OF CHAR = 
                    {"Text Files (*.TXT)","","*.txt","", 
                     "ASCII Files (*.ASC)","","*.asc","",
                     "All Files (*.*)","","*.*" 
                    };

   txt      = "txt";
(*
   IDSTR_FILTER = 1000;

VAR   
    filter : ARRAY [0..1000] OF CHAR;
*)
(*++++****************************************************************)
PROCEDURE Initialize (hwnd :   WIN32.HWND);
(*********************************************************************)
BEGIN
(*
     MemUtils.FillMemBYTE (filter, SIZE (filter),0);
     SYSTEM.FUNC WINUSER.LoadString (WINX.Instance, IDSTR_FILTER, filter, SIZE (filter));
*)

     MemUtils.FillMemBYTE (ofn, SIZE (ofn),0);
     ofn.lStructSize       := SIZE(COMMDLG.OPENFILENAME);
     ofn.hwndOwner         := hwnd;
     ofn.hInstance         := NIL;
     ofn.lpstrFilter       := SYSTEM.ADR(szFilter);
     ofn.lpstrCustomFilter := NIL;
     ofn.nMaxCustFilter    := 0;
     ofn.nFilterIndex      := 0;
     ofn.lpstrFile         := NIL;          (* Set in Open and Close functions *)
     ofn.nMaxFile          := WIN32.MAX_PATH;
     ofn.lpstrFileTitle    := NIL;                                 (* Set in Open and Close functions         *)
     ofn.nMaxFileTitle     := WIN32.MAX_FNAME + WIN32.MAX_EXT;
     ofn.lpstrInitialDir   := NIL;
     ofn.lpstrTitle        := NIL;
     ofn.Flags             := 0;            (* Set in Open and Close functions         *)
     ofn.nFileOffset       := 0;
     ofn.nFileExtension    := 0;
     ofn.lpstrDefExt       := SYSTEM.ADR(txt);
     ofn.lCustData         := 0000h;
     ofn.lpfnHook          := SYSTEM.CAST(COMMDLG.LPOFNHOOKPROC,NIL);
     ofn.lpTemplateName    := NIL;
END Initialize;
(*++++****************************************************************)
PROCEDURE OpenDlg (hwnd            : WIN32.HWND;
                   pstrFileName    : WIN32.PSTR;
                   pstrTitleName   : WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := COMMDLG.OFN_HIDEREADONLY + COMMDLG.OFN_CREATEPROMPT;

     RETURN COMMDLG.GetOpenFileName (ofn);
END OpenDlg;

(*++++****************************************************************)
PROCEDURE SaveDlg (hwnd         :  WIN32.HWND;
                   pstrFileName :  WIN32.PSTR;
                   pstrTitleName:  WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := COMMDLG.OFN_OVERWRITEPROMPT;

     RETURN COMMDLG.GetSaveFileName (ofn);
END SaveDlg;

(*++++****************************************************************)
PROCEDURE Length (file   :  FILE) : WIN32.LONG;
(*********************************************************************)
VAR
   iFileLength  :  INTEGER;
BEGIN
     iFileLength := FIO.Size(file);
     RETURN iFileLength;
END Length;

(*++++****************************************************************)
PROCEDURE Read (hwndEdit    :  WIN32.HWND;
                pstrFileName:  WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
VAR
     file       :  FILE;
     iLength    :  CARDINAL;
     pstrBuffer :  WIN32.PSTR;
BEGIN
     file := FIO.Open(pstrFileName^);
     iLength := Length (file);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FIO.Close(file);
          RETURN FALSE;
     END;

     FIO.RdBin(file,pstrBuffer^,iLength);
     FIO.Close(file);

     WINUSER.SetWindowText (hwndEdit, pstrBuffer^);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Read;

(*++++****************************************************************)
PROCEDURE Write (hwndEdit     :  WIN32.HWND;
                 pstrFileName :  WIN32.PSTR ) : WIN32.BOOL;
(*********************************************************************)
VAR
     file         : FILE;
     iLength      : CARDINAL;
     pstrBuffer   : WIN32.PSTR;
BEGIN
     file := FIO.Create(pstrFileName^);
     iLength := WINUSER.GetWindowTextLength (hwndEdit);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FIO.Close(file);
          RETURN FALSE;
     END;

     WINUSER.GetWindowText (hwndEdit, pstrBuffer^, iLength + 1);

     FIO.WrBin(file,pstrBuffer^,iLength);

     FIO.Close(file);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Write;
BEGIN
END PopFile.
