<*/NOWARN:F*>
IMPLEMENTATION MODULE PopFind;
(*--------------------------------------------------------
   POPFIND.C -- Popup Editor Search and Replace Functions
  --------------------------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT COMMDLG;
IMPORT SYSTEM;
IMPORT Strings;
IMPORT ExStorage;
CONST
  MAX_STRING_LEN = 256;
TYPE
  TEXT = ARRAY[0..MAX_STRING_LEN] OF CHAR;
VAR
  szFindText : TEXT;
  szReplText : TEXT;
VAR
  fr1 : COMMDLG.FINDREPLACE;       (* must be static for modeless dialog!!!                *)
  fr2 : COMMDLG.FINDREPLACE;       (* must be static for modeless dialog!!!                *)

(*++++****************************************************************)
PROCEDURE FindDlg (hwnd :  WIN32.HWND)  :  WIN32.HWND;
(*********************************************************************)
BEGIN
     fr1.lStructSize      := SIZE (COMMDLG.FINDREPLACE);
     fr1.hwndOwner        := hwnd;
     fr1.hInstance        := NIL;
     fr1.Flags            := COMMDLG.FR_HIDEUPDOWN + COMMDLG.FR_HIDEMATCHCASE + COMMDLG.FR_HIDEWHOLEWORD;
     fr1.lpstrFindWhat    := SYSTEM.ADR(szFindText);
     fr1.lpstrReplaceWith := NIL;
     fr1.wFindWhatLen     := SIZE (szFindText);
     fr1.wReplaceWithLen  := 0;
     fr1.lCustData        := 0;
     fr1.lpfnHook         := SYSTEM.CAST(COMMDLG.LPFRHOOKPROC,NIL);
     fr1.lpTemplateName   := NIL;

     RETURN COMMDLG.FindText (fr1);
END FindDlg;

(*++++****************************************************************)
PROCEDURE ReplaceDlg (hwnd :  WIN32.HWND)  :  WIN32.HWND;
(*********************************************************************)
BEGIN
     fr2.lStructSize      := SIZE (COMMDLG.FINDREPLACE);
     fr2.hwndOwner        := hwnd;
     fr2.hInstance        := NIL;
     fr2.Flags            := COMMDLG.FR_HIDEUPDOWN + COMMDLG.FR_HIDEMATCHCASE + COMMDLG.FR_HIDEWHOLEWORD;
     fr2.lpstrFindWhat    := SYSTEM.ADR(szFindText);
     fr2.lpstrReplaceWith := SYSTEM.ADR(szReplText);
     fr2.wFindWhatLen     := SIZE (szFindText);
     fr2.wReplaceWithLen  := SIZE (szReplText);
     fr2.lCustData        := 0;
     fr2.lpfnHook         := SYSTEM.CAST(COMMDLG.LPFRHOOKPROC,NIL);
     fr2.lpTemplateName   := NIL;

     RETURN COMMDLG.ReplaceText (fr2);
END ReplaceDlg;

(*++++****************************************************************)
PROCEDURE FindText (hwndEdit       :  WIN32.HWND;
                    piSearchOffset :  INTEGER;
                    pfr            :  COMMDLG.LPFINDREPLACE) : WIN32.BOOL;
(*********************************************************************)
VAR
  iLength   :  INTEGER;
  iPos      :  INTEGER;
  pstrDoc   :  WIN32.PSTR;
  pstrPos   :  CARDINAL;
  text      :  TEXT;
  found     :  BOOLEAN;
BEGIN

               (* Read in the edit document                                         *)
     iLength := WINUSER.GetWindowTextLength (hwndEdit);
     ExStorage.ALLOCATE(pstrDoc,iLength+1);
     IF (pstrDoc=NIL) THEN
          RETURN FALSE;
     END;
     WINUSER.GetWindowText (hwndEdit, pstrDoc^, iLength + 1);

               (* Search the document for the find string                           *)
     
     Strings.FindNext(pfr^.lpstrFindWhat^,pstrDoc^,piSearchOffset,found,pstrPos);          
     ExStorage.DEALLOCATE(pstrDoc,iLength+1);

               (* Return an error code if the string cannot be found                *)

     IF (pstrPos = 0) THEN
          RETURN FALSE;
     END;

               (* Find the position in the document and the new start offset        *)

     iPos := pstrPos;
     Strings.Replace(text,0,SYSTEM.CAST(TEXT,pfr^.lpstrFindWhat^));
     piSearchOffset := iPos + VAL(INTEGER,LENGTH(text));

               (* Select the found text                                             *)

     WINUSER.SendMessage (hwndEdit, WINUSER.EM_SETSEL, iPos, piSearchOffset);
     WINUSER.SendMessage (hwndEdit, WINUSER.EM_SCROLLCARET, 0, 0);

     RETURN TRUE;
END FindText;

(*++++****************************************************************)
PROCEDURE NextText (hwndEdit       :  WIN32.HWND;
                    piSearchOffset :  INTEGER) : WIN32.BOOL;
(*********************************************************************)
VAR
  fr :  COMMDLG.FINDREPLACE;
BEGIN
     fr.lpstrFindWhat := SYSTEM.ADR(szFindText);

     RETURN FindText (hwndEdit, piSearchOffset, SYSTEM.ADR(fr));
END NextText;

(*++++****************************************************************)
PROCEDURE ReplaceText (hwndEdit       :  WIN32.HWND;
                       piSearchOffset :  INTEGER;
                       pfr            :  COMMDLG.LPFINDREPLACE) : WIN32.BOOL;
(*********************************************************************)
               (* Find the text                                                     *)
BEGIN
     IF (FindText (hwndEdit, piSearchOffset, pfr)=FALSE) THEN
          RETURN FALSE;
     END;

               (* Replace it                                                        *)

     WINUSER.SendMessage (hwndEdit, WINUSER.EM_REPLACESEL, 0, SYSTEM.CAST(WIN32.LPARAM, pfr^.lpstrReplaceWith));

     RETURN TRUE;
END ReplaceText;

(*++++****************************************************************)
PROCEDURE ValidFind () : WIN32.BOOL;
(*********************************************************************)
BEGIN
     RETURN szFindText[0] #'';
END ValidFind;
BEGIN
END PopFind.
