<*/NOWARN:F*>
IMPLEMENTATION MODULE PopFont;
(*------------------------------------------
   POPFONT.C -- Popup Editor Font Functions
  ------------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT COMMDLG;
IMPORT SYSTEM;
VAR
  logfont  :  WINGDI.LOGFONT;
  hFont    :  WIN32.HFONT;

(*++++****************************************************************)
PROCEDURE ChooseFont (hwnd : WIN32.HWND) : BOOLEAN;
(*********************************************************************)
VAR
  cf   : COMMDLG.CHOOSEFONT;
BEGIN
     cf.lStructSize      := SIZE (COMMDLG.CHOOSEFONT);
     cf.hwndOwner        := hwnd;
     cf.hDC              := NIL;
     cf.lpLogFont        := SYSTEM.ADR(logfont);
     cf.iPointSize       := 0;
     cf.Flags            := COMMDLG.CF_INITTOLOGFONTSTRUCT + COMMDLG.CF_SCREENFONTS
                                                  + COMMDLG.CF_EFFECTS;
     cf.rgbColors        := 0000h;
     cf.lCustData        := 0000h;
     cf.lpfnHook         := SYSTEM.CAST(COMMDLG.LPCFHOOKPROC,NIL);
     cf.lpTemplateName   := NIL;
     cf.hInstance        := NIL;
     cf.lpszStyle        := NIL;
     cf.nFontType        := 0;               (* Returned from ChooseFont  *)
     cf.nSizeMin         := 0;
     cf.nSizeMax         := 0;   

     RETURN COMMDLG.ChooseFont (cf);
END ChooseFont;

(*++++****************************************************************)
PROCEDURE Initialize (hwndEdit : WIN32.HWND);
(*++++****************************************************************)
BEGIN
     WINGDI.GetObject (WINGDI.GetStockObject (WINGDI.SYSTEM_FONT), SIZE (WINGDI.LOGFONT),
                                              SYSTEM.CAST(WIN32.PSTR,logfont));
     hFont := WINGDI.CreateFontIndirect (logfont);
     WINUSER.SendMessage (hwndEdit, WINUSER.WM_SETFONT, SYSTEM.CAST(WIN32.WPARAM, hFont), 0);
END Initialize;
(*++++****************************************************************)
PROCEDURE SetFont (hwndEdit : WIN32.HWND);
(*++++****************************************************************)
VAR
     hFontNew:WIN32.HFONT;
     rect    :WIN32.RECT;
BEGIN
     hFontNew := WINGDI.CreateFontIndirect (logfont);
     WINUSER.SendMessage (hwndEdit, WINUSER.WM_SETFONT, SYSTEM.CAST(WIN32.WPARAM,hFontNew), 0);
     WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hFont));
     hFont := hFontNew;
     WINUSER.GetClientRect (hwndEdit, rect);
     WINUSER.InvalidateRect (hwndEdit, rect, TRUE);
END SetFont;

(*++++****************************************************************)
PROCEDURE Deinitialize ();
(*********************************************************************)
BEGIN
     WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hFont));
END Deinitialize;
BEGIN
END PopFont.
