<*/NOWARN:F*>
MODULE CtlMacro;
%IF WIN32 %THEN
    <*/Resource:CTLMACRO.RES*>
%ELSE
%END
(*--------------------------------------------
   CTLMACRO.C      --- Control Macro Helper Utility
                   (c) Paul Yao,      1996
   CtlMacro.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  --------------------------------------------*)

IMPORT TreeView;
IMPORT resource;
IMPORT Notify;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT COMMCTRL;
IMPORT WINUSER;
IMPORT SYSTEM;
IMPORT WINX;

VAR COL_WHITE  : INTEGER;

VAR
  hInst   :  WIN32.HINSTANCE;
VAR 
  bFirstSelection : BOOLEAN = TRUE; (* static *)


<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE DlgProc (hwnd        : WIN32.HWND;
(**********************************************************************)
          mMsg        : WIN32.UINT;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIN32.BOOL [EXPORT];
(*******************************************************************-          *)
VAR
  hicon        :  WIN32.HICON;
  himl         :  COMMCTRL.HIMAGELIST;
  hItem        :  COMMCTRL.HTREEITEM;
  hwndEdit     :  WIN32.HWND;
  hwndCopy     :  WIN32.HWND;
  hwndCtrl     :  WIN32.HWND;
  hwndButton   :  WIN32.HWND;
  wNotifyCode  :  WIN32.WORD;
  cb           :  INTEGER;
  idCtrl       :  INTEGER;
  pnmtv        :  COMMCTRL.LPNM_TREEVIEW;
  pnmh         :  WINUSER.LPNMHDR;
  lpstr        :  WIN32.LPTSTR;

BEGIN
     CASE (mMsg) OF
          | WINUSER.WM_INITDIALOG :
               (* Add listview root items                                      *)
               hwndCtrl := WINUSER.GetDlgItem (hwnd, resource.IDC_MESSAGES);
               TreeView.tv_BuildRootFolder (hwndCtrl);

               (* Select first item                                            *)
               hItem := COMMCTRL.TreeView_GetFirstVisible (hwndCtrl);
               COMMCTRL.TreeView_SelectItem (hwndCtrl, hItem);

               (* Create image list & connect to list view                     *)
	       lpstr := WINUSER.MAKEINTRESOURCE (resource.IDR_TVITEMS);
               himl :=
               COMMCTRL.ImageList_LoadBitmap (hInst,
                                     lpstr^,
                                     16,
                                     0,
                                     COL_WHITE);

               COMMCTRL.TreeView_SetImageList (hwndCtrl, himl, COMMCTRL.TVSIL_NORMAL);

               (* Disable [Copy] button when no macro is present               *)
               hwndCtrl := WINUSER.GetDlgItem (hwnd, resource.IDC_COPY);
               WINUSER.EnableWindow (hwndCtrl, FALSE);

               (* Install icon                                                 *)
	       lpstr := WINUSER.MAKEINTRESOURCE (resource.IDI_APP);
               hicon := WINUSER.LoadIcon (hInst,lpstr^);
               WINUSER.SendMessage (hwnd, WINUSER.WM_SETICON, VAL(WIN32.WPARAM,TRUE),
                            SYSTEM.CAST(WIN32.LPARAM, hicon));

               RETURN TRUE;

          | WINUSER.WM_COMMAND :
               CASE (WINUSER.LOWORD (wParam)) OF
                    (* Copy macro data to clipboard                            *)
                    | resource.IDC_COPY :
                         hwndEdit := WINUSER.GetDlgItem (hwnd, resource.IDC_MACROS);
                         WINX.Edit_SetSel (hwndEdit, 0, -1);
                         WINUSER.SendMessage (hwndEdit, WINUSER.WM_COPY, 0, 0h);

                    (* Close dialog                                            *)
                    | WINUSER.IDOK :
                         WINUSER.EndDialog (hwnd, 0);

                    (* Enable & disable [Copy] button when edit changes        *)
                    | resource.IDC_MACROS :
                         wNotifyCode := WINUSER.HIWORD (wParam);
                         IF (wNotifyCode = WINUSER.EN_CHANGE) THEN
                              hwndEdit := SYSTEM.CAST(WIN32.HWND,lParam);
                              hwndCopy := WINUSER.GetDlgItem (hwnd, resource.IDC_COPY);
                              cb := WINX.Edit_GetTextLength (hwndEdit);
                              WINUSER.EnableWindow (hwndCopy, SYSTEM.CAST(BOOLEAN,cb));
                         END;

               ELSE
                 RETURN TRUE;
               END;
               RETURN TRUE;

          | WINUSER.WM_NOTIFY :
               idCtrl := SYSTEM.CAST(INTEGER,wParam);
               pnmh := SYSTEM.CAST(WINUSER.LPNMHDR, lParam);

               (* Expand tree as required                                      *)
               IF (pnmh^.code = COMMCTRL.TVN_ITEMEXPANDING) THEN
                    pnmtv := SYSTEM.CAST(COMMCTRL.LPNM_TREEVIEW,lParam);
                    TreeView.tv_ExpandChild (pnmh^.hwndFrom, pnmtv^.itemNew.lParam);
               END;
               (* Respond to selection of items                                *)
               IF (pnmh^.code = COMMCTRL.TVN_SELCHANGED) THEN
                    pnmtv := SYSTEM.CAST(COMMCTRL.LPNM_TREEVIEW, lParam);
                    hwndEdit := WINUSER.GetDlgItem (hwnd, resource.IDC_MACROS);

                    (* Ignore first selection request                          *)
                    IF (bFirstSelection) THEN
                         bFirstSelection := FALSE;
                         RETURN TRUE;
                    END;

                    (* Fetch macro for leaf nodes                              *)
                    IF (TreeView.tv_FetchMacro (pnmtv^.itemNew.lParam, hwndEdit)) THEN
                         WINX.Edit_SetSel (hwndEdit, 0, -1);
                    ELSE
                         (* Expand tree for folder nodes                       *)
                         COMMCTRL.TreeView_Expand (pnmh^.hwndFrom,
                                          pnmtv^.itemNew.hItem,
                                          COMMCTRL.TVE_EXPAND);
                         WINX.Edit_SetText (hwndEdit, "");
                    END;
                    RETURN TRUE;
               END;

               (* Double-click means copy macro to clipboard                   *)
               IF (pnmh^.code = COMMCTRL.NM_DBLCLK) THEN
                    hwndEdit   := WINUSER.GetDlgItem (hwnd, resource.IDC_MACROS);
                    hwndButton := WINUSER.GetDlgItem (hwnd, resource.IDC_COPY);
                    IF (WINX.Edit_GetTextLength (hwndEdit) > 0) THEN
                         COMMCTRL.FORWARD_WM_COMMAND (hwnd, resource.IDC_COPY,
                                             hwndButton, WINUSER.BN_CLICKED,
                                             WINUSER.SendMessage);
                    END;
               END;

               RETURN TRUE;

          ELSE
               RETURN FALSE;
          END;
END DlgProc;
<*/POP*>
(*******************************************************************-          *)
VAR
   lpstr        :  WIN32.LPTSTR;
BEGIN
     COL_WHITE := (WINGDI.RGB (255, 255, 255));
     hInst := WINX.Instance;

     (* Load common control library                                            *)
     COMMCTRL.InitCommonControls ();


     lpstr :=   WINUSER.MAKEINTRESOURCE (resource.IDD_DIALOG);
     WINUSER.DialogBox (hInst,lpstr^, NIL, DlgProc);

END CtlMacro.
