IMPLEMENTATION MODULE Notify;
(*---------------------------------------
   NOTIFY.C        --- Gadgets for a frame window.
                   (c) Paul Yao,      1996
   Notify.mod      --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  ---------------------------------------*)

IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT WINX;
IMPORT SYSTEM;
IMPORT COMMCTRL;
IMPORT comcthlp;
(*-------------------------------------------------------------------*)
(* QueryNotifyText: Convert notification codes into text.*)
(*-------------------------------------------------------------------*)
(*++++*****************************************************************)
PROCEDURE QueryNotifyText (nNotifyCode : CARDINAL; pName : WIN32.LPSTR) : BOOLEAN;
(**********************************************************************)

VAR
  bFound    :  BOOLEAN;
  iNotify   :  INTEGER;
BEGIN
  bFound := FALSE;
     FOR iNotify := 0 TO  NOTIFY_COUNT-1 DO
          IF (cnLookupTable[iNotify].nCode = VAL(INTEGER,nNotifyCode)) THEN;
               pName := cnLookupTable[iNotify].pName;
               RETURN TRUE;
          END;
     END;
     (* Unknown notification code.*)
     pName := SYSTEM.ADR("** Unknown **");
     RETURN FALSE;
END QueryNotifyText;
BEGIN


     cnLookupTable := cnLookupTableArray 
  {
    {COMMCTRL.NM_OUTOFMEMORY,       SYSTEM.ADR("NM_OUTOFMEMORY")},
    {COMMCTRL.NM_CLICK,             SYSTEM.ADR("NM_CLICK")},
    {COMMCTRL.NM_DBLCLK,            SYSTEM.ADR("NM_DBLCLK")},
    {COMMCTRL.NM_RETURN,            SYSTEM.ADR("NM_RETURN")},
    {COMMCTRL.NM_RCLICK,            SYSTEM.ADR("NM_RCLICK")},
    {COMMCTRL.NM_RDBLCLK,           SYSTEM.ADR("NM_RDBLCLK")},
    {COMMCTRL.NM_SETFOCUS,          SYSTEM.ADR("NM_SETFOCUS")},
    {COMMCTRL.NM_KILLFOCUS,         SYSTEM.ADR("NM_KILLFOCUS")},
    {COMMCTRL.LVN_ITEMCHANGING,     SYSTEM.ADR("LVN_ITEMCHANGING")},
    {COMMCTRL.LVN_ITEMCHANGED,      SYSTEM.ADR("LVN_ITEMCHANGED")},
    {COMMCTRL.LVN_INSERTITEM,       SYSTEM.ADR("LVN_INSERTITEM")},
    {COMMCTRL.LVN_DELETEITEM,       SYSTEM.ADR("LVN_DELETEITEM")},
    {COMMCTRL.LVN_DELETEALLITEMS,   SYSTEM.ADR("LVN_DELETEALLITEMS")},
    {COMMCTRL.LVN_BEGINLABELEDITA,  SYSTEM.ADR("LVN_BEGINLABELEDITA")},
    {COMMCTRL.LVN_BEGINLABELEDITW,  SYSTEM.ADR("LVN_BEGINLABELEDITW")},
    {COMMCTRL.LVN_ENDLABELEDITA,    SYSTEM.ADR("LVN_ENDLABELEDITA")},
    {COMMCTRL.LVN_ENDLABELEDITW,    SYSTEM.ADR("LVN_ENDLABELEDITW")},
    {COMMCTRL.LVN_COLUMNCLICK,      SYSTEM.ADR("LVN_COLUMNCLICK")},
    {COMMCTRL.LVN_BEGINDRAG,        SYSTEM.ADR("LVN_BEGINDRAG")},
    {COMMCTRL.LVN_BEGINRDRAG,       SYSTEM.ADR("LVN_BEGINRDRAG")},
    {COMMCTRL.LVN_GETDISPINFOA,     SYSTEM.ADR("LVN_GETDISPINFOA")},
    {COMMCTRL.LVN_GETDISPINFOW,     SYSTEM.ADR("LVN_GETDISPINFOW")},
    {COMMCTRL.LVN_SETDISPINFOA,     SYSTEM.ADR("LVN_SETDISPINFOA")},
    {COMMCTRL.LVN_SETDISPINFOW,     SYSTEM.ADR("LVN_SETDISPINFOW")},
    {COMMCTRL.LVN_KEYDOWN,          SYSTEM.ADR("LVN_KEYDOWN")},
    {COMMCTRL.HDN_ITEMCHANGINGA,    SYSTEM.ADR("HDN_ITEMCHANGINGA")},
    {COMMCTRL.HDN_ITEMCHANGINGW,    SYSTEM.ADR("HDN_ITEMCHANGINGW")},
    {COMMCTRL.HDN_ITEMCHANGEDA,     SYSTEM.ADR("HDN_ITEMCHANGEDA")},
    {COMMCTRL.HDN_ITEMCHANGEDW,     SYSTEM.ADR("HDN_ITEMCHANGEDW")},
    {COMMCTRL.HDN_ITEMCLICKA,       SYSTEM.ADR("HDN_ITEMCLICKA")},
    {COMMCTRL.HDN_ITEMCLICKW,       SYSTEM.ADR("HDN_ITEMCLICKW")},
    {COMMCTRL.HDN_ITEMDBLCLICKA,    SYSTEM.ADR("HDN_ITEMDBLCLICKA")},
    {COMMCTRL.HDN_ITEMDBLCLICKW,    SYSTEM.ADR("HDN_ITEMDBLCLICKW")},
    {COMMCTRL.HDN_DIVIDERDBLCLICKA, SYSTEM.ADR("HDN_DIVIDERDBLCLICKA")},
    {COMMCTRL.HDN_DIVIDERDBLCLICKW, SYSTEM.ADR("HDN_DIVIDERDBLCLICKW")},
    {COMMCTRL.HDN_BEGINTRACKA,      SYSTEM.ADR("HDN_BEGINTRACKA")},
    {COMMCTRL.HDN_BEGINTRACKW,      SYSTEM.ADR("HDN_BEGINTRACKW")},
    {COMMCTRL.HDN_ENDTRACKA,        SYSTEM.ADR("HDN_ENDTRACKA")},
    {COMMCTRL.HDN_ENDTRACKW,        SYSTEM.ADR("HDN_ENDTRACKW")},
    {COMMCTRL.HDN_TRACKA,           SYSTEM.ADR("HDN_TRACKA")},
    {COMMCTRL.HDN_TRACKW,           SYSTEM.ADR("HDN_TRACKW")},
    {COMMCTRL.TVN_SELCHANGINGA,     SYSTEM.ADR("TVN_SELCHANGINGA")},
    {COMMCTRL.TVN_SELCHANGINGW,     SYSTEM.ADR("TVN_SELCHANGINGW")},
    {COMMCTRL.TVN_SELCHANGEDA,      SYSTEM.ADR("TVN_SELCHANGEDA")},
    {COMMCTRL.TVN_SELCHANGEDW,      SYSTEM.ADR("TVN_SELCHANGEDW")},
    {COMMCTRL.TVN_GETDISPINFOA,     SYSTEM.ADR("TVN_GETDISPINFOA")},
    {COMMCTRL.TVN_GETDISPINFOW,     SYSTEM.ADR("TVN_GETDISPINFOW")},
    {COMMCTRL.TVN_SETDISPINFOA,     SYSTEM.ADR("TVN_SETDISPINFOA")},
    {COMMCTRL.TVN_SETDISPINFOW,     SYSTEM.ADR("TVN_SETDISPINFOW")},
    {COMMCTRL.TVN_ITEMEXPANDINGA,   SYSTEM.ADR("TVN_ITEMEXPANDINGA")},
    {COMMCTRL.TVN_ITEMEXPANDINGW,   SYSTEM.ADR("TVN_ITEMEXPANDINGW")},
    {COMMCTRL.TVN_ITEMEXPANDEDA,    SYSTEM.ADR("TVN_ITEMEXPANDEDA")},
    {COMMCTRL.TVN_ITEMEXPANDEDW,    SYSTEM.ADR("TVN_ITEMEXPANDEDW")},
    {COMMCTRL.TVN_BEGINDRAGA,       SYSTEM.ADR("TVN_BEGINDRAGA")},
    {COMMCTRL.TVN_BEGINDRAGW,       SYSTEM.ADR("TVN_BEGINDRAGW")},
    {COMMCTRL.TVN_BEGINRDRAGA,      SYSTEM.ADR("TVN_BEGINRDRAGA")},
    {COMMCTRL.TVN_BEGINRDRAGW,      SYSTEM.ADR("TVN_BEGINRDRAGW")},
    {COMMCTRL.TVN_DELETEITEMA,      SYSTEM.ADR("TVN_DELETEITEMA")},
    {COMMCTRL.TVN_DELETEITEMW,      SYSTEM.ADR("TVN_DELETEITEMW")},
    {COMMCTRL.TVN_BEGINLABELEDITA,  SYSTEM.ADR("TVN_BEGINLABELEDITA")},
    {COMMCTRL.TVN_BEGINLABELEDITW,  SYSTEM.ADR("TVN_BEGINLABELEDITW")},
    {COMMCTRL.TVN_ENDLABELEDITA,    SYSTEM.ADR("TVN_ENDLABELEDITA")},
    {COMMCTRL.TVN_ENDLABELEDITW,    SYSTEM.ADR("TVN_ENDLABELEDITW")},
    {COMMCTRL.TVN_KEYDOWN,          SYSTEM.ADR("TVN_KEYDOWN")},
    {COMMCTRL.TTN_NEEDTEXTA,        SYSTEM.ADR("TTN_NEEDTEXTA")},
    {COMMCTRL.TTN_NEEDTEXTW,        SYSTEM.ADR("TTN_NEEDTEXTW")},
    {COMMCTRL.TTN_SHOW,             SYSTEM.ADR("TTN_SHOW")},
    {COMMCTRL.TTN_POP,              SYSTEM.ADR("TTN_POP")},
    {COMMCTRL.TCN_KEYDOWN,          SYSTEM.ADR("TCN_KEYDOWN")},
    {COMMCTRL.TCN_SELCHANGE,        SYSTEM.ADR("TCN_SELCHANGE")},
    {COMMCTRL.TCN_SELCHANGING,      SYSTEM.ADR("TCN_SELCHANGING")},
    {COMMCTRL.TBN_GETBUTTONINFOA,   SYSTEM.ADR("TBN_GETBUTTONINFOA")},
    {COMMCTRL.TBN_GETBUTTONINFOW,   SYSTEM.ADR("TBN_GETBUTTONINFOW")},
    {COMMCTRL.TBN_BEGINDRAG,        SYSTEM.ADR("TBN_BEGINDRAG")},
    {COMMCTRL.TBN_ENDDRAG,          SYSTEM.ADR("TBN_ENDDRAG")},
    {COMMCTRL.TBN_BEGINADJUST,      SYSTEM.ADR("TBN_BEGINADJUST")},
    {COMMCTRL.TBN_ENDADJUST,        SYSTEM.ADR("TBN_ENDADJUST")},
    {COMMCTRL.TBN_RESET,            SYSTEM.ADR("TBN_RESET")},
    {COMMCTRL.TBN_QUERYINSERT,      SYSTEM.ADR("TBN_QUERYINSERT")},
    {COMMCTRL.TBN_QUERYDELETE,      SYSTEM.ADR("TBN_QUERYDELETE")},
    {COMMCTRL.TBN_TOOLBARCHANGE,    SYSTEM.ADR("TBN_TOOLBARCHANGE")},
    {COMMCTRL.TBN_CUSTHELP,         SYSTEM.ADR("TBN_CUSTHELP")},
    {COMMCTRL.UDN_DELTAPOS,         SYSTEM.ADR("UDN_DELTAPOS")},
    {COMMCTRL.PSN_SETACTIVE,        SYSTEM.ADR("PSN_SETACTIVE")},
    {COMMCTRL.PSN_KILLACTIVE,       SYSTEM.ADR("PSN_KILLACTIVE")},
    {COMMCTRL.PSN_APPLY,            SYSTEM.ADR("PSN_APPLY")},
    {COMMCTRL.PSN_RESET,            SYSTEM.ADR("PSN_RESET")},
    {COMMCTRL.PSN_HELP,             SYSTEM.ADR("PSN_HELP")},
    {COMMCTRL.PSN_WIZBACK,          SYSTEM.ADR("PSN_WIZBACK")},
    {COMMCTRL.PSN_WIZNEXT,          SYSTEM.ADR("PSN_WIZNEXT")},
    {COMMCTRL.PSN_WIZFINISH,        SYSTEM.ADR("PSN_WIZFINISH")},
    {COMMCTRL.PSN_QUERYCANCEL,      SYSTEM.ADR("PSN_QUERYCANCEL")}
     };
NOTIFY_COUNT := SIZE(cnLookupTable) / SIZE(CONTROLNOTIFICATIONS);

END Notify.
