IMPLEMENTATION MODULE TreeData;
IMPORT SYSTEM;
BEGIN
     itemAnimate := ItemAnimateArray
  {
    { TYPE_ITEM, NIL,SYSTEM.ADR("ACM_OPEN"),SYSTEM.ADR("BOOL Animate_Open(hwnd, szName)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("ACM_PLAY"),SYSTEM.ADR("BOOL Animate_Play(hwnd, from, to, rep)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("ACM_STOP"),SYSTEM.ADR("BOOL Animate_Stop(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Close File"),SYSTEM.ADR("BOOL Animate_Close(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Seek Frame"),SYSTEM.ADR("BOOL Animate_Seek(hwnd, frame)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
  };

(*******************************************************************-          *)
(* ********** Header Control Messages**********                                *)
(*******************************************************************-          *)
     itemHeader  := ItemHeaderArray
   {
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_DELETEITEM"),SYSTEM.ADR("BOOL Header_DeleteItem(hwndHD, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_GETITEM"),SYSTEM.ADR("BOOL Header_GetItem(hwndHD, i, phdi)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_GETITEMCOUNT"),SYSTEM.ADR("int Header_GetItemCount(hwndHD)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_HITTEST"),SYSTEM.ADR("int Header_HitTest(hwndHD, phdhti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_INSERTITEM"),SYSTEM.ADR("int Header_InsertItem(hwndHD, i, phdi)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_LAYOUT"),SYSTEM.ADR("BOOL Header_Layout(hwndHD, playout)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HDM_SETITEM"),SYSTEM.ADR("BOOL Header_SetItem(hwndHD, i, phdi)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };


(*******************************************************************-          *)
(* ********** Hot Key Control Messages **********                              *)
(*******************************************************************-          *)
     itemHotKey := ItemHotKeyArray
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("HKM_SETHOTKEY"),SYSTEM.ADR("void HotKey_SetHotKey(hwnd, bVKHotKey, bfMods)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HKM_GETHOTKEY"),SYSTEM.ADR("DWORD HotKey_GetHotKey(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("HKM_SETRULES"),SYSTEM.ADR("void HotKey_SetRules(hwnd, fwCombInv, fwModInv)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Image List Control Messages **********                           *)
(*******************************************************************-          *)
(* Create\Destroy\Save Image List                                              *)
     itemImageList1 := ItemImageList1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create"),SYSTEM.ADR("HIMAGELIST ImageList_Create(int cx, int cy, UINT flags, int cInitial, int cGrow)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Destroy"),SYSTEM.ADR("BOOL ImageList_Destroy(HIMAGELIST himl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create from Bitmap"),SYSTEM.ADR("HIMAGELIST ImageList_LoadBitmap(HINSTANCE hi, LPCSTR lpbmp, int cx, int cGrow, COLORREF crMask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create from Bitmap, Cursor, or Icon"),SYSTEM.ADR("HIMAGELIST ImageList_LoadImage(HINSTANCE hi, LPCSTR lpbmp, int cx, int cGrow, COLORREF crMask, UINT uType, UINT uFlags)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Merge 2 Images BAND Create New Image List"),SYSTEM.ADR("HIMAGELIST ImageList_Merge(HIMAGELIST himl1, int i1, HIMAGELIST himl2, int i2, int dx, int dy)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Read from a Stream"),SYSTEM.ADR("HIMAGELIST ImageList_Read(LPSTREAM pstm)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Write to a Stream"),SYSTEM.ADR("BOOL ImageList_Write(HIMAGELIST himl, LPSTREAM pstm)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Modify Image List                                                           *)
     itemImageList2 := ItemImageList2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Add from Bitmap"),SYSTEM.ADR("int ImageList_Add(HIMAGELIST himl, HBITMAP hbmImage, HBITMAP hbmMask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Add from Icon"),SYSTEM.ADR("int ImageList_AddIcon(HIMAGELIST himl, HICON hicon)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Add from Bitmap, masking"),SYSTEM.ADR("int ImageList_AddMasked(HIMAGELIST himl, HBITMAP hbmImage, COLORREF crMask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Remove image"),SYSTEM.ADR("BOOL ImageList_Remove(HIMAGELIST himl, int i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Remove all images"),SYSTEM.ADR("BOOL ImageList_RemoveAll(HIMAGELIST himl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Replace image from a bitmap"),SYSTEM.ADR("BOOL ImageList_Replace(HIMAGELIST himl, int i, HBITMAP hbmImage, HBITMAP hbmMask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Replace image from an icon"),SYSTEM.ADR("int ImageList_ReplaceIcon(HIMAGELIST himl, int i, HICON hicon)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Identify image to use as overlay"),SYSTEM.ADR("BOOL ImageList_SetOverlayImage(HIMAGELIST himl, int iImage, int iOverlay)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Drag Images                                                                 *)
     itemImageList3 := ItemImageList3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create temporary dragging image list"),SYSTEM.ADR("HIMAGELIST ImageList_GetDragImage(POINT FAR* ppt,POINT FAR* pptHotspot)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create cursor for dragging"),SYSTEM.ADR("BOOL ImageList_SetDragCursorImage(HIMAGELIST himlDrag, int iDrag, int dxHotspot, int dyHotspot)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Start drag"),SYSTEM.ADR("BOOL ImageList_BeginDrag(HIMAGELIST himlTrack, int iTrack, int dxHotspot, int dyHotspot)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Move drag"),SYSTEM.ADR("BOOL ImageList_DragMove(int x, int y)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("End drag"),SYSTEM.ADR("void ImageList_EndDrag()")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Lock window"),SYSTEM.ADR("BOOL ImageList_DragEnter(hwnd hwndLock, int x, int y)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Unlock window"),SYSTEM.ADR("BOOL ImageList_DragLeave(hwnd hwndLock)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Show\hide drag image"),SYSTEM.ADR("BOOL ImageList_DragShowNolock(BOOL fShow)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Draw Images                                                                 *)
     itemImageList4 := ItemImageList4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Simple Image Draw"),SYSTEM.ADR("BOOL ImageList_Draw(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, UINT fStyle)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Draw with Color Blend"), SYSTEM.ADR("BOOL ImageList_DrawEx(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, int dx, int dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Create Icon\Cursor from Image List                                          *)
     itemImageList5 := ItemImageList5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create icon or cursor"),SYSTEM.ADR("HICON ImageList_ExtractIcon(hi, himl, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Create icon or cursor"),SYSTEM.ADR("HICON ImageList_GetIcon(HIMAGELIST himl, int i, UINT flags)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Set\Query Attributes                                                        *)
     itemImageList6 := ItemImageList6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Query number of images"),SYSTEM.ADR("int ImageList_GetImageCount(HIMAGELIST himl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Query bitmap handles BAND image size"),SYSTEM.ADR("BOOL ImageList_GetImageInfo(HIMAGELIST himl, int i, IMAGEINFO FAR* pImageInfo)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Query background color"),SYSTEM.ADR("COLORREF ImageList_GetBkColor(HIMAGELIST himl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Set background color"),SYSTEM.ADR("COLORREF ImageList_SetBkColor(HIMAGELIST himl, COLORREF clrBk)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Query image size"),SYSTEM.ADR("BOOL ImageList_GetIconSize(HIMAGELIST himl, int FAR *cx, int FAR *cy)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Set size of all images BAND clear list"),SYSTEM.ADR("BOOL ImageList_SetIconSize(HIMAGELIST himl, int cx, int cy)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** List View Control Messages **********                            *)
(*******************************************************************-          *)
(* Modify Item List                                                            *)
     itemListView1 := ItemListView1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_INSERTITEM       "),SYSTEM.ADR("int ListView_InsertItem(hwnd, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_DELETEITEM       "),SYSTEM.ADR("BOOL ListView_DeleteItem(hwnd, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_DELETEALLITEMS   "),SYSTEM.ADR("BOOL ListView_DeleteAllItems(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Control Attributes                                                          *)

     itemListView2 := ItemListView2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMCOUNT"),SYSTEM.ADR("int ListView_GetItemCount(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEMCOUNT"),SYSTEM.ADR("VOID ListView_SetItemCount(hwndLV, cItems)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETSELECTEDCOUNT"),SYSTEM.ADR("UINT ListView_GetSelectedCount(hwndLV)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETCALLBACKMASK"),SYSTEM.ADR("UINT ListView_GetCallbackMask(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETCALLBACKMASK"),SYSTEM.ADR("BOOL ListView_SetCallbackMask(hwnd, mask)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Drawing Attributes                                                          *)
     itemListView3 := ItemListView3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETBKCOLOR"),SYSTEM.ADR("COLORREF ListView_GetBkColor(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETBKCOLOR"),SYSTEM.ADR("BOOL ListView_SetBkColor(hwnd, clrBk)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETIMAGELIST"),SYSTEM.ADR("HIMAGELIST ListView_GetImageList(hwnd, iImageList)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETIMAGELIST"),SYSTEM.ADR("HIMAGELIST ListView_SetImageList(hwnd, himl, iImageList)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETTEXTCOLOR"),SYSTEM.ADR("COLORREF ListView_GetTextColor(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETTEXTCOLOR"),SYSTEM.ADR("BOOL ListView_SetTextColor(hwnd, clrText)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETTEXTBKCOLOR"),SYSTEM.ADR("COLORREF ListView_GetTextBkColor(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETTEXTBKCOLOR"),SYSTEM.ADR("BOOL ListView_SetTextBkColor(hwnd, clrTextBk)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETORIGIN"),SYSTEM.ADR("BOOL ListView_GetOrigin(hwndLV, ppt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETVIEWRECT"),SYSTEM.ADR("BOOL ListView_GetViewRect(hwnd, prc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMSPACING"),SYSTEM.ADR("DWORD ListView_GetItemSpacing(hwndLV, fSmall)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Item Attributes                                                             *)
     itemListView4 := ItemListView4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEM          "),SYSTEM.ADR("BOOL ListView_GetItem(hwnd, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEM          "),SYSTEM.ADR("BOOL ListView_SetItem(hwnd, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMRECT      "),SYSTEM.ADR("BOOL ListView_GetItemRect(hwnd, i, prc, code)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMPOSITION  "),SYSTEM.ADR("BOOL ListView_GetItemPosition(hwndLV, i, ppt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEMPOSITION  "),SYSTEM.ADR("BOOL ListView_SetItemPosition(hwndLV, i, x, y)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEMPOSITION32"),SYSTEM.ADR("VOID ListView_SetItemPosition32(hwndLV, i, x, y)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETSTRINGWIDTH   "),SYSTEM.ADR("int ListView_GetStringWidth(hwndLV, psz)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMSTATE     "),SYSTEM.ADR("UINT ListView_GetItemState(hwndLV, i, mask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEMSTATE     "),SYSTEM.ADR("BOOL ListView_SetItemState(hwndLV, i, data, mask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETITEMTEXT      "),SYSTEM.ADR("VOID ListViewGetItemText(hwndLV, i, iSubItem, pszText, cchTextMax_)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETITEMTEXT      "),SYSTEM.ADR("VOID ListViewSetItemText(hwndLV, i, iSubItem, pszText_)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Column Attributes                                                           *)
     itemListView5 := ItemListView5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETCOLUMN        "),SYSTEM.ADR("BOOL ListView_GetColumn(hwnd, iCol, pcol)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETCOLUMN        "),SYSTEM.ADR("BOOL ListView_SetColumn(hwnd, iCol, pcol)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_INSERTCOLUMN     "),SYSTEM.ADR("int ListView_InsertColumn(hwnd, iCol, pcol)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_DELETECOLUMN     "),SYSTEM.ADR("BOOL ListView_DeleteColumn(hwnd, iCol)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETCOLUMNWIDTH   "),SYSTEM.ADR("int ListView_GetColumnWidth(hwnd, iCol)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SETCOLUMNWIDTH   "),SYSTEM.ADR("BOOL ListView_SetColumnWidth(hwnd, iCol, cx)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Reorganize or Redraw List                                                   *)
     itemListView6 := ItemListView6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_REDRAWITEMS      "),SYSTEM.ADR("BOOL ListView_RedrawItems(hwndLV, iFirst, iLast)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_ARRANGE          "),SYSTEM.ADR("BOOL ListView_Arrange(hwndLV, code)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_UPDATE           "),SYSTEM.ADR("BOOL ListView_Update(hwndLV, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SORTITEMS        "),SYSTEM.ADR("BOOL ListViewSortItems(hwndLV, pfnCompare, _lPrm)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Scrolling Attributes                                                        *)
     itemListView7 := ItemListView7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETTOPINDEX"),SYSTEM.ADR("int ListView_GetTopIndex(hwndLV)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETCOUNTPERPAGE"),SYSTEM.ADR("int ListView_GetCountPerPage(hwndLV)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_ENSUREVISIBLE"),SYSTEM.ADR("BOOL ListView_EnsureVisible(hwndLV, i, fPartialOK)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_SCROLL"),SYSTEM.ADR("BOOL ListView_Scroll(hwndLV, dx, dy)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Search Item List                                                            *)
     itemListView8 := ItemListView8Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETNEXTITEM"),SYSTEM.ADR("int ListView_GetNextItem(hwnd, i, flags)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_FINDITEM"),SYSTEM.ADR("int ListView_FindItem(hwnd, iStart, plvfi)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Mouse \ Keyboard Input                                                      *)
     itemListView9 := ItemListView9Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_CREATEDRAGIMAGE  "),SYSTEM.ADR("HIMAGELIST ListView_CreateDragImage(hwnd, i, lpptUpLeft)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETISEARCHSTRING "),SYSTEM.ADR("BOOL ListView_GetISearchString(hwndLV, lpsz)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_HITTEST          "),SYSTEM.ADR("int ListView_HitTest(hwndLV, pinfo)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* In-Place Label Editing                                                      *)
     itemListView0 := ItemListView0Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_EDITLABEL        "),SYSTEM.ADR("hwnd ListView_EditLabel(hwndLV, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("LVM_GETEDITCONTROL   "),SYSTEM.ADR("hwnd ListView_GetEditControl(hwndLV)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
     itemProgress  := ItemProgressArray
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PBM_SETRANGE"),SYSTEM.ADR("DWORD Progress_SetRange(hwnd, nMinRange, nMaxRange)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PBM_SETPOS"),SYSTEM.ADR("int Progress_SetPos(hwnd, nNewPos)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PBM_DELTAPOS"),SYSTEM.ADR("int Progress_DeltaPos(hwnd, nIncrement)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PBM_SETSTEP"),SYSTEM.ADR("int Progress_SetStep(hwnd, nStepInc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PBM_STEPIT"),SYSTEM.ADR("int Progress_StepIt(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Property Sheet Control Messages **********                       *)
(*******************************************************************-          *)
(* Modify Property Sheet                                                       *)
     itemPropSheet1 := ItemPropSheet1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_ADDPAGE"),SYSTEM.ADR("BOOL PropSheet_AddPage(hDlg, hpage)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_REMOVEPAGE"),SYSTEM.ADR("VOID PropSheet_RemovePage(hDlg, index, hpage)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_SETTITLE"),SYSTEM.ADR("VOID PropSheet_SetTitle(hDlg, wStyle, lpszText)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Property Sheet Button State                                                 *)
     itemPropSheet2 := ItemPropSheet2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_APPLY"),SYSTEM.ADR("BOOL PropSheet_Apply(hDlg)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_CHANGED"),SYSTEM.ADR("BOOL PropSheet_Changed(hDlg, hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_UNCHANGED"),SYSTEM.ADR("VOID PropSheet_UnChanged(hDlg, hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_CANCELTOCLOSE"),SYSTEM.ADR("VOID PropSheet_CancelToClose(hDlg)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_PRESSBUTTON"),SYSTEM.ADR("BOOL PropSheet_PressButton(hDlg, iButton)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Wizard Button State                                                         *)
     itemPropSheet3 := ItemPropSheet3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_SETFINISHTEXT"),SYSTEM.ADR("VOID PropSheet_SetFinishText(hDlg, lpszText)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_SETWIZBUTTONS"),SYSTEM.ADR("VOID PropSheet_SetWizButtons(hDlg, dwFlags)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_PRESSBUTTON"),SYSTEM.ADR("BOOL PropSheet_PressButton(hDlg, iButton)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* System Restart                                                              *)
     itemPropSheet4 := ItemPropSheet4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_RESTARTWINDOWS "),SYSTEM.ADR("VOID PropSheet_RestartWindows(hDlg)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_REBOOTSYSTEM"),SYSTEM.ADR("VOID PropSheet_RebootSystem(hDlg)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Query Window Handle                                                         *)
     itemPropSheet5 := ItemPropSheet5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_GETTABCONTROL"),SYSTEM.ADR("hwnd PropSheet_GetTabControl(hDlg)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_GETCURRENTPAGEhwnd"),SYSTEM.ADR("hwnd PropSheet_GetCurrentPagehwnd(hDlg)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Activate Specific Page                                                      *)
     itemPropSheet6 := ItemPropSheet6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_SETCURSEL"),SYSTEM.ADR("BOOL PropSheet_SetCurSel(hDlg, hpage, index)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_SETCURSELID"),SYSTEM.ADR("BOOL PropSheet_SetCurSelByID(hDlg, id)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Forward Message to All Property Pages                                       *)
     itemPropSheet7 := ItemPropSheet7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_ISDIALOGMESSAGE"),SYSTEM.ADR("BOOL PropSheet_IsDialogMessage(hDlg, pMsg)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("PSM_QUERYSIBLINGS"),SYSTEM.ADR("int PropSheet_QuerySiblings(hDlg, wParam, lParam)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Rich Edit Control Messages **********                            *)
(*******************************************************************-          *)
(* Read\Write Text                                                             *)
     itemRichEdit1 := ItemRichEdit1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Text"),SYSTEM.ADR("int RichEdit_GetText(hwndCtl, lpch, cchMax)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Text Length"),SYSTEM.ADR(" int RichEdit_GetTextLength(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Set Text"),SYSTEM.ADR(" BOOL RichEdit_SetText(hwndCtl, lpsz)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETLINE"),SYSTEM.ADR("int RichEdit_GetLine(hwndCtl, line, lpch, cchMax)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_REPLACESEL"),SYSTEM.ADR("void RichEdit_ReplaceSel(hwndCtl, lpszReplace)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETTEXTRANGE"),SYSTEM.ADR("int RichEdit_GetTextRange (hwnd, lpRange) ")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Search                                                                      *)
     itemRichEdit2 := ItemRichEdit2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_FINDTEXT"),SYSTEM.ADR("int RichEdit_FindText (hwnd, fuFlags, lpFindText) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_FINDTEXTEX"),SYSTEM.ADR("int RichEdit_FindTextEx (hwnd, fuFlags, lpFindText) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_FINDWORDBREAK "),SYSTEM.ADR("int RichEdit_FindWordBreak (hwnd, code, ichStart) ")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Text Selection                                                              *)
     itemRichEdit3 := ItemRichEdit3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETSEL"),SYSTEM.ADR("DWORD RichEdit_GetSel(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_EXGETSEL"),SYSTEM.ADR("void RichEdit_ExGetSel (hwnd, lpchr) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETSEL"),SYSTEM.ADR("void RichEdit_SetSel(hwndCtl, ichStart, ichEnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_EXSETSEL"),SYSTEM.ADR("int RichEdit_ExSetSel (hwnd, ichCharRange)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SELECTIONTYPE "),SYSTEM.ADR("int RichEdit_SelectionType (hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Text Attributes                                                             *)
     itemRichEdit4 := ItemRichEdit4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETLIMITTEXT"),SYSTEM.ADR("int RichEdit_GetLimitText (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_LIMITTEXT"),SYSTEM.ADR("void RichEdit_LimitText(hwndCtl, cchMax)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_EXLIMITTEXT "),SYSTEM.ADR("void RichEdit_ExLimitText (hwnd, cchTextMax) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETLINECOUNT"),SYSTEM.ADR("int RichEdit_GetLineCount(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETMODIFY"),SYSTEM.ADR("BOOL RichEdit_GetModify(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETMODIFY"),SYSTEM.ADR("void RichEdit_SetModify(hwndCtl, fModified)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETFIRSTVISIBLELINE"),SYSTEM.ADR("int RichEdit_GetFirstVisibleLine(hwndCtl)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Scrolling                                                                   *)
     itemRichEdit5 := ItemRichEdit5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SCROLLCARET"),SYSTEM.ADR("BOOL RichEdit_ScrollCaret(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_LINESCROLL"),SYSTEM.ADR("void RichEdit_Scroll(hwndCtl, dv, dh)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Text Query                                                                  *)
     itemRichEdit6 := ItemRichEdit6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_LINEFROMCHAR"),SYSTEM.ADR("int RichEdit_LineFromChar(hwndCtl, ich)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_EXLINEFROMCHAR"),SYSTEM.ADR("int RichEdit_ExLineFromChar (hwnd, ichCharPos)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_LINEINDEX"),SYSTEM.ADR("int RichEdit_LineIndex(hwndCtl, line)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_LINELENGTH"),SYSTEM.ADR("int RichEdit_LineLength(hwndCtl, line)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_CHARFROMPOS "),SYSTEM.ADR("DWORD RichEdit_CharFromPos (hwnd, x, y)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETSELTEXT"),SYSTEM.ADR("int RichEdit_GetSelText (hwnd, lpBuf) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_POSFROMCHAR "),SYSTEM.ADR("DWORD RichEdit_PosFromChar (hwnd, wCharIndex)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Edit Menu Features                                                          *)
     itemRichEdit7 := ItemRichEdit7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_CANUNDO"),SYSTEM.ADR("BOOL RichEdit_CanUndo(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_UNDO"),SYSTEM.ADR("BOOL RichEdit_Undo(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_EMPTYUNDOBUFFER"),SYSTEM.ADR("void RichEdit_EmptyUndoBuffer(hwndCtl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_CANPASTE"),SYSTEM.ADR("BOOL RichEdit_CanPaste (hwnd, uFormat)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_PASTESPECIAL"),SYSTEM.ADR("void RichEdit_PasteSpecial (hwnd, uFormat)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Window state                                                                *)
     itemRichEdit8 := ItemRichEdit8Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Enable \ Disable Control"),SYSTEM.ADR("BOOL RichEdit_Enable(hwndCtl, fEnable)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETREADONLY"),SYSTEM.ADR("BOOL RichEdit_SetReadOnly(hwndCtl, fReadOnly)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETOPTIONS"),SYSTEM.ADR("UINT RichEdit_GetOptions (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETOPTIONS"),SYSTEM.ADR("UINT RichEdit_SetOptions (hwnd, fOperation, fOptions)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_HIDESELECTION "),SYSTEM.ADR("void RichEdit_HideSelection (hwnd, fHide, fChangeStyle)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETBKGNDCOLOR "),SYSTEM.ADR("COLORREF RichEdit_SetBkgndColor (hwnd, fUseSysColor, clr)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Set \ Get Word Break Proc                                                   *)
     itemRichEdit9 := ItemRichEdit9Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETWORDBREAKPROC"),SYSTEM.ADR("void RichEdit_SetWordBreakProc(hwndCtl, lpfnWordBreak)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETWORDBREAKPROC"),SYSTEM.ADR("EDITWORDBREAKPROC RichEdit_GetWordBreakProc(hwndCtl)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Printing                                                                    *)
     itemRichEdit10 := ItemRichEdit10Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_DISPLAYBAND "),SYSTEM.ADR("BOOL RichEdit_DisplayBand (hwnd, lprc) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_FORMATRANGE "),SYSTEM.ADR("int RichEdit_FormatRange (hwnd, fRender, lpFmt) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETTARGETDEVICE "),SYSTEM.ADR("BOOL RichEdit_SetTargetDevice (hwnd, hdcTarget, cxLineWidth)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Formatting                                                                  *)
     itemRichEdit11 := ItemRichEdit11Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETRECT"),SYSTEM.ADR("void RichEdit_GetRect(hwndCtl, lprc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETRECT"),SYSTEM.ADR("void RichEdit_SetRect(hwndCtl, lprc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETCHARFORMAT "),SYSTEM.ADR("DWORD RichEdit_GetCharFormat (hwnd, fSelection, lpFmt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETCHARFORMAT "),SYSTEM.ADR("BOOL RichEdit_SetCharFormat (hwnd, uFlags, lpFmt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETPARAFORMAT "),SYSTEM.ADR("DWORD RichEdit_GetParaFormat (hwnd, lpFmt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETPARAFORMAT "),SYSTEM.ADR("BOOL RichEdit_SetParaFormat (hwnd, lpFmt)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETWORDBREAKPROCEX"),SYSTEM.ADR("EDITWORDBREAKPROCEX * RichEdit_GetWordBreakProcEx (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETWORDBREAKPROCEX"),SYSTEM.ADR("EDITWORDBREAKPROCEX * RichEdit_SetWordBreakProcEx (hwnd, pfnWordBreakProcEx)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Event Notification Messages                                                 *)
     itemRichEdit12 := ItemRichEdit12Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETEVENTMASK"),SYSTEM.ADR("DWORD RichEdit_GetEventMask (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETEVENTMASK"),SYSTEM.ADR("DWORD RichEdit_SetEventMask (hwnd, dwMask)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_REQUESTRESIZE "),SYSTEM.ADR("void RichEdit_RequestResize (hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* OLE Support                                                                 *)
     itemRichEdit13 := ItemRichEdit13Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_GETOLEINTERFACE "),SYSTEM.ADR("BOOL RichEdit_GetOleInterface (hwnd, ppObject) ")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_SETOLECALLBACK"),SYSTEM.ADR("BOOL RichEdit_SetOleCallback (hwnd, lpObj)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Stream Support                                                              *)
     itemRichEdit14 := ItemRichEdit14Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_STREAMIN"),SYSTEM.ADR("int RichEdit_StreamIn (hwnd, uFormat, lpStream)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("EM_STREAMOUT "),SYSTEM.ADR("int RichEdit_StreamOut (hwnd, uFormat, lpStream)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Status Bar Control Messages **********                           *)
(*******************************************************************-          *)
     itemStatus := ItemStatusArray
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_GETBORDERS"),SYSTEM.ADR("BOOL Status_GetBorders(hwnd, aBorders)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_GETPARTS"),SYSTEM.ADR("int Status_GetParts(hwnd, nParts, aRightCoord)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_SETPARTS"),SYSTEM.ADR("BOOL Status_SetParts(hwnd, nParts, aWidths)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_GETRECT"),SYSTEM.ADR("BOOL Status_GetRect(hwnd, iPart, lprc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_GETTEXT"),SYSTEM.ADR("DWORD Status_GetText(hwnd, iPart, szText)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_SETTEXT"),SYSTEM.ADR("BOOL Status_SetText(hwnd, iPart, uType, szText)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_GETTEXTLENGTH"),SYSTEM.ADR("DWORD Status_GetTextLength(hwnd, iPart)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_SETMINHEIGHT"),SYSTEM.ADR("void Status_SetMinHeight(hwnd, minHeight)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("SB_SIMPLE"),SYSTEM.ADR("BOOL Status_Simple(hwnd, fSimple)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Tab Control Messages **********                                  *)
(*******************************************************************-          *)
(* Initialization                                                              *)
     itemTab1 := ItemTab1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETPADDING"),SYSTEM.ADR("void TabCtrl_SetPadding(hwnd,cx, cy)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Query                                                                       *)
     itemTab2 := ItemTab2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_ADJUSTRECT"),SYSTEM.ADR("int TabCtrl_AdjustRect(hwnd, bLarger, prc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETITEMCOUNT"),SYSTEM.ADR("int TabCtrl_GetItemCount(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETITEMRECT"),SYSTEM.ADR("BOOL TabCtrl_GetItemRect(hwnd, i, prc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_HITTEST"),SYSTEM.ADR("int TabCtrl_HitTest(hwndTC, pinfo)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETROWCOUNT"),SYSTEM.ADR("int TabCtrl_GetRowCount(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Modify Tab List                                                             *)
     itemTab3 := ItemTab3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETITEM"),SYSTEM.ADR("BOOL TabCtrl_GetItem(hwnd, iItem, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETITEM"),SYSTEM.ADR("BOOL TabCtrl_SetItem(hwnd, iItem, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_INSERTITEM"),SYSTEM.ADR("int TabCtrl_InsertItem(hwnd, iItem, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_DELETEITEM"),SYSTEM.ADR("BOOL TabCtrl_DeleteItem(hwnd, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_DELETEALLITEMS"),SYSTEM.ADR("BOOL TabCtrl_DeleteAllItems(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETITEMEXTRA"),SYSTEM.ADR("BOOL TabCtrl_SetItemExtra(hwndTC, cb)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETITEMSIZE"),SYSTEM.ADR("DWORD TabCtrl_SetItemSize(hwnd, x, y)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Image List and Tool Tips                                                    *)
     itemTab4 := ItemTab4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETIMAGELIST"),SYSTEM.ADR("HIMAGELIST TabCtrl_GetImageList(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETIMAGELIST"),SYSTEM.ADR("HIMAGELIST TabCtrl_SetImageList(hwnd, himl)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_REMOVEIMAGE"),SYSTEM.ADR("void TabCtrl_RemoveImage(hwnd, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETTOOLTIPS"),SYSTEM.ADR("hwnd TabCtrl_GetToolTips(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETTOOLTIPS"),SYSTEM.ADR("void TabCtrl_SetToolTips(hwnd, hwndTT)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };



(* Selection and Focus                                                         *)
     itemTab5 := ItemTab5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETCURSEL"),SYSTEM.ADR("int TabCtrl_GetCurSel(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETCURSEL"),SYSTEM.ADR("int TabCtrl_SetCurSel(hwnd, i)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_GETCURFOCUS"),SYSTEM.ADR("int TabCtrl_GetCurFocus(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TCM_SETCURFOCUS"),SYSTEM.ADR("void TabCtrl_SetCurFocus(hwnd, i)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Tool Bar Control Messages **********                             *)
(*******************************************************************-          *)
(* Initialization                                                              *)
     itemToolBar1 := ItemToolBar1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_BUTTONSTRUCTSIZE "),SYSTEM.ADR("void ToolBar_ButtonStructSize(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ADDBITMAP"),SYSTEM.ADR("int ToolBar_AddBitmap(hwnd, nButtons, lptbab)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ADDSTRING"),SYSTEM.ADR("int ToolBar_AddString(hwnd, hinst, idString)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETBITMAPFLAGS "),SYSTEM.ADR("int ToolBar_GetBitmapFlags(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETBITMAPSIZE"),SYSTEM.ADR("BOOL ToolBar_SetBitmapSize(hwnd, dxBitmap, dyBitmap)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETITEMRECT"),SYSTEM.ADR("BOOL ToolBar_GetItemRect(hwnd, idButton, lprc)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETBUTTONSIZE"),SYSTEM.ADR("BOOL ToolBar_SetButtonSize(hwnd, dxBitmap, dyBitmap)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Handle WM_SIZE Message                                                      *)
     itemToolBar2 := ItemToolBar2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_AUTOSIZE "),SYSTEM.ADR("void ToolBar_AutoSize(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Modify Button List                                                          *)
     itemToolBar3 := ItemToolBar3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ADDBUTTONS "),SYSTEM.ADR("BOOL ToolBar_AddButtons(hwnd, uNumButtons, lpButtons)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_DELETEBUTTON "),SYSTEM.ADR("BOOL ToolBar_DeleteButton(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_INSERTBUTTON "),SYSTEM.ADR("BOOL ToolBar_InsertButton(hwnd, idButton, lpButton)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Button State                                                                *)
     itemToolBar4 := ItemToolBar4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETSTATE "),SYSTEM.ADR("int ToolBar_GetState(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETSTATE "),SYSTEM.ADR("BOOL ToolBar_SetState(hwnd, idButton, fState)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ISBUTTONCHECKED"),SYSTEM.ADR("int ToolBar_IsButtonChecked(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_CHECKBUTTON"),SYSTEM.ADR("BOOL ToolBar_CheckButton(hwnd, idButton, fCheck )")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ISBUTTONENABLED"),SYSTEM.ADR("int ToolBar_IsButtonEnabled(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ENABLEBUTTON "),SYSTEM.ADR("BOOL ToolBar_EnableButton(hwnd, idButton, fEnable )")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ISBUTTONHIDDEN "),SYSTEM.ADR("int ToolBar_IsButtonHidden(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_HIDEBUTTON "),SYSTEM.ADR("BOOL ToolBar_HideButton(hwnd, idButton, fShow)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ISBUTTONINDETERMINATE"),SYSTEM.ADR("int ToolBar_IsButtonIndeterminate(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_INDETERMINATE"),SYSTEM.ADR("BOOL ToolBar_Indeterminate(hwnd, idButton, fIndeterminate)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_ISBUTTONPRESSED"),SYSTEM.ADR("int ToolBar_IsButtonPressed(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_PRESSBUTTON"),SYSTEM.ADR("BOOL ToolBar_PressButton(hwnd, idButton, fPress)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Button Attributes                                                           *)
     itemToolBar5 := ItemToolBar5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_CHANGEBITMAP "),SYSTEM.ADR("BOOL ToolBar_ChangeBitmap(hwnd, idButton, iBitmap)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETCMDID "),SYSTEM.ADR("BOOL ToolBar_SetCmdID(hwnd, index, cmdId)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_COMMANDTOINDEX "),SYSTEM.ADR("int ToolBar_CommandToIndex(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETBITMAP"),SYSTEM.ADR("int ToolBar_GetBitmap(hwnd, idButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETBUTTON"),SYSTEM.ADR("BOOL ToolBar_GetButton(hwnd, idButton, lpButton)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETBUTTONTEXT"),SYSTEM.ADR("int ToolBar_GetButtonText(hwnd, idButton, lpszText)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Tool Bar Attributes                                                         *)
     itemToolBar6 := ItemToolBar6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_BUTTONCOUNT"),SYSTEM.ADR("int ToolBar_ButtonCount(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETPARENT"),SYSTEM.ADR("void ToolBar_SetParent(hwnd, hwndParent)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETROWS"),SYSTEM.ADR("int ToolBar_GetRows(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETROWS"),SYSTEM.ADR("void ToolBar_SetRows(hwnd, cRows, fLarger, lprc)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Display Customize Dialog Box                                                *)
     itemToolBar7 := ItemToolBar7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_CUSTOMIZE"),SYSTEM.ADR("void ToolBar_Customize(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Tool Tip Support                                                            *)
     itemToolBar8 := ItemToolBar8Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_GETTOOLTIPS"),SYSTEM.ADR("hwnd ToolBar_GetToolTips(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SETTOOLTIPS"),SYSTEM.ADR("void ToolBar_SetToolTips(hwnd)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Read \ Write Registry Data                                                  *)
     itemToolBar9 := ItemToolBar9Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_SAVERESTORE"),SYSTEM.ADR("void ToolBar_SaveRestore(hwnd, fSave, ptbsp)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Tool Tip Control Messages **********                             *)
(*******************************************************************-          *)
(* Modify Tool List                                                            *)
     itemToolTip1 := ItemToolTip1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_ADDTOOL"),SYSTEM.ADR("BOOL ToolTip_AddTool (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_DELTOOL"),SYSTEM.ADR("void ToolTip_DelTool (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_NEWTOOLRECT"),SYSTEM.ADR("void ToolTip_NewToolRect (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_SETTOOLINFO"),SYSTEM.ADR("void ToolTip_SetToolInfo (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_UPDATETIPTEXT"),SYSTEM.ADR("void ToolTip_UpdateTipText (hwnd, lpti)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Query                                                                       *)
     itemToolTip2 := ItemToolTip2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_ENUMTOOLS"),SYSTEM.ADR("BOOL ToolTip_EnumTools (hwnd, iTool, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_GETCURRENTTOOL"),SYSTEM.ADR("BOOL ToolTip_GetCurrentTool (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_GETTEXT"),SYSTEM.ADR("void ToolTip_GetText (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_GETTOOLCOUNT"),SYSTEM.ADR("int  ToolTip_GetToolCount (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_GETTOOLINFO"),SYSTEM.ADR("BOOL ToolTip_GetToolInfo (hwnd, lpti)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_HITTEST"),SYSTEM.ADR("BOOL ToolTip_HitText (hwnd, lphti)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Set Tooltip Window State                                                    *)
     itemToolTip3 := ItemToolTip3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_ACTIVATE"),SYSTEM.ADR("void ToolTip_Activate (hwnd, fActivate)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_SETDELAYTIME"),SYSTEM.ADR("void ToolTip_SetDelayTime (hwnd, uFlag, iDelay)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Pass Mouse Message                                                          *)
     itemToolTip4 := ItemToolTip4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_RELAYEVENT"),SYSTEM.ADR("void ToolTip_RelayEvent (hwnd, lpmsg)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Support Subclassing of Tooltips                                             *)
     itemToolTip5 := ItemToolTip5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TTM_WINDOWFROMPOINT"),SYSTEM.ADR("hwnd ToolTip_WindowFromPoint (hwnd, lppt)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Track Bar Control Messages **********                            *)
(*******************************************************************-          *)
(* Trackbar Ticks                                                              *)
     itemTrackBar1 := ItemTrackBar1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MCLEARTICS     "),SYSTEM.ADR("void   TrackBar_ClearTics (hwnd, fRedraw)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETNUMTICS    "),SYSTEM.ADR("LONG   TrackBar_GetNumTics (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETPTICS      "),SYSTEM.ADR("LPLONG TrackBar_GetPTics (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETTIC        "),SYSTEM.ADR("LONG   TrackBar_GetTic (hwnd, iTic)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETTIC        "),SYSTEM.ADR("BOOL   TrackBar_SetTic (hwnd, lPosition)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETTICPOS     "),SYSTEM.ADR("LONG   TrackBar_GetTicPos (hwnd, iTic)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETTICFREQ    "),SYSTEM.ADR("void   TrackBar_SetTicFreq (hwnd, wFreq, lPosition)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Line and Page Increments                                                    *)
     itemTrackBar2 := ItemTrackBar2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETLINESIZE   "),SYSTEM.ADR("LONG   TrackBar_GetLineSize (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETLINESIZE   "),SYSTEM.ADR("LONG   TrackBar_SetLineSize (hwnd, lLineSize)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETPAGESIZE   "),SYSTEM.ADR("LONG   TrackBar_GetPageSize (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETPAGESIZE   "),SYSTEM.ADR("LONG   TrackBar_SetPageSize (hwnd, lPageSize)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Slider Position                                                             *)
     itemTrackBar3 := ItemTrackBar3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETPOS        "),SYSTEM.ADR("LONG   TrackBar_GetPos (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETPOS        "),SYSTEM.ADR("void   TrackBar_SetPos (hwnd, bPosition, lPosition)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Slider Range                                                                *)
     itemTrackBar4 := ItemTrackBar4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETRANGE      "),SYSTEM.ADR("void   TrackBar_SetRange (hwnd, bRedraw, lMinimum, lMaximum)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETRANGEMAX   "),SYSTEM.ADR("LONG   TrackBar_GetRangeMax (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETRANGEMAX   "),SYSTEM.ADR("void   TrackBar_SetRangeMax (hwnd, bRedraw, lMaximum)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETRANGEMIN   "),SYSTEM.ADR("LONG   TrackBar_GetRangeMin (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETRANGEMIN   "),SYSTEM.ADR("void   TrackBar_SetRangeMin (hwnd, bRedraw, lMinimum)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Trackbar Selection                                                          *)
     itemTrackBar5 := ItemTrackBar5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MCLEARSEL      "),SYSTEM.ADR("void   TrackBar_ClearSel (hwnd, fRedraw)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETSELEND     "),SYSTEM.ADR("LONG   TrackBar_GetSelEnd (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETSELEND     "),SYSTEM.ADR("void   TrackBar_SetSelEnd (hwnd, bRedraw, lEnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETSELSTART   "),SYSTEM.ADR("LONG   TrackBar_GetSelStart (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETSELSTART   "),SYSTEM.ADR("void   TrackBar_SetSelStart (hwnd, bRedraw, lStart)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETSEL        "),SYSTEM.ADR("void   TrackBar_SetSel (hwnd, bRedraw, lMinimum, lMaximum)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Trackbar Appearance                                                         *)
     itemTrackBar6 := ItemTrackBar6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETCHANNELRECT"),SYSTEM.ADR("void   TrackBar_GetChannelRect (hwnd, lprc)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Slider (Thumb) Attributes                                                   *)
     itemTrackBar7 := ItemTrackBar7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETTHUMBLENGTH"),SYSTEM.ADR("UINT   TrackBar_GetThumbLength (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MSETTHUMBLENGTH"),SYSTEM.ADR("void   TrackBar_SetThumbLength (hwnd, iLength)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TB_MGETTHUMBRECT  "),SYSTEM.ADR("void   TrackBar_GetThumbRect (hwnd, lprc)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Tree View Control Messages **********                            *)
(*******************************************************************-          *)
(* Modify List                                                                 *)
     itemTreeView1 := ItemTreeView1Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_INSERTITEM      "),SYSTEM.ADR("HTREEITEM TreeView_InsertItem(hwnd, lpis)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_DELETEITEM      "),SYSTEM.ADR("BOOL TreeView_DeleteItem(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Delete All Items    "),SYSTEM.ADR("BOOL TreeView_DeleteAllItems(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETITEM         "),SYSTEM.ADR("BOOL TreeView_GetItem(hwnd, pitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SETITEM         "),SYSTEM.ADR("BOOL TreeView_SetItem(hwnd, pitem)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Item Layout, Display, and Order                                             *)
     itemTreeView2 := ItemTreeView2Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_ENSUREVISIBLE   "),SYSTEM.ADR("BOOL TreeView_EnsureVisible(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_EXPAND          "),SYSTEM.ADR("BOOL TreeView_Expand(hwnd, hitem, code)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETINDENT       "),SYSTEM.ADR("UINT TreeView_GetIndent(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SETINDENT       "),SYSTEM.ADR("BOOL TreeView_SetIndent(hwnd, indent)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SORTCHILDREN    "),SYSTEM.ADR("BOOL TreeView_SortChildren(hwnd, hitem, recurse)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SORTCHILDRENCB  "),SYSTEM.ADR("BOOL TreeView_SortChildrenCB(hwnd, psort, recurse)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Query                                                                       *)
     itemTreeView3 := ItemTreeView3Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETITEMRECT     "),SYSTEM.ADR("BOOL TreeView_GetItemRect(hwnd, hitem, prc, code)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETCOUNT        "),SYSTEM.ADR("UINT TreeView_GetCount(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETVISIBLECOUNT "),SYSTEM.ADR("UINT TreeView_GetVisibleCount(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_HITTEST         "),SYSTEM.ADR("HTREEITEM TreeView_HitTest(hwnd, lpht)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETISEARCHSTRING"),SYSTEM.ADR("BOOL TreeView_GetISearchString(hwndTV, lpsz)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Image List                                                                  *)
     itemTreeView4 := ItemTreeView4Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETIMAGELIST    "),SYSTEM.ADR("HIMAGELIST TreeView_GetImageList(hwnd, iImage)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SETIMAGELIST    "),SYSTEM.ADR("HIMAGELIST TreeView_SetImageList(hwnd, himl, iImage)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_CREATEDRAGIMAGE "),SYSTEM.ADR("HIMAGELIST TreeView_CreateDragImage(hwnd, hitem)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* In-Place Label Edit                                                         *)
     itemTreeView5 := ItemTreeView5Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_EDITLABEL       "),SYSTEM.ADR("hwnd TreeView_EditLabel(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETEDITCONTROL  "),SYSTEM.ADR("hwnd TreeView_GetEditControl(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_ENDEDITLABELNOW "),SYSTEM.ADR("BOOL TreeView_EndEditLabelNow(hwnd, fCancel)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Enumerate Items                                                             *)
     itemTreeView6 := ItemTreeView6Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Root"),SYSTEM.ADR("HTREEITEM TreeView_GetRoot(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Next Child"),SYSTEM.ADR("HTREEITEM TreeView_GetChild(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Next Sibling"),SYSTEM.ADR("HTREEITEM TreeView_GetNextSibling(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Previous Sibling "),SYSTEM.ADR("HTREEITEM TreeView_GetPrevSibling(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Parent "),SYSTEM.ADR("HTREEITEM TreeView_GetParent(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get First Visible "),SYSTEM.ADR("HTREEITEM TreeView_GetFirstVisible(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Next Visible"),SYSTEM.ADR("HTREEITEM TreeView_GetNextVisible(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Previous Visible"),SYSTEM.ADR("HTREEITEM TreeView_GetPrevVisible(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Selection"),SYSTEM.ADR("HTREEITEM TreeView_GetSelection(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Get Drop Highlight"),SYSTEM.ADR("HTREEITEM TreeView_GetDropHilight(hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_GETNEXTITEM"),SYSTEM.ADR("HTREEITEM TreeView_GetNextItem(hwnd, hitem, code)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(* Select Items                                                                *)
     itemTreeView7 := ItemTreeView7Array
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("Simple Select"),SYSTEM.ADR("HTREEITEM TreeView_SelectItem(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Drop Target Select"),SYSTEM.ADR("HTREEITEM TreeView_SelectDropTarget(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("Select and Scroll"),SYSTEM.ADR("HTREEITEM TreeView_SelectSetFirstVisible(hwnd, hitem)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("TVM_SELECTITEM"),SYSTEM.ADR("HTREEITEM TreeView_Select(hwnd, hitem, code)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

(*******************************************************************-          *)
(* ********** Up\Down Control Messages **********                              *)
(*******************************************************************-          *)
     itemUpDown := ItemUpDownArray
    {
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_GETACCEL"),SYSTEM.ADR("int   UpDown_GetAccel (hwnd, cAccels, paAccels)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_SETACCEL"),SYSTEM.ADR("BOOL  UpDown_SetAccel (hwnd, nAccels, aAccels)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_GETBASE "),SYSTEM.ADR("int   UpDown_GetBase (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_SETBASE "),SYSTEM.ADR("int   UpDown_SetBase (hwnd, nBase)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_GETBUDDY"),SYSTEM.ADR("hwnd  UpDown_GetBuddy (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_SETBUDDY"),SYSTEM.ADR("hwnd  UpDown_SetBuddy (hwnd, hwndBuddy)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_GETPOS  "),SYSTEM.ADR("DWORD UpDown_GetPos (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_SETPOS  "),SYSTEM.ADR("short UpDown_SetPos (hwnd, nPos)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_GETRANGE"),SYSTEM.ADR("DWORD UpDown_GetRange (hwnd)")},
    { TYPE_ITEM, NIL,SYSTEM.ADR("UDM_SETRANGE"),SYSTEM.ADR("void  UpDown_SetRange (hwnd, nUpper, nLower)")},
    { TYPE_ITEM, LASTITEM, NIL,NIL}
    };

     fldImageList := FldImageListArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Create\Destroy\Save Image List"), SYSTEM.ADR(itemImageList1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Image List"), SYSTEM.ADR(itemImageList2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Drag Images"), SYSTEM.ADR(itemImageList3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Draw Images"), SYSTEM.ADR(itemImageList4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Create Icon\Cursor from Image List"), SYSTEM.ADR(itemImageList5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Set \ Query Attributes"), SYSTEM.ADR(itemImageList6)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldListView := FldListViewArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Item List"), SYSTEM.ADR(itemListView1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Control Attributes"), SYSTEM.ADR(itemListView2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Drawing Attributes"), SYSTEM.ADR(itemListView3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Item Attributes"), SYSTEM.ADR(itemListView4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Column Attributes"), SYSTEM.ADR(itemListView5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Reorganize or Redraw List"), SYSTEM.ADR(itemListView6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Scrolling Attributes"), SYSTEM.ADR(itemListView7)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Search Item List"), SYSTEM.ADR(itemListView8)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Mouse \ Keyboard Input"), SYSTEM.ADR(itemListView9)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("In-Place Label Editing"), SYSTEM.ADR(itemListView0)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldPropSheet  := FldPropSheetArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Property Sheet"), SYSTEM.ADR(itemPropSheet1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Property Sheet Button State"), SYSTEM.ADR(itemPropSheet2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Wizard Button State"), SYSTEM.ADR(itemPropSheet3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("System Restart"), SYSTEM.ADR(itemPropSheet4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Query Window Handle"), SYSTEM.ADR(itemPropSheet5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Activate Specific Page"), SYSTEM.ADR(itemPropSheet6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Forward Message to All Property Pages"), SYSTEM.ADR(itemPropSheet7)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldRichEdit := FldRichEditArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Read\Write Text"),SYSTEM.ADR(itemRichEdit1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Search"),SYSTEM.ADR(itemRichEdit2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Text Selection"),SYSTEM.ADR(itemRichEdit3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Text Attributes"),SYSTEM.ADR(itemRichEdit4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Scrolling"),SYSTEM.ADR(itemRichEdit5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Text Query"),SYSTEM.ADR(itemRichEdit6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Edit Menu Features"),SYSTEM.ADR(itemRichEdit7)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Window state"),SYSTEM.ADR(itemRichEdit8)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Set \ Get Word Break Proc"),SYSTEM.ADR(itemRichEdit9)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Printing"),SYSTEM.ADR(itemRichEdit10)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Formatting"),SYSTEM.ADR(itemRichEdit11)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Event Notification Messages"),SYSTEM.ADR(itemRichEdit12)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("OLE Support"),SYSTEM.ADR(itemRichEdit13)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Stream Support"),SYSTEM.ADR(itemRichEdit14)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldTab := FldTabArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Initialization"),SYSTEM.ADR(itemTab1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Query"),SYSTEM.ADR(itemTab2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Tab List"),SYSTEM.ADR(itemTab3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Image List and Tool Tips"),SYSTEM.ADR(itemTab4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Selection and Focus"),SYSTEM.ADR(itemTab5)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldToolBar := FldToolBarArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Initialization"),SYSTEM.ADR(itemToolBar1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Handle WM_SIZE Message"),SYSTEM.ADR(itemToolBar2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Button List"),SYSTEM.ADR(itemToolBar3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Button State"),SYSTEM.ADR(itemToolBar4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Button Attributes"),SYSTEM.ADR(itemToolBar5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Tool Bar Attributes"),SYSTEM.ADR(itemToolBar6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Display Customize Dialog Box"),SYSTEM.ADR(itemToolBar7)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Tool Tip Support"),SYSTEM.ADR(itemToolBar8)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Read \ Write Registry Data"),SYSTEM.ADR(itemToolBar9)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldToolTip := FldToolTipArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify Tool List"), SYSTEM.ADR(itemToolTip1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Query"), SYSTEM.ADR(itemToolTip2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Set Tooltip Window State"), SYSTEM.ADR(itemToolTip3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Pass Mouse Message"), SYSTEM.ADR(itemToolTip4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Support Subclassing of Tooltips"), SYSTEM.ADR(itemToolTip5)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldTrackBar := FldTrackBarArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Trackbar Ticks"), SYSTEM.ADR(itemTrackBar1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Line and Page Increments"), SYSTEM.ADR(itemTrackBar2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Slider Position"), SYSTEM.ADR(itemTrackBar3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Slider Range"), SYSTEM.ADR(itemTrackBar4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Trackbar Selection"), SYSTEM.ADR(itemTrackBar5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Trackbar Appearance"), SYSTEM.ADR(itemTrackBar6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Slider (Thumb) Attributes"), SYSTEM.ADR(itemTrackBar7)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldTreeView := FldTreeViewArray
    {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Modify List"), SYSTEM.ADR(itemTreeView1)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Item Layout, Display, and Order"), SYSTEM.ADR(itemTreeView2)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Query"), SYSTEM.ADR(itemTreeView3)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Image List"), SYSTEM.ADR(itemTreeView4)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("In-Place Label Edit"), SYSTEM.ADR(itemTreeView5)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Enumerate Items"), SYSTEM.ADR(itemTreeView6)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Select Items"), SYSTEM.ADR(itemTreeView7)},
    { TYPE_FOLDER, LASTITEM, NIL,NIL}
    };
     fldRoot := FldRootArray
   {
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Animation Controls"), SYSTEM.ADR(itemAnimate[0])},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Header Controls"),SYSTEM.ADR(itemHeader)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Hot-Key Controls"), SYSTEM.ADR(itemHotKey)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Image Lists"), SYSTEM.ADR(fldImageList)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("List View Controls"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldListView))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Progress Bars"), SYSTEM.ADR(itemProgress)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Property Sheets"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldPropSheet))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Rich Edit Controls"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldRichEdit))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Status Bar Controls"), SYSTEM.ADR(itemStatus)},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Tab Controls"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldTab))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Toolbars"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldToolBar))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Tooltip Controls"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldToolTip))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Trackbars"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldTrackBar))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Tree View Controls"), SYSTEM.CAST(LPITEM,SYSTEM.ADR(fldTreeView))},
    { TYPE_FOLDER, NIL,SYSTEM.ADR("Up-Down Controls"), SYSTEM.ADR(itemUpDown)}
    };

END TreeData.
