<*/NOWARN:F*>
IMPLEMENTATION MODULE TreeView;
(*----------------------------------------------
   TREEVIEW.C      --- Functions to support tree view
                   (c) Paul Yao, 1996
   TreeView.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler 1997
  ----------------------------------------------*)
IMPORT resource;
IMPORT WIN32;
IMPORT COMMCTRL;
IMPORT MemUtils;
IMPORT SYSTEM;
IMPORT Str;
IMPORT WINX;
IMPORT TreeData;

(*-------------------------------------------------------------------          *)
PROCEDURE tv_BuildRootFolder (hwndLV : WIN32.HWND) : BOOLEAN;
VAR
  i     : INTEGER;
  tvis  : COMMCTRL.TV_INSERTSTRUCT;
BEGIN

     (* Initialize list view item structure                                    *)
     MemUtils.FillMemBYTE (tvis, SIZE (COMMCTRL.TV_INSERTSTRUCT),0);
     tvis.hParent := NIL;
     tvis.hInsertAfter := COMMCTRL.TVI_LAST;
     tvis.item.mask := COMMCTRL.TVIF_TEXT BOR COMMCTRL.TVIF_PARAM BOR COMMCTRL.TVIF_CHILDREN BOR
                      COMMCTRL.TVIF_IMAGE BOR COMMCTRL.TVIF_SELECTEDIMAGE;
     tvis.item.iImage := 0;
     tvis.item.iSelectedImage := 0;
     tvis.item.cchTextMax := 256;

     FOR i := 0 TO TreeData.cRootFolders-1 DO
          tvis.item.pszText := TreeData.fldRoot[i].pName;
          tvis.item.lParam := SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(TreeData.fldRoot[i]));
          tvis.item.cChildren := 1;
          TreeData.fldRoot[i].hItem := COMMCTRL.TreeView_InsertItem (hwndLV, tvis);
     END;

     RETURN TRUE;
END tv_BuildRootFolder;

(*******************************************************************-          *)
PROCEDURE tv_ExpandChild (hwndLV : WIN32.HWND; lParam : WIN32.LPARAM);
VAR
  pFolder  :  TreeData.LPFOLDER;
  pItem    :  TreeData.LPITEM;
  pFldr    :  TreeData.LPFOLDER;
  tvis     :  COMMCTRL.TV_INSERTSTRUCT;
BEGIN
     pFolder := SYSTEM.CAST(TreeData.LPFOLDER,lParam);
     pItem := pFolder^.piChild;

     (* Initialize list view item structure                                    *)
     MemUtils.FillMemBYTE (tvis, SIZE (COMMCTRL.TV_INSERTSTRUCT),0);
     tvis.hParent := pFolder^.hItem;
     tvis.hInsertAfter := COMMCTRL.TVI_LAST;
     tvis.item.mask := COMMCTRL.TVIF_TEXT BOR COMMCTRL.TVIF_PARAM BOR
                      COMMCTRL.TVIF_IMAGE BOR COMMCTRL.TVIF_SELECTEDIMAGE;
     tvis.item.iImage := 1;
     tvis.item.iSelectedImage := 1;
     tvis.item.cchTextMax := 256;

     IF (pItem^.hItem = NIL) THEN
          IF (pItem^.nType = TreeData.TYPE_ITEM) THEN        (* Add macro items             *)
               LOOP     
                    tvis.item.pszText :=  pItem^.pName;
                    tvis.item.lParam := SYSTEM.CAST(WIN32.LPARAM,pItem);
		    (*Error in Petzold-Text ???    
		    tvis.item.lParam := SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(pItem));
		    *)
                    pItem^.hItem := COMMCTRL.TreeView_InsertItem (hwndLV, tvis);
		    pItem := SYSTEM.ADDADR(pItem,SIZE(TreeData.ITEM));
                    IF(pItem^.hItem = TreeData.LASTITEM) THEN
                      EXIT;
                    END;
               END;
          ELSE (* (pItem^.nType = TYPE_FOLDER)  Add folder items            *)
               pFldr := SYSTEM.CAST(TreeData.LPFOLDER,pFolder^.piChild);
               tvis.item.mask := COMMCTRL.TVIF_TEXT BOR COMMCTRL.TVIF_PARAM BOR COMMCTRL.TVIF_CHILDREN BOR
                                COMMCTRL.TVIF_IMAGE BOR COMMCTRL.TVIF_SELECTEDIMAGE;
               tvis.item.iImage := 0;
               tvis.item.iSelectedImage := 0;
               LOOP 
                    tvis.item.pszText := pFldr^.pName;
                    tvis.item.lParam := SYSTEM.CAST(WIN32.LPARAM,pFldr);
		    (* Fehler in C-Text ???      
		    tvis.item.lParam := SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(pFldr));
		    *)
                    tvis.item.cChildren := 1;
                    
                    pFldr^.hItem := COMMCTRL.TreeView_InsertItem (hwndLV, tvis);
		    pFldr := SYSTEM.ADDADR(pFldr,SIZE(TreeData.FOLDER));
                    IF(pFldr^.hItem = TreeData.LASTITEM) THEN
                      EXIT;
                    END;
               END;
          END;
      END;
END tv_ExpandChild;

(*******************************************************************-          *)
PROCEDURE tv_FetchMacro (lParam : WIN32.LPARAM; hwndCtrl : WIN32.HWND): BOOLEAN;
VAR
   pItem  : TreeData.LPITEM;
BEGIN
     pItem := SYSTEM.CAST(TreeData.LPITEM,lParam);

     IF (pItem^.nType = TreeData.TYPE_FOLDER) THEN
          RETURN FALSE;
     END;
     WINX.Edit_SetText (hwndCtrl, pItem^.pMacro^);
     RETURN TRUE;
END tv_FetchMacro;
END TreeView.
