<*/NOWARN:F*>
MODULE Gadgets;
%IF WIN32 %THEN
    <*/Resource:GADGETS.RES*>
%ELSE
%END
(*---------------------------------------
   GADGETS.C       --- Gadgets for a frame window.
                   (c) Paul Yao,      1996
   Gadgets.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  ---------------------------------------*)

IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT WINX;
IMPORT SYSTEM;
IMPORT COMMCTRL;
IMPORT comcthlp;
IMPORT h2d_gadgets;
IMPORT StatBar;
IMPORT ToolBar;
IMPORT ToolTip;
IMPORT NotifDef;


CONST
  szAppName  =  "Gadgets: Translation to Stony Brook M2";
VAR
   hwnd            :  WIN32.HWND;
   bIgnoreSize     :  BOOLEAN = FALSE;
   hwndClient      :  WIN32.HWND = NIL;
   hwndToolBar     :  WIN32.HWND = NIL;
   idCtrl          :  INTEGER;
   hwndNotify      :  WIN32.HWND = NIL;
   msg  :     WINUSER.MSG;
VAR  crBack  :  WIN32.COLORREF;
     hbr     :  WIN32.HBRUSH;


(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  lpstr  :  WIN32.LPSTR;
  wc     :  WINUSER.WNDCLASSEX;
  rc     :  INTEGER;
BEGIN
  ToolBar.hInst    := WINX.Instance;
  wc.cbSize        := SIZE(wc);
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hInstance     := WINX.Instance;
  wc.lpfnWndProc   := WndProc;
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  lpstr            := WINUSER.MAKEINTRESOURCE (SYSTEM.CAST(INTEGER,WINUSER.IDI_APPLICATION));
  wc.hIcon         := WINUSER.LoadIcon (wc.hInstance, lpstr^);
  wc.lpszMenuName  := SYSTEM.ADR("MAIN");
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINUSER.COLOR_WINDOW+1);
  wc.style         := 0;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hIconSm       := WINUSER.LoadIcon (wc.hInstance, lpstr^);
  rc := WINUSER.RegisterClassEx(wc);

  wc.lpszClassName := SYSTEM.ADR("ClientWndProc");
  wc.hInstance     := WINX.Instance;
  wc.lpfnWndProc   := ClientWndProc;
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.lpszMenuName  := NIL;
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINUSER.COLOR_WINDOW+1);
  wc.style         := 0;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hIconSm       := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  RETURN WINUSER.RegisterClassEx(wc)#0;

END InitApplication;
(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindowEx(0h,szAppName,
                        szAppName,
                        WINUSER.WS_OVERLAPPEDWINDOW,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        WINX.Instance,
                        NIL);

  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  COMMCTRL.InitCommonControls ();
  RETURN TRUE;
END InitMainWindow;

(*-------------------------------------------------------------------*)
PROCEDURE MenuCheckMark (hmenu : WIN32.HMENU;
                         id    : INTEGER;
                         bCheck: BOOLEAN);
VAR
  iState : INTEGER;
BEGIN
     IF(bCheck) THEN
        iState := WINUSER.MF_CHECKED;
     ELSE
        iState := WINUSER.MF_UNCHECKED;
     END;
     WINUSER.CheckMenuItem (hmenu, id, iState);
END MenuCheckMark;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
          mMsg        : WIN32.UINT;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  pnmh : WINUSER.LPNMHDR;
  r    : WIN32.RECT;
  ach  : ARRAY[0..80] OF CHAR;
  bCheck : BOOLEAN;
  hmenu  : WIN32.HMENU;
  lpttt : COMMCTRL.LPTOOLTIPTEXT;
  cx:       INTEGER;
  cy:       INTEGER;
  cyStatus: INTEGER;
  cyTB:     INTEGER;
  x, y:     INTEGER;
  dwStyle:  WIN32.DWORD;
  rWindow:  WIN32.RECT;
BEGIN
     CASE (mMsg) OF
          | WINUSER.WM_CREATE :
               (* Create toolbar (source resides in toolbar.c)*)
               hwndToolBar := ToolBar.InitToolBar (hwnd);

               (* Create status bar (source resides in statbar.c).*)
               StatBar.hwndStatusBar := StatBar.InitStatusBar(hwnd);

               (* Create client window (contains notify list).*)
               hwndClient := WINUSER.CreateWindowEx (WINUSER.WS_EX_CLIENTEDGE,
                                 "ClientWndProc", "",
                                 WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE, 0, 0, 0, 0,
                                 hwnd, SYSTEM.CAST(WIN32.HMENU, 4), ToolBar.hInst, NIL);

               RETURN 0;

          | WINUSER.WM_COMMAND :
               (* Toolbar button commands.*)
               IF (WINUSER.LOWORD(wParam) < 300) THEN
                    WINUSER.wsprintf (ach, "Got Command (%d)", wParam);
                    WINUSER.MessageBox (hwnd, ach, szAppName, WINUSER.MB_OK);
               ELSE

                 (* Menu item commands*)
                 CASE (WINUSER.LOWORD(wParam)) OF
                      (* Toolbar settings*)
                      | h2d_gadgets.IDM_STRINGS :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_LARGEICONS :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_SMALLICONS :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_NODIVIDER :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_WRAPABLE :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TOP :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_BOTTOM :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_NOMOVEY :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_NOPARENTALIGN :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_NORESIZE :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_ADJUSTABLE :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_ALTDRAG :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TOOLTIPS :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_COMBOBOX :
                           WINUSER.DestroyWindow (hwndToolBar);
                           hwndToolBar := ToolBar.RebuildToolBar (hwnd,
                                                         WINUSER.LOWORD(wParam));

                      (* Toolbar messages*)
                      | h2d_gadgets.IDM_TB_CHECK :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_ENABLE :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_HIDE :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_INDETERMINATE :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_PRESS :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_BUTTONCOUNT :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_GETROWS :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_TB_CUSTOMIZE :
                           ToolBar.ToolBarMessage (hwndToolBar, WINUSER.LOWORD(wParam));

                      (* Status bar settings*)
                      | h2d_gadgets.IDM_STAT_SIZEGRIP :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_STAT_TOP :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_STAT_BOTTOM :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_STAT_NOMOVEY :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_STAT_NOPARENTALIGN :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_STAT_NORESIZE :
                           WINUSER.DestroyWindow (StatBar.hwndStatusBar);
                           StatBar.hwndStatusBar := StatBar.RebuildStatusBar (hwnd,WINUSER.LOWORD(wParam));

                      (* Status bar messages*)
                      | h2d_gadgets.IDM_ST_GETBORDERS :
                           StatBar.StatusBarMessage (StatBar.hwndStatusBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_ST_GETPARTS :
                           StatBar.StatusBarMessage (StatBar.hwndStatusBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_ST_SETTEXT :
                           StatBar.StatusBarMessage (StatBar.hwndStatusBar, WINUSER.LOWORD(wParam));
                      | h2d_gadgets.IDM_ST_SIMPLE :
                           StatBar.StatusBarMessage (StatBar.hwndStatusBar, WINUSER.LOWORD(wParam));

                      (* Toggle display of toolbar*)
                      | h2d_gadgets.IDM_VIEW_TOOLBAR :
                           IF (hwndToolBar=SYSTEM.CAST(WIN32.HWND,1)) AND (WINUSER.IsWindowVisible (hwndToolBar)=TRUE) THEN
                                WINUSER.ShowWindow (hwndToolBar, WINUSER.SW_HIDE);
                           ELSE
                                WINUSER.ShowWindow (hwndToolBar, WINUSER.SW_SHOW);
                           END;

                           (* Resize other windows.*)
                           WINUSER.GetClientRect (hwnd, r);
                           WINUSER.PostMessage (hwnd, WINUSER.WM_SIZE, 0,
                                        WINUSER.MAKELPARAM (r.right, r.bottom));


                      (* Toggle display of status bar*)
                      | h2d_gadgets.IDM_VIEW_STATUS :
                           IF (StatBar.hwndStatusBar=SYSTEM.CAST(WIN32.HWND,1)) AND WINUSER.IsWindowVisible (StatBar.hwndStatusBar) THEN
                                WINUSER.ShowWindow (StatBar.hwndStatusBar, WINUSER.SW_HIDE);
                           ELSE
                                WINUSER.ShowWindow (StatBar.hwndStatusBar, WINUSER.SW_SHOW);
                           END;

                           (* Resize other windows.*)
                           WINUSER.GetClientRect (hwnd, r);
                           WINUSER.PostMessage (hwnd, WINUSER.WM_SIZE, 0,
                                        WINUSER.MAKELPARAM (r.right, r.bottom));


                      (* Toggle display of notifications window.*)
                      | h2d_gadgets.IDM_VIEW_NOTIFICATIONS :
                           hwndNotify := NotifDef.ViewNotificationsToggle (hwndClient);

                      (* Toggle ignore WINUSER.WM_SIZE to show auto-size\auto-move*)
                      | h2d_gadgets.IDM_IGNORESIZE :
                           bIgnoreSize := NOT bIgnoreSize;
                           IF (bIgnoreSize) THEN
                                WINUSER.ShowWindow (hwndClient, WINUSER.SW_HIDE);
                           ELSE
                                WINUSER.ShowWindow (hwndClient, WINUSER.SW_SHOW);
                                WINUSER.GetClientRect (hwnd, r);
                                WINUSER.PostMessage (hwnd, WINUSER.WM_SIZE, 0,
                                             WINUSER.MAKELPARAM (r.right, r.bottom));
                           END;
                      | h2d_gadgets.IDM_STAT_IGNORESIZE :
                           bIgnoreSize := NOT bIgnoreSize;
                           IF (bIgnoreSize) THEN
                                WINUSER.ShowWindow (hwndClient, WINUSER.SW_HIDE);
                           ELSE
                                WINUSER.ShowWindow (hwndClient, WINUSER.SW_SHOW);
                                WINUSER.GetClientRect (hwnd, r);
                                WINUSER.PostMessage (hwnd, WINUSER.WM_SIZE, 0,
                                             WINUSER.MAKELPARAM (r.right, r.bottom));
                           END;

                      (* Clear contents of notification window*)
                      | h2d_gadgets.IDM_NOTIFICATIONS_CLEAR :
                           NotifDef.ClearNotificationList ();

                   RETURN 0;
                 ELSE
		   RETURN 0;
                 END;
               END;
          | WINUSER.WM_INITMENU :
               hmenu := SYSTEM.CAST(WIN32.HMENU,wParam);

               MenuCheckMark (hmenu, h2d_gadgets.IDM_IGNORESIZE, bIgnoreSize);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_IGNORESIZE, bIgnoreSize);

               (* Toolbar menu items.*)
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STRINGS, ToolBar.bStrings);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_LARGEICONS, ToolBar.bLargeIcons);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_SMALLICONS, NOT ToolBar.bLargeIcons);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_COMBOBOX, ToolBar.bComboBox);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.CCS_NODIVIDER=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_NODIVIDER, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.TBSTYLE_WRAPABLE=1);
               MenuCheckMark(hmenu, h2d_gadgets.IDM_WRAPABLE, bCheck);

               bCheck := ((ToolBar.dwToolBarStyles BAND 3) = COMMCTRL.CCS_TOP);
               MenuCheckMark(hmenu, h2d_gadgets.IDM_TOP, bCheck);

               bCheck := ((ToolBar.dwToolBarStyles BAND 3) = COMMCTRL.CCS_BOTTOM);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_BOTTOM, bCheck);

               bCheck := ((ToolBar.dwToolBarStyles BAND 3) = COMMCTRL.CCS_NOMOVEY);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_NOMOVEY, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.CCS_NOPARENTALIGN=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_NOPARENTALIGN, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.CCS_NORESIZE=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_NORESIZE, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.CCS_ADJUSTABLE=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_ADJUSTABLE, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.TBSTYLE_ALTDRAG=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_ALTDRAG, bCheck);

               bCheck := (ToolBar.dwToolBarStyles BAND COMMCTRL.TBSTYLE_TOOLTIPS=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_TOOLTIPS, bCheck);

               (* Status bar menu items.*)
               bCheck := (StatBar.dwStatusBarStyles BAND COMMCTRL.SBARS_SIZEGRIP=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_SIZEGRIP, bCheck);

               bCheck := ((StatBar.dwStatusBarStyles BAND 3) = COMMCTRL.CCS_TOP);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_TOP, bCheck);

               bCheck := ((StatBar.dwStatusBarStyles BAND 3) = COMMCTRL.CCS_BOTTOM);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_BOTTOM, bCheck);

               bCheck := ((StatBar.dwStatusBarStyles BAND 3) = COMMCTRL.CCS_NOMOVEY);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_NOMOVEY, bCheck);

               bCheck := (StatBar.dwStatusBarStyles BAND COMMCTRL.CCS_NOPARENTALIGN=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_NOPARENTALIGN, bCheck);

               bCheck := (StatBar.dwStatusBarStyles BAND COMMCTRL.CCS_NORESIZE=1);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_STAT_NORESIZE, bCheck);

               (* View menu items.*)
               bCheck := WINUSER.IsWindowVisible (hwndToolBar);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_VIEW_TOOLBAR, bCheck);

               bCheck := WINUSER.IsWindowVisible (StatBar.hwndStatusBar);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_VIEW_STATUS, bCheck);

               bCheck := (hwndNotify # NIL);
               MenuCheckMark (hmenu, h2d_gadgets.IDM_VIEW_NOTIFICATIONS, bCheck);
               RETURN 0;

          | WINUSER.WM_MENUSELECT :
               RETURN StatBar.StatusBar_MenuSelect (hwnd, wParam, lParam);

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;

          | WINUSER.WM_NOTIFY :
               pnmh := SYSTEM.CAST(WINUSER.LPNMHDR,lParam);
               idCtrl := SYSTEM.CAST(INTEGER,wParam);

               (* Display notification details in notify window *)
               NotifDef.DisplayNotificationDetails (wParam, lParam);

               (* Toolbar notifications *)
               IF (SYSTEM.CAST(INTEGER,pnmh^.code) >= COMMCTRL.TBN_LAST) AND
                  (SYSTEM.CAST(INTEGER,pnmh^.code) <= COMMCTRL.TBN_FIRST) THEN
                    RETURN ToolBar.ToolBarNotify (hwnd, wParam, lParam);
               END;
               (* Fetch tooltip text *)
               IF (pnmh^.code = COMMCTRL.TTN_NEEDTEXT) THEN
                    lpttt := SYSTEM.CAST(COMMCTRL.LPTOOLTIPTEXT,lParam);
                    ToolTip.CopyToolTipText (lpttt);
               END;

               RETURN 0;

          | WINUSER.WM_SIZE :
               cx := WINUSER.LOWORD(lParam);
               cy := WINUSER.HIWORD(lParam);

               (* Ignore size message to allow auto-move and auto-size *)
               (* features to be more clearly seen.*)
               IF (bIgnoreSize) THEN
                    RETURN 0;
               END;
               (* Adjust toolbar size.*)
               IF (WINUSER.IsWindowVisible (hwndToolBar)) THEN
                    dwStyle := WINUSER.GetWindowLong (hwndToolBar, WINUSER.GWL_STYLE);
                    IF (dwStyle BAND COMMCTRL.CCS_NORESIZE=1) THEN
                         WINUSER.MoveWindow (hwndToolBar,
                                     0, 0, cx, ToolBar.cyToolBar, FALSE);
                    ELSE
                         comcthlp.ToolBar_AutoSize (hwndToolBar);
                    END;
                    WINUSER.InvalidateRect (hwndToolBar, WINX.NIL_RECT, TRUE);
                    WINUSER.GetWindowRect (hwndToolBar, rWindow);
                    WINUSER.ScreenToClient (hwnd, SYSTEM.CAST(WIN32.POINT, rWindow.left));
                    WINUSER.ScreenToClient (hwnd, SYSTEM.CAST(WIN32.POINT, rWindow.right));
                    cyTB := rWindow.bottom - rWindow.top;
               ELSE
                    cyTB := 0;
               END;

               (* Adjust status bar size.*)
               IF (WINUSER.IsWindowVisible (StatBar.hwndStatusBar)) THEN
                    WINUSER.GetWindowRect (StatBar.hwndStatusBar, rWindow);
                    cyStatus := rWindow.bottom - rWindow.top;
                    WINUSER.MoveWindow (StatBar.hwndStatusBar, 0, cy - cyStatus,
                                              cx, cyStatus, TRUE);
               ELSE
                    cyStatus := 0;
               END;

               (* Adjust client window size.*)
               x := 0;
               y := cyTB;
               cy := cy - (cyStatus + cyTB);
               WINUSER.MoveWindow (hwndClient, x, y, cx, cy, TRUE);
               RETURN 0;

      ELSE
               RETURN (WINUSER.DefWindowProc (hwnd, mMsg, wParam, lParam));
      END;
END WndProc;
<*/POP*>

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE ClientWndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
          mMsg        : WIN32.UINT;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
    cx,cy      : INTEGER;
BEGIN
     CASE (mMsg) OF
          | WINUSER.WM_CREATE :
               hwndNotify := NotifDef.ViewNotificationsToggle (hwnd);
               crBack := WINUSER.GetSysColor (WINUSER.COLOR_APPWORKSPACE);
               hbr := WINGDI.CreateSolidBrush (crBack);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hbr));
               RETURN 0;

          | WINUSER.WM_CTLCOLORLISTBOX :
               WINUSER.DefWindowProc (hwnd, mMsg, wParam, lParam);
               WINGDI.SetBkColor (SYSTEM.CAST(WIN32.HDC,wParam), crBack);
               WINGDI.SetBkMode (SYSTEM.CAST(WIN32.HDC,wParam), WINGDI.TRANSPARENT);
               RETURN SYSTEM.CAST(WIN32.LRESULT, SYSTEM.CAST(WIN32.HBRUSH,hbr));

          | WINUSER.WM_SIZE :
               hwndNotify := WINUSER.GetWindow (hwnd, WINUSER.GW_CHILD);
               cx := WINUSER.LOWORD(lParam);
               cy := WINUSER.HIWORD(lParam);

               (* Ignore if notification window is absent.*)
               IF (hwndNotify # NIL) THEN
                    WINUSER.MoveWindow (hwndNotify, 0, 0, cx, cy, TRUE);
               END;

               RETURN 0;

          ELSE
               RETURN (WINUSER.DefWindowProc (hwnd, mMsg, wParam, lParam));
          END;
END ClientWndProc;
<*/POP*>
BEGIN
  StatBar.hwndStatusBar := NIL;
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Gadgets.
