<*/NOWARN:F*>
IMPLEMENTATION MODULE StatBar;
(*-------------------------------------------
   STATBAR.C       --- Status bar helper functions.
                   (c) Paul Yao,      1996
   StatBar.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  -------------------------------------------*)
IMPORT comcthlp;
IMPORT COMMCTRL;
IMPORT WIN32;
IMPORT WINUSER;
IMPORT h2d_gadgets;
IMPORT SYSTEM;
IMPORT WINX;
IMPORT ToolBar;
IMPORT ASCII;

TYPE
  POPUPSTRING = RECORD
                  hMenu     :WIN32.HMENU;
                  uiString  :WIN32.UINT;
                END;

CONST MAX_MENUS=5;

VAR
   popstr :  ARRAY[0..MAX_MENUS-1] OF POPUPSTRING;


VAR bSimple : BOOLEAN = TRUE;


(*******************************************************************-          *)
PROCEDURE InitStatusBar (hwndParent : WIN32.HWND) : WIN32.HWND;
VAR
  hwndSB : WIN32.HWND;
  hMenu  : WIN32.HMENU;
  hMenuTB : WIN32.HMENU;
  hMenuSB : WIN32.HMENU;
BEGIN
     (* Initialize values for WM_MENUSELECT message handling               *)
     hMenu := WINUSER.GetMenu (hwndParent);
     hMenuTB := WINUSER.GetSubMenu (hMenu, 2);
     hMenuSB := WINUSER.GetSubMenu (hMenu, 3);
     popstr[0].hMenu    := NIL;
     popstr[0].uiString := 0;
     popstr[1].hMenu    := hMenu;
     popstr[1].uiString := h2d_gadgets.IDS_MAIN_MENU;
     popstr[2].hMenu    := hMenuTB;
     popstr[2].uiString := h2d_gadgets.IDS_TOOLBAR_MENU;
     popstr[3].hMenu    := hMenuSB;
     popstr[3].uiString := h2d_gadgets.IDS_STATUSBAR_MENU;
     popstr[4].hMenu    := NIL;
     popstr[4].uiString := 0;

     hwndSB := COMMCTRL.CreateStatusWindow (dwStatusBarStyles,
                                  "Ready",
                                  hwndParent,
                                  2);
     RETURN hwndSB;
END InitStatusBar;

(*******************************************************************-          *)
PROCEDURE FlipStyleFlag (dwStyle : WIN32.LPDWORD; flag : WIN32.DWORD);
BEGIN
     IF (dwStyle^ BAND flag#0) THEN  (* Flag on -- turn off                              *)
          dwStyle^  := dwStyle^ BAND BNOT flag;
     ELSE                  (* Flag off -- turn on                              *)
          dwStyle^ := dwStyle^ BOR flag;
     END;
END FlipStyleFlag;
(*******************************************************************-          *)
PROCEDURE RebuildStatusBar (hwndParent : WIN32.HWND; wFlag  : WIN32.WORD) : WIN32.HWND;
VAR
     hwndSB : WIN32.HWND;
     r      : WIN32.RECT;
BEGIN

     CASE (wFlag)                                                                                                                                                                                      OF
          | h2d_gadgets.IDM_STAT_SIZEGRIP :
               FlipStyleFlag (SYSTEM.ADR(dwStatusBarStyles), COMMCTRL.SBARS_SIZEGRIP);

          | h2d_gadgets.IDM_STAT_TOP :
               dwStatusBarStyles := dwStatusBarStyles BAND 0FFFFFFFCh;
               dwStatusBarStyles := dwStatusBarStyles BOR COMMCTRL.CCS_TOP;

          | h2d_gadgets.IDM_STAT_BOTTOM :
               dwStatusBarStyles := dwStatusBarStyles BAND 0FFFFFFFCh;
               dwStatusBarStyles := dwStatusBarStyles BOR COMMCTRL.CCS_BOTTOM;

          | h2d_gadgets.IDM_STAT_NOMOVEY :
               dwStatusBarStyles := dwStatusBarStyles BAND 0FFFFFFFCh;
               dwStatusBarStyles := dwStatusBarStyles BOR COMMCTRL.CCS_NOMOVEY;

          | h2d_gadgets.IDM_STAT_NOPARENTALIGN :
               FlipStyleFlag (SYSTEM.ADR(dwStatusBarStyles), COMMCTRL.CCS_NOPARENTALIGN);

          | h2d_gadgets.IDM_STAT_NORESIZE :
               FlipStyleFlag (SYSTEM.ADR(dwStatusBarStyles), COMMCTRL.CCS_NORESIZE);
     ELSE
     END;

     hwndSB := InitStatusBar (hwndParent);

     (* Post parent a WM_SIZE message to resize children                       *)
     WINUSER.GetClientRect (hwndParent, r);
     WINUSER.PostMessage (hwndParent, WINUSER.WM_SIZE, 0,
                  WINUSER.MAKELPARAM (r.right, r.bottom));

     RETURN hwndSB;
 END RebuildStatusBar;


(*******************************************************************-          *)
PROCEDURE StatusBarMessage (hwndSB : WIN32.HWND; wMsg : WIN32.WORD);
VAR
  ach   :  ARRAY[0..179] OF CHAR;
  och   :  ARRAY[0..179] OF CHAR;
  aiBorders : ARRAY[0..2] OF INTEGER;
  nParts    : INTEGER;
BEGIN
     CASE (wMsg) OF
           | h2d_gadgets.IDM_ST_GETBORDERS :
               comcthlp.Status_GetBorders (hwndSB, aiBorders);
               och :=  "Horiz Width = %d/n"+ASCII.lf+
	                              "Vert Width = %d/n"+ASCII.lf+
				      "Separator Width = %d";
	       WINUSER.wsprintf (ach,och,
                         aiBorders[0], aiBorders[1],
                         aiBorders[2]);
               WINUSER.MessageBox (WINUSER.GetParent (hwndSB), ach,
                           "COMMCTRL.SB_GETBORDERS", WINUSER.MB_OK);

          |  h2d_gadgets.IDM_ST_GETPARTS :
               nParts := comcthlp.Status_GetParts (hwndSB, 0, 0);
               WINUSER.wsprintf (ach, "Part Count = %d", nParts);
               WINUSER.MessageBox (WINUSER.GetParent (hwndSB), ach,
                           "COMMCTRL.SB_GETPARTS", WINUSER.MB_OK);

          |  h2d_gadgets.IDM_ST_SETTEXT :
               comcthlp.Status_SetText (hwndSB, 0, 0,
                               "COMMCTRL.SB_SETTEXT Message Sent");

          |  h2d_gadgets.IDM_ST_SIMPLE :
               comcthlp.Status_Simple (hwndSB, VAL(WIN32.WORD,bSimple));
               bSimple := NOT bSimple;
     ELSE
     END;
END StatusBarMessage;
(*******************************************************************-          *)
PROCEDURE StatusBar_MenuSelect (hwnd : WIN32.HWND; wParam : WIN32.WPARAM; lParam : WIN32.LPARAM) : WIN32.LRESULT;
VAR
  fuFlags  : WIN32.UINT;
  hMainMenu : WIN32.HMENU = NIL;
  iMenu     : INTEGER = 0;
BEGIN
     fuFlags := VAL(WIN32.UINT, WINUSER.HIWORD (wParam));

     (* Handle non-system popup menu descriptions.                             *)
     IF ((fuFlags BAND WINUSER.MF_POPUP=1)  AND
         ((fuFlags BAND WINUSER.MF_SYSMENU)=0)) THEN
          iMenu := 1;
          LOOP
               IF ((SYSTEM.CAST(WIN32.HMENU,lParam) = popstr[iMenu].hMenu)) THEN
                    hMainMenu := SYSTEM.CAST(WIN32.HMENU,lParam);
                    EXIT;
               END;
               INC(iMenu);
               IF(iMenu>=MAX_MENUS) THEN
                    EXIT;
               END;
          END;
     END;
     (* Display helpful text in status bar                                     *)
     COMMCTRL.MenuHelp (WINUSER.WM_MENUSELECT, wParam, lParam, hMainMenu, ToolBar.hInst,
               hwndStatusBar, SYSTEM.CAST(WIN32.UINT,popstr[iMenu]));


     RETURN 0;
END StatusBar_MenuSelect;
END StatBar.
