<*/NOWARN:F*>
IMPLEMENTATION MODULE ToolBar;
(*---------------------------------------
   TOOLBAR.C       --- Gadgets for a frame window.
                   (c) Paul Yao,      1996
   ToolBar.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  ---------------------------------------*)
IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT WINX;
IMPORT SYSTEM;
IMPORT comcthlp;
IMPORT h2d_gadgets;
IMPORT ToolTip;
IMPORT COMMCTRL;
IMPORT Lib;
IMPORT Str;

(*++++******************************************************************)
PROCEDURE Maximum(a,b : CARDINAL) : CARDINAL;
(***********************************************************************)

VAR max : CARDINAL;

BEGIN
  IF (a <= b) THEN
     max := b
  ELSE
     max := a
  END;
  RETURN max;

END Maximum;

(*++++*****************************************************************)
PROCEDURE GetString (iString : INTEGER) : WIN32.LPSTR;
(**********************************************************************)
VAR
  i,cb  :  INTEGER;
  pString : WIN32.LPTSTR;
BEGIN
     (* Cycle through to requested string *)
     pString^ := szTbStrings;
     FOR i := 0 TO iString-1 DO
          cb := LENGTH(pString^);
          pString := SYSTEM.ADDADR(pString,cb + 1);
     END;

     RETURN pString;
END GetString;

(*++++*****************************************************************)
PROCEDURE ToolBarNotify (hwnd        : WIN32.HWND;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIN32.LRESULT;
(**********************************************************************)
VAR
  pnhm   :  WINUSER.LPNMHDR;
  idCtrl :  INTEGER;
  ptbn   :  COMMCTRL.LPTBNOTIFY;
  iButton:  INTEGER;
  lpstr  :  WIN32.LPSTR;
BEGIN
     pnhm := SYSTEM.CAST(WINUSER.LPNMHDR,lParam);
     idCtrl := SYSTEM.CAST(INTEGER,wParam);

     (* Allow toolbar to be customized *)
     IF ((pnhm^.code = COMMCTRL.TBN_QUERYDELETE) OR
         (pnhm^.code = COMMCTRL.TBN_QUERYINSERT)) THEN
          RETURN 1; (* We always say "yes" *)
     END;

     (* Provide details of allowable toolbar buttons *)
     IF (pnhm^.code = COMMCTRL.TBN_GETBUTTONINFO) THEN
          ptbn := SYSTEM.CAST(COMMCTRL.LPTBNOTIFY,lParam);
          iButton := nCust[ptbn^.iItem];

          IF (iButton # -1) THEN
	       lpstr := GetString (ptbn^.iItem);
               Str.Copy(ptbn^.pszText^,lpstr^);
               Lib.Move(SYSTEM.ADR(ptbn^.tbButton), SYSTEM.ADR(tbb[iButton]), SIZE(COMMCTRL.TBBUTTON));
               RETURN 1;
          END;
     END;

     RETURN 0;
END ToolBarNotify;

(*++++*****************************************************************)
PROCEDURE InitToolBar (hwndParent : WIN32.HWND) : WIN32.HWND;
(**********************************************************************)
VAR
     iNumButtons : INTEGER;
     ptbb        : COMMCTRL.LPTBBUTTON;
     uiBitmap    : CARDINAL;
     r           : WIN32.RECT;
     x, y, cx, cy: INTEGER;
BEGIN

     IF (bComboBox) THEN
          ptbb := SYSTEM.ADR(tbb[0]);
          iNumButtons := 31;
     ELSE
          ptbb := SYSTEM.ADR(tbb[21]);
          iNumButtons := 10;
     END;

     IF(bLargeIcons) THEN
       uiBitmap := COMMCTRL.IDB_STD_LARGE_COLOR;
     ELSE
       uiBitmap := COMMCTRL.IDB_STD_SMALL_COLOR;
     END;
     hwndTB := COMMCTRL.CreateToolbarEx (hwndParent,
                   dwToolBarStyles,
                   1, 15,
                   COMMCTRL.HINST_COMMCTRL,
                   uiBitmap,
                   ptbb^,
                   iNumButtons,
                   0, 0, 0, 0,
                   SIZE(COMMCTRL.TBBUTTON));

     (* If requested, add to string list *)
     IF (bStrings) THEN
          comcthlp.ToolBar_AddString (hwndTB, NIL, szTbStrings);
     END;

     (* Store handle to tooltip control*)
     hwndToolTip := comcthlp.ToolBar_GetToolTips (hwndTB);

     (* Insert combo box into toolbar *)
     IF (bComboBox) THEN

          (* Calculate coordinates for combo box *)
          comcthlp.ToolBar_GetItemRect (hwndTB, 0, SYSTEM.ADR(r));
          x := r.left;
          y := r.top;
          cy := 100;
          comcthlp.ToolBar_GetItemRect (hwndTB, 18, SYSTEM.ADR(r));
          cx := r.right - x + 1;

          hwndCombo := WINUSER.CreateWindow ("combobox",
                           "",
                           WINUSER.WS_CHILD BOR WINUSER.WS_VISIBLE BOR
                           WINUSER.CBS_DROPDOWN,
                           x, y, cx, cy,
                           hwndParent,
                           SYSTEM.CAST(WIN32.HMENU,h2d_gadgets.IDC_TB_COMBOBOX),
                           hInst,
                           NIL);

          (* Set toolbar as combo box window parent *)
          WINUSER.SetParent (hwndCombo, hwndTB);

          WINUSER.SendMessage (hwndCombo, WINUSER.CB_ADDSTRING, 0, SYSTEM.CAST(WIN32.LPARAM,(SYSTEM.ADR("ONE"))));
          WINUSER.SendMessage (hwndCombo, WINUSER.CB_ADDSTRING, 0, SYSTEM.CAST(WIN32.LPARAM,(SYSTEM.ADR("TWO"))));
          WINUSER.SendMessage (hwndCombo, WINUSER.CB_ADDSTRING, 0, SYSTEM.CAST(WIN32.LPARAM,(SYSTEM.ADR("THREE"))));

          (* Calculate toolbar height *)
          WINUSER.GetWindowRect (hwndCombo, r);
          cyToolBar := r.bottom - r.top + 1;
          cyToolBar := cyToolBar + y;
          cyToolBar := cyToolBar + (2 * WINUSER.GetSystemMetrics (WINUSER.SM_CYBORDER));
          comcthlp.ToolBar_GetItemRect (hwndTB, 0, SYSTEM.ADR(r));
          cyToolBar := Maximum(cyToolBar, r.bottom+5);

          (* If toolbar has tooltips, initialize. *)
          IF (dwToolBarStyles BAND COMMCTRL.TBSTYLE_TOOLTIPS=1) THEN
               ToolTip.InitToolTip (hwndTB, hwndCombo);
          END;
     END;
     RETURN hwndTB;
END InitToolBar;

(*++++*****************************************************************)
PROCEDURE FlipStyleFlag (dwStyle : WIN32.LPDWORD; flag : WIN32.DWORD);
(**********************************************************************)
BEGIN
     IF (dwStyle^ BAND flag=1) THEN (* Flag on -- turn off *)
         dwStyle^ := dwStyle^ BAND BNOT flag;
     ELSE                  (* Flag off -- turn on *)
         dwStyle^ := dwStyle^ BOR flag;
     END;
END FlipStyleFlag;

(*++++*****************************************************************)
PROCEDURE RebuildToolBar (hwndParent : WIN32.HWND; wFlag : WIN32.WORD) : WIN32.HWND;
(**********************************************************************)
VAR
  hwndTB  :  WIN32.HWND;
  r       :  WIN32.RECT;
BEGIN
     CASE (wFlag) OF
          | h2d_gadgets.IDM_STRINGS :
               bStrings := NOT bStrings;

          | h2d_gadgets.IDM_LARGEICONS :
               bLargeIcons := TRUE;

          | h2d_gadgets.IDM_SMALLICONS :
               bLargeIcons := FALSE;

          | h2d_gadgets.IDM_NODIVIDER :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.CCS_NODIVIDER);

          | h2d_gadgets.IDM_WRAPABLE :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.TBSTYLE_WRAPABLE);

          | h2d_gadgets.IDM_TOP :
               dwToolBarStyles := dwToolBarStyles BOR 0FFFFFFFCh;
               dwToolBarStyles := dwToolBarStyles BOR COMMCTRL.CCS_TOP;

          | h2d_gadgets.IDM_BOTTOM :
               dwToolBarStyles := dwToolBarStyles BAND 0FFFFFFFCh;
               dwToolBarStyles := dwToolBarStyles BOR COMMCTRL.CCS_BOTTOM;

          | h2d_gadgets.IDM_NOMOVEY :
               dwToolBarStyles := dwToolBarStyles BAND 0FFFFFFFCh;
               dwToolBarStyles := dwToolBarStyles BOR COMMCTRL.CCS_NOMOVEY;

          | h2d_gadgets.IDM_NOPARENTALIGN :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.CCS_NOPARENTALIGN);

          | h2d_gadgets.IDM_NORESIZE :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.CCS_NORESIZE);

          | h2d_gadgets.IDM_ADJUSTABLE :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.CCS_ADJUSTABLE);

          | h2d_gadgets.IDM_ALTDRAG :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.TBSTYLE_ALTDRAG);

          | h2d_gadgets.IDM_TOOLTIPS :
               FlipStyleFlag (SYSTEM.ADR(dwToolBarStyles), COMMCTRL.TBSTYLE_TOOLTIPS);

          | h2d_gadgets.IDM_COMBOBOX :
               bComboBox := NOT bComboBox;
     ELSE
     END;

     hwndTB := InitToolBar (hwndParent);

     (* Post parent a WM_SIZE message to resize children *)
     WINUSER.GetClientRect (hwndParent, r);
     WINUSER.PostMessage (hwndParent, WINUSER.WM_SIZE, 0,
                  WINUSER.MAKELPARAM (r.right, r.bottom));

     RETURN hwndTB;
END RebuildToolBar;


(*++++*****************************************************************)
PROCEDURE ToolBarMessage ( hwndTB : WIN32.HWND; wMsg : WIN32.WORD);
(**********************************************************************)
VAR
  nState   :  INTEGER;
  nButtons :  INTEGER;
  nRows    :  INTEGER;
  bCheck   :  BOOLEAN;
  bInd     :  BOOLEAN;
  bShow    :  BOOLEAN;
  bPress   :  BOOLEAN;
  bEnabled :  BOOLEAN;
  ach      :  ARRAY[0..79] OF CHAR;
BEGIN
     CASE (wMsg) OF
          | h2d_gadgets.IDM_TB_CHECK :
               nState := comcthlp.ToolBar_GetState (hwndTB, 1);
               bCheck := SYSTEM.CAST(BOOLEAN,BNOT (nState BAND COMMCTRL.TBSTATE_CHECKED));
               comcthlp.ToolBar_CheckButton (hwndTB, 1, VAL(WIN32.WORD,bCheck));

          | h2d_gadgets.IDM_TB_ENABLE :
               nState := comcthlp.ToolBar_GetState (hwndTB, 2);
               bEnabled := SYSTEM.CAST(BOOLEAN,BNOT (nState BAND COMMCTRL.TBSTATE_ENABLED));
               comcthlp.ToolBar_EnableButton (hwndTB, 2, VAL(WIN32.WORD,bEnabled));

          | h2d_gadgets.IDM_TB_HIDE :
               nState := comcthlp.ToolBar_GetState (hwndTB, 3);
               bShow := SYSTEM.CAST(BOOLEAN,BNOT (nState BAND COMMCTRL.TBSTATE_HIDDEN));
               comcthlp.ToolBar_HideButton (hwndTB, 3, VAL(WIN32.WORD,bShow));

          | h2d_gadgets.IDM_TB_INDETERMINATE :
               nState := comcthlp.ToolBar_GetState (hwndTB, 4);
               bInd := SYSTEM.CAST(BOOLEAN,BNOT (nState BAND COMMCTRL.TBSTATE_INDETERMINATE));
               comcthlp.ToolBar_Indeterminate (hwndTB, 4, VAL(WIN32.WORD,bInd));

          | h2d_gadgets.IDM_TB_PRESS :
               nState := comcthlp.ToolBar_GetState (hwndTB, 5);
               bPress := SYSTEM.CAST(BOOLEAN,BNOT (nState BAND COMMCTRL.TBSTATE_PRESSED));
               comcthlp.ToolBar_PressButton (hwndTB, 5, VAL(WIN32.WORD,bPress));

          | h2d_gadgets.IDM_TB_BUTTONCOUNT :
               nButtons := comcthlp.ToolBar_ButtonCount (hwndTB);
               WINUSER.wsprintf (ach, "Button Count := %d", nButtons);
               WINUSER.MessageBox (WINUSER.GetParent (hwndTB), ach,
                           "TB_BUTTONCOUNT", WINUSER.MB_OK);

          | h2d_gadgets.IDM_TB_GETROWS :
               nRows := comcthlp.ToolBar_GetRows (hwndTB);
               WINUSER.wsprintf (ach, "Row Count := %d", nRows);
               WINUSER.MessageBox (WINUSER.GetParent (hwndTB), ach,
                           "TB_GETROWS", WINUSER.MB_OK);

          | h2d_gadgets.IDM_TB_CUSTOMIZE :
               (* ToolBar_Customize (hwndTB); *)
               WINUSER.SendMessage (hwndTB,COMMCTRL.TB_CUSTOMIZE, SYSTEM.CAST(WIN32.LPARAM,tbb[25]), 5);
     ELSE
     END;
END ToolBarMessage;
BEGIN
END ToolBar.
