<*/NOWARN:F*>
IMPLEMENTATION MODULE ToolTip;
(*---------------------------------------
   TOOLTIP.C       --- Gadgets for a frame window.
                   (c) Paul Yao, 1996
   ToolTip.mod     --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1998
  ---------------------------------------*)
IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT WINX;
IMPORT SYSTEM;
IMPORT comcthlp;
IMPORT MemUtils;
IMPORT h2d_gadgets;
IMPORT COMMCTRL;
IMPORT ToolBar;
IMPORT Str;



(*++++*****************************************************************)
PROCEDURE InitToolTip(hwndToolBar : WIN32.HWND; hwndComboBox : WIN32.HWND) : BOOLEAN;
(**********************************************************************)
VAR
  bSuccess  :  BOOLEAN;
  ti        :  COMMCTRL.TOOLINFO;
BEGIN

     (* Fetch handle to tooltip control *)
     hwndTT := comcthlp.ToolBar_GetToolTips (hwndToolBar);
     IF (hwndTT = NIL) THEN
          RETURN FALSE;
     END;

     (* Add tooltip for main combo box *)
     MemUtils.FillMemBYTE (ti, SIZE (ti),0);
     ti.cbSize := SIZE(COMMCTRL.TOOLINFO);
     ti.uFlags := COMMCTRL.TTF_IDISHWND BOR COMMCTRL.TTF_CENTERTIP BOR COMMCTRL.TTF_SUBCLASS;
     ti.hwnd   := hwndToolBar;
     ti.uId    := SYSTEM.CAST(WIN32.UINT,SYSTEM.CAST(WIN32.HWND,hwndComboBox));
     ti.lpszText :=  COMMCTRL.LPSTR_TEXTCALLBACK;
     bSuccess :=  comcthlp.ToolTip_AddTool (hwndTT, ti);
     IF NOT bSuccess THEN
          RETURN FALSE;
     END;

     (* Add tooltip for combo box's edit control *)
     hwndEdit := WINUSER.GetWindow (hwndComboBox, WINUSER.GW_CHILD);
     ti.uId    := SYSTEM.CAST(WIN32.UINT, SYSTEM.CAST(WIN32.HWND, hwndEdit));
     bSuccess := comcthlp.ToolTip_AddTool (hwndTT, ti);

     RETURN bSuccess;
END InitToolTip;

(*++++*****************************************************************)
PROCEDURE CopyToolTipText(lpttt : COMMCTRL.LPTOOLTIPTEXT);
(**********************************************************************)
VAR
  i          : INTEGER;
  iButton    : INTEGER;
  cb         : INTEGER;
  cMax       : INTEGER;
  pString    : WIN32.LPSTR;
  pDest      : WIN32.LPSTR;
BEGIN

     iButton := lpttt^.hdr.idFrom;
     pDest := lpttt^.lpszText;

     (* Check for combo box window handles *)
     IF (lpttt^.uFlags BAND COMMCTRL.TTF_IDISHWND=1) THEN
          IF ((iButton = SYSTEM.CAST(INTEGER,ToolBar.hwndCombo)) OR (iButton = SYSTEM.CAST(INTEGER,hwndEdit))) THEN

               Str.Copy(pDest^, "1-2-3 ComboBox");
               RETURN;
          END;
     END;

     (* Map command ID to string index *)
     i := 0;
     LOOP
       IF(CommandToString[i] = -1) THEN
          EXIT;
       END;
       IF (CommandToString[i] = iButton) THEN
               iButton := i;
               EXIT;
       END;
       INC(i);
     END;
     (* To be safe, count number of strings in text *)
     pString^ := ToolBar.szTbStrings;
     cMax := 0;

     WHILE (pString^[0]#'') DO
          INC(cMax);
          cb := LENGTH(pString^);
          pString := SYSTEM.ADDADR(pString,cb + 1);
     END;

     (* Check for valid parameter *)
     IF (iButton > cMax) THEN
          pString^ := "Invalid Button Index";
     ELSE
          (* Cycle through to requested string *)
          pString^ :=ToolBar. szTbStrings;
          FOR i := 0 TO iButton-1 DO
               cb := LENGTH (pString^);
              pString := SYSTEM.ADDADR(pString,cb + 1);
          END;
     END;

     Str.Copy(pDest^,pString^);
END CopyToolTipText;
BEGIN
END ToolTip.
