<*/NOWARN:F*>
(*----------------------------------
   PAGE1.C         --- Property sheet page 1
                   (c) Paul Yao,      1996
   Page1.mod       --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1997
  ----------------------------------*)
IMPLEMENTATION MODULE Page1;
IMPORT SYSTEM;
IMPORT WIN32;
IMPORT WINUSER;
IMPORT COMMCTRL;
IMPORT h2d_property;
IMPORT Notify;
IMPORT Helper;
(*-------------------------------------------------------------------          *)
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE StylePageProc (hwnd        : WIN32.HWND;
(**********************************************************************)
          uMsg        : WIN32.UINT;
          ppsp        : COMMCTRL.LPPROPSHEETPAGE): WIN32.UINT [EXPORT];
BEGIN
     CASE (uMsg) OF
          | COMMCTRL.PSPCB_CREATE :
               (* Store pointer to style data                                  *)
               pTheStyles := SYSTEM.CAST(WIN32.LPDWORD,ppsp^.lParam);
               RETURN 1;

          | COMMCTRL.PSPCB_RELEASE :
               RETURN 0;
      ELSE

      RETURN 0;
      END;
END StylePageProc;
<*/POP*>

(*******************************************************************-          *)
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE StyleDlgProc (hwndDlg     : WIN32.HWND;
(**********************************************************************)
          msg         : WIN32.UINT;
          ppsp        : COMMCTRL.LPPROPSHEETPAGE;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIn32.BOOL [EXPORT];
VAR
  bCheck       :  BOOLEAN;
  dwOrigStyle  :  WIN32.DWORD;
  wNotifyCode  :  WIN32.WORD;
  wID          :  WIN32.WORD;
  hwndSheet    :  WIN32.HWND;
  pnmh         :  WINUSER.LPNMHDR;
  hwndPS       :  WIN32.HWND;
  hwndActive   :  WIN32.HWND;
  psh          :  COMMCTRL.LPPSHNOTIFY;
  hwndPropSheet:  WIN32.HWND;
BEGIN
     CASE (msg) OF
          | WINUSER.WM_INITDIALOG :
               dwOrigStyle := pTheStyles^;

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_VISIBLE));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_VISIBLE, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_DISABLED));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_DISABLED, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_MINIMIZE));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_MINIMIZE, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_MAXIMIZE));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_MAXIMIZE, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_CLIPCHILDREN));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_CLIPCHILDREN, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_CLIPSIBLINGS));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_CLIPSIBLINGS, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_BORDER));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_BORDER, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_CAPTION));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_CAPTION, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_DLGFRAME));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_DLGFRAME, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_HSCROLL));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_HSCROLL, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_MAXIMIZEBOX));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_MAXIMIZEBOX, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_MINIMIZEBOX));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_MINIMIZEBOX, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_SYSMENU));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_SYSMENU, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_THICKFRAME));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_THICKFRAME, bCheck);

               bCheck := SYSTEM.CAST(BOOLEAN,(dwOrigStyle BAND WINUSER.WS_VSCROLL));
               Helper.SetButtonCheck (hwndDlg, h2d_property.IDC_VSCROLL, bCheck);

               RETURN TRUE;

          | WINUSER.WM_COMMAND :
               wNotifyCode := WINUSER.HIWORD (wParam);
               wID := WINUSER.LOWORD (wParam);

               CASE (wID) OF
                    | h2d_property.IDC_VISIBLE :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_DISABLED :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_MINIMIZE :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_MAXIMIZE :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_CLIPCHILDREN :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_CLIPSIBLINGS :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_BORDER :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_CAPTION :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_DLGFRAME :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_HSCROLL :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_MAXIMIZEBOX :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_MINIMIZEBOX :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_SYSMENU :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_THICKFRAME :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
                    | h2d_property.IDC_VSCROLL :
                         hwndSheet := WINUSER.GetParent (hwndDlg);
                         COMMCTRL.PropSheet_Changed (hwndSheet, hwndDlg);
               ELSE
                  RETURN TRUE;
               END;

          | WINUSER.WM_HELP :
               (* Catch F1 key strike                                          *)
               WINUSER.MessageBox (hwndDlg, "WM_HELP Message Received",
                           "StyleDlgProc", WINUSER.MB_OK);
               RETURN TRUE;

          | WINUSER.WM_NOTIFY :
               pnmh := SYSTEM.CAST(WINUSER.LPNMHDR,lParam);

               (* Handle OK and Apply buttons                                  *)
               IF (pnmh^.code = COMMCTRL.PSN_APPLY) THEN

                    (* Overwrite current style value                           *)
                    pTheStyles^ := FetchStyles (hwndDlg);

                    (* Tell main window to re-create child window              *)
                    hwndPS := WINUSER.GetParent (hwndDlg);
                    hwndActive := COMMCTRL.PropSheet_GetCurrentPageHwnd (hwndPS);

                    (* Only re-create if we're the active page                 *)
                    IF (hwndDlg = hwndActive) THEN
                         WINUSER.PostMessage (hwndMain, h2d_property.PM_CREATEWINDOW, 0, 0h);
                    END;

               (* Destroy modeless dialog on OK or Cancel                      *)
               IF (WINUSER.IsWindowEnabled (hwndMain)  AND
                   ((pnmh^.code = COMMCTRL.PSN_APPLY) OR (pnmh^.code = COMMCTRL.PSN_RESET))) THEN
                    psh := SYSTEM.CAST(COMMCTRL.LPPSHNOTIFY,lParam);

                    (* Ignore Apply button                                     *)
                    IF (pnmh^.code = COMMCTRL.PSN_APPLY) AND (psh^.lParam = 0) THEN
                         RETURN TRUE;
                    END;
                    (* Clicking OK or Cancel, destroy property sheet           *)
                    hwndPropSheet := WINUSER.GetParent (hwndDlg);
                    WINUSER.DestroyWindow (hwndPropSheet);
                    hwndModeless := NIL;
               END;

               (* Enable Next button on wizard page                            *)
               IF (bWizard) AND (pnmh^.code = COMMCTRL.PSN_SETACTIVE) THEN
                    hwndSheet := WINUSER.GetParent (hwndDlg);
                    COMMCTRL.PropSheet_SetWizButtons (hwndSheet, COMMCTRL.PSWIZB_NEXT);
               END;
               RETURN TRUE;
          ELSE
               RETURN FALSE;
          END;
     ELSE
     END;
END StyleDlgProc;
<*/POP*>
(*+++***************************************************************-          *)
PROCEDURE FetchStyles (hwndDlg  :  WIN32.HWND) : WIN32.DWORD;
(*******************************************************************-          *)
VAR
  dwStyle   :  WIN32.DWORD;
BEGIN
     dwStyle := WINUSER.WS_CHILD;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_VISIBLE)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_VISIBLE;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_DISABLED)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_DISABLED;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_MINIMIZE)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_MINIMIZE;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_MAXIMIZE)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_MAXIMIZE;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_CLIPCHILDREN)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_CLIPCHILDREN;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_CLIPSIBLINGS)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_CLIPSIBLINGS;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_BORDER)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_BORDER;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_CAPTION)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_CAPTION;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_DLGFRAME)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_DLGFRAME;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_HSCROLL)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_HSCROLL;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_MAXIMIZEBOX)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_MAXIMIZEBOX;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_MINIMIZEBOX)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_MINIMIZEBOX;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_SYSMENU)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_SYSMENU;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_THICKFRAME)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_THICKFRAME;
     END;

     IF (Helper.QueryButtonCheck (hwndDlg, h2d_property.IDC_VSCROLL)) THEN
          dwStyle := dwStyle BOR WINUSER.WS_VSCROLL;
     END;

     RETURN dwStyle;
END FetchStyles;
BEGIN
END Page1.
