<*/NOWARN:F*>
(*-----------------------------------------
   SHEET.C         --- Property sheet page functions.
                   (c) Paul Yao,      1996
   Sheet.mod       --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler, 1997
  -----------------------------------------*)
IMPLEMENTATION MODULE Sheet;
IMPORT SYSTEM;
IMPORT COMMCTRL;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT WINX;
IMPORT comcthlp;
IMPORT MemUtils;
IMPORT h2d_property;
IMPORT Page1;
IMPORT Page2;

(*
extern DWORD dwChildStyle ;
extern DWORD dwChildExStyle ;
extern DWORD dwSheetStyles ;
extern char szAppName[] ;
extern HINSTANCE hInst;
extern HICON hiconApp;
*)

(*-------------------------------------------------------------------          *)
(*******************************************************************-          *)
<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END

(*++++*****************************************************************)
PROCEDURE  PropSheetProc (hwndDlg  : WIN32.HWND;
                    uMsg           : WIN32.UINT;
                    lParam         : WIN32.LPARAM) : INTEGER [EXPORT];
(**********************************************************************)
BEGIN
     CASE (uMsg) OF
          | COMMCTRL.PSCB_INITIALIZED :
               (* Process PSCB_INITIALIZED                                     *)
          | COMMCTRL.PSCB_PRECREATE :
               (* Process PSCB_PRECREATE                                       *)

     ELSE
               (* Unknown message                                              *)
     END;

     RETURN 0;
END PropSheetProc;
<*/POP*>

(*******************************************************************-          *)
PROCEDURE CreatePropertySheet (hwndParent : WIN32.HWND) : BOOLEAN;
(*******************************************************************-          *)
VAR
  pshead   :   COMMCTRL.PROPSHEETHEADER;
  pspage   :   ARRAY[0..1] OF COMMCTRL.PROPSHEETPAGE;
BEGIN
     (* Initialize property sheet HEADER data                                  *)
     MemUtils.FillMemBYTE (pshead, SIZE (COMMCTRL.PROPSHEETHEADER),0);
     pshead.dwSize  := SIZE (COMMCTRL.PROPSHEETHEADER);
     pshead.dwFlags := dwSheetStyles     BOR
                      COMMCTRL.PSH_PROPSHEETPAGE BOR
                      COMMCTRL.PSH_USECALLBACK   BOR
                      COMMCTRL.PSH_USEHICON;
     pshead.hwndParent  := hwndParent;
     pshead.hInstance   := hInst;
     (*
     pshead.hIcon       := hiconApp;
     *)
     pshead.pszCaption  := SYSTEM.ADR("A Child Window");
     pshead.nPages      := 2;
     (*
     pshead.nStartPage  := 0;
     pshead.ppsp        := pspage;
     *)
     pshead.pfnCallback := SYSTEM.CAST(COMMCTRL.PFNPROPSHEETCALLBACK,PropSheetProc);

     (* Zero out property PAGE data                                            *)
     MemUtils.FillMemBYTE (pspage, SIZE (COMMCTRL.PROPSHEETHEADER),0);

     (* PAGE 1 -- window style page                                            *)
     pspage[0].dwSize      := SIZE (COMMCTRL.PROPSHEETPAGE);
     pspage[0].dwFlags     := COMMCTRL.PSP_USECALLBACK BOR COMMCTRL.PSP_USEICONID;
     pspage[0].hInstance   := WINX.Instance;
     (*
     pspage[0].pszTemplate := WINUSER.MAKEINTRESOURCE (IDD_STYLES);
     pspage[0].pszIcon     := WINUSER.MAKEINTRESOURCE (IDI_PAGE1);
     *)
     pspage[0].pfnDlgProc  := SYSTEM.CAST(WINUSER.DLGPROC,Page1.StyleDlgProc);
     pspage[0].lParam      := SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(dwChildStyle));
     pspage[0].pfnCallback := SYSTEM.CAST(COMMCTRL.LPFNPSPCALLBACK,Page1.StylePageProc);

     (* PAGE 2 -- extended window style page                                   *)
     pspage[1].dwSize      := SIZE (COMMCTRL.PROPSHEETPAGE);
     pspage[1].dwFlags     := COMMCTRL.PSP_USECALLBACK BOR COMMCTRL.PSP_USEICONID BOR
                              COMMCTRL.PSP_HASHELP;
     pspage[1].hInstance   := hInst;
     (*
     pspage[1].pszTemplate := WINUSER.MAKEINTRESOURCE (IDD_EXSTYLES);
     pspage[1].pszIcon     := WINUSER.MAKEINTRESOURCE (IDI_PAGE2);
     *)
     pspage[1].pfnDlgProc  := SYSTEM.CAST(WINUSER.DLGPROC,Page2.ExStyleDlgProc);
     pspage[1].lParam      := SYSTEM.CAST(WIN32.LPARAM,SYSTEM.ADR(dwChildExStyle));
     pspage[1].pfnCallback := SYSTEM.CAST(COMMCTRL.LPFNPSPCALLBACK,Page2.ExStylePageProc);

     (* ********* Create and display property sheet *********                    *)

     RETURN SYSTEM.CAST(BOOLEAN,COMMCTRL.PropertySheet (pshead));
END CreatePropertySheet;
BEGIN
END Sheet.
