<*/NOWARN:F*>

MODULE RndRctMT;
(*------------------------------------------
   RNDRCTMT.C      --- Displays Random Rectangles
                   (c) Charles Petzold, 1996
   RndRctMT.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ------------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT Lib;
IMPORT Threads;

VAR
  hwnd      :  WIN32.HWND;
  cxClient  :  INTEGER;
  cyClient  :  INTEGER;
  msg       :  WINUSER.MSG;
  wc        :  WINUSER.WNDCLASSEX;
CONST szAppName = "RndRctMT";

(*++++*****************************************************************)
PROCEDURE MaxInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN a;
  ELSE
    RETURN b;
  END;
END MaxInt;
(*++++*****************************************************************)
PROCEDURE MinInt (a,b : INTEGER) : INTEGER;
(**********************************************************************)
BEGIN
  IF(a>b) THEN
    RETURN b;
  ELSE
    RETURN a;
  END;
END MinInt;

PROCEDURE Thread (dummy :  SYSTEM.ADDRESS) : WIN32.DWORD;
 
    

VAR
  hBrush   :  WIN32.HBRUSH;
  hdc      :  WIN32.HDC;
  xLeft    :  INTEGER;
  xRight   :  INTEGER;
  yTop     :  INTEGER;
  yBottom  :  INTEGER;
  iRed     :  INTEGER;
  iGreen   :  INTEGER;
  iBlue    :  INTEGER;
BEGIN
(*
UNREFERENCED_PARAMETER(dummy);  *)

     LOOP
          IF (cxClient # 0) OR (cyClient # 0) THEN
	       xLeft   := VAL(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cxClient));
	       xRight  := VAL(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cxClient));
               yTop    := VAL(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cyClient));
	       yBottom := VAL(INTEGER,Lib.RANDOM(1000) REM VAL(CARDINAL,cyClient));
	       iRed    := VAL(INTEGER,Lib.RANDOM(1000) + 255);
	       iGreen  := VAL(INTEGER,Lib.RANDOM(1000) + 255);
	       iBlue   := VAL(INTEGER,Lib.RANDOM(1000) + 255);
	 
              
               hdc := WINUSER.GetDC (hwnd);
               hBrush := WINGDI.CreateSolidBrush (WINGDI.RGB (iRed, iGreen, iBlue));
               WINGDI.SelectObject (hdc, SYSTEM.CAST(WIN32.HGDIOBJ,hBrush));

               WINGDI.Rectangle (hdc, MinInt(xLeft, xRight), MinInt (yTop, yBottom),
                               MaxInt (xLeft, xRight), MaxInt (yTop, yBottom));

               WINUSER.ReleaseDC (hwnd, hdc);
               WINGDI.DeleteObject (SYSTEM.CAST(WIN32.HGDIOBJ,hBrush));
          END;
     END;
     RETURN 0;
END Thread;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc(hwnd       : WIN32.HWND;
(**********************************************************************)
                 iMsg        : WIN32.UINT;
                 wParam      : WIN32.WPARAM;
                 lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
		 
VAR		 
  MessageThread : Threads.Thread;
BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE :
	       (*
	       threadHandle := WIN32.CreateThread(WINX.NIL_SECURITY_ATTRIBUTES,100000,SYSTEM.CAST(WIN32.LPTHREAD_START_ROUTINE,Thread),
	       NIL,WIN32.CREATE_SUSPENDED,tid);
	       *)
	       Threads.CreateThread(MessageThread, Thread, NIL, 8192, TRUE);
	       RETURN 0;

          | WINUSER.WM_SIZE :
               cxClient := WINUSER.LOWORD (lParam);
               cyClient := WINUSER.HIWORD (lParam);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
       RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
VAR
  rc    :  CARDINAL;
BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW + WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  rc := WINUSER.RegisterClassEx(wc);
  RETURN rc#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Random Rectangles: Translation to Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
 
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  Lib.RANDOMIZE((*1000*));
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END RndRctMT.
