<*/NOWARN:F*>
MODULE FormFeed;
(*---------------------------------------------
   FORMFEED.C      --- Advances printer to next page
                   (c) Charles Petzold, 1996
   FormFeed.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  ---------------------------------------------*)
IMPORT WIN32;
IMPORT WINGDI;
IMPORT SYSTEM;
IMPORT WINSPOOL;
IMPORT WINX;

VAR
  hdcPrint   :  WIN32.HDC;
  di         :  WINGDI.DOCINFO;

(*++++*****************************************************************)
PROCEDURE GetPrinterDC ():WIN32.HDC;
(**********************************************************************)
VAR
  pinfo5     :  ARRAY[0..2] OF WINSPOOL.PRINTER_INFO_5;
  dwNeeded   :  WIN32.DWORD;
  dwReturned :  WIN32.DWORD;
BEGIN
     IF (WINSPOOL.EnumPrinters (WINSPOOL.PRINTER_ENUM_DEFAULT, WINX.NIL_ASTR, 5, SYSTEM.CAST(WIN32.LPBYTE,SYSTEM.ADR(pinfo5)),
                       SIZE (pinfo5), dwNeeded, dwReturned)) THEN
          RETURN WINGDI.CreateDC (WINX.NIL_ASTR, pinfo5[0].pPrinterName^, WINX.NIL_ASTR, WINX.NIL_DEVMODEA);
     END;
     RETURN NIL;            (* EnumPrinters failed, so RETURN null hdc          *)
END GetPrinterDC;
(*++++*****************************************************************)
BEGIN
di :=  WINGDI.DOCINFO{ SIZE(WINGDI.DOCINFO), SYSTEM.ADR("FormFeed"), NIL } ;
     hdcPrint := GetPrinterDC () ;
     IF (hdcPrint # NIL) THEN
          IF (WINGDI.StartDoc (hdcPrint, di) > 0) THEN
               IF (WINGDI.StartPage (hdcPrint) > 0) AND (WINGDI.EndPage (hdcPrint) > 0) THEN
                    WINGDI.EndDoc (hdcPrint);
               END;
          END;
          WINGDI.DeleteDC (hdcPrint);
     END;
END FormFeed.
