<*/NOWARN:F*>
IMPLEMENTATION MODULE PopFile;
(*------------------------------------------
   POPFILE.C -- Popup Editor File Functions
  ------------------------------------------*)

IMPORT Storage;
IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT Strings;
IMPORT COMMDLG;
IMPORT SYSTEM;
IMPORT FileFunc;
IMPORT MemUtils;
IMPORT WINX;

VAR
  ofn    :   COMMDLG.OPENFILENAME;
CONST
   szFilter : ARRAY[0..100] OF CHAR = 
              {"Text Files (*.TXT","","0*.txt","",
               "ASCII Files (*.ASC)","","*.asc","",
               "All Files (*.*)","","*.*"
              };

   txt      = "txt";
   (*
   IDSTR_FILTER = 1000;
VAR   
    filter : ARRAY [0..1000] OF CHAR;
    *)

(*++++****************************************************************)
PROCEDURE Initialize (hwnd :   WIN32.HWND);
(*********************************************************************)
BEGIN
(*
     MemUtils.FillMemBYTE (filter, SIZE (filter),0);
     SYSTEM.FUNC WINUSER.LoadString (WINX.Instance, IDSTR_FILTER, filter, SIZE (filter));
     *)

     MemUtils.FillMemBYTE (ofn, SIZE (ofn),0);
     ofn.lStructSize       := SIZE(COMMDLG.OPENFILENAME);
     ofn.hwndOwner         := hwnd;
     ofn.hInstance         := NIL;
     ofn.lpstrFilter       := SYSTEM.ADR(szFilter);
     ofn.lpstrCustomFilter := NIL;
     ofn.nMaxCustFilter    := 0;
     ofn.nFilterIndex      := 0;
     ofn.lpstrFile         := NIL;          (* Set in Open and Close functions *)
     ofn.nMaxFile          := WIN32.MAX_PATH;
     ofn.lpstrFileTitle    := NIL;                                 (* Set in Open and Close functions         *)
     ofn.nMaxFileTitle     := WIN32.MAX_FNAME + WIN32.MAX_EXT;
     ofn.lpstrInitialDir   := NIL;
     ofn.lpstrTitle        := NIL;
     ofn.Flags             := 0;            (* Set in Open and Close functions         *)
     ofn.nFileOffset       := 0;
     ofn.nFileExtension    := 0;
     ofn.lpstrDefExt       := SYSTEM.ADR(txt);
     ofn.lCustData         := 0000h;
     ofn.lpfnHook          := SYSTEM.CAST(COMMDLG.LPOFNHOOKPROC,NIL);
     ofn.lpTemplateName    := NIL;
END Initialize;
(*++++****************************************************************)
PROCEDURE OpenDlg (hwnd            : WIN32.HWND;
                   pstrFileName    : WIN32.PSTR;
                   pstrTitleName   : WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := COMMDLG.OFN_HIDEREADONLY BOR COMMDLG.OFN_CREATEPROMPT;

     RETURN COMMDLG.GetOpenFileName (ofn);
END OpenDlg;

(*++++****************************************************************)
PROCEDURE SaveDlg (hwnd         :  WIN32.HWND;
                   pstrFileName :  WIN32.PSTR;
                   pstrTitleName:  WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
BEGIN
     ofn.hwndOwner         := hwnd;
     ofn.lpstrFile         := pstrFileName;
     ofn.lpstrFileTitle    := pstrTitleName;
     ofn.Flags             := COMMDLG.OFN_OVERWRITEPROMPT;

     RETURN COMMDLG.GetSaveFileName (ofn);
END SaveDlg;

(*++++****************************************************************)
PROCEDURE Length (file   :  FILE) : WIN32.LONG;
(*********************************************************************)
VAR
   iFileLength  :  INTEGER;
BEGIN
     iFileLength := FileFunc.FileLength(file);
     RETURN iFileLength;
END Length;

(*++++****************************************************************)
PROCEDURE Read (hwndEdit    :  WIN32.HWND;
                pstrFileName:  WIN32.PSTR) : WIN32.BOOL;
(*********************************************************************)
VAR
     file       :  FILE;
     iLength    :  CARDINAL;
     pstrBuffer :  WIN32.PSTR;
BEGIN
     FileFunc.OpenFile (file,pstrFileName^,FileFunc.ReadWriteDenyNone);
     IF (file.status # 0) THEN
          RETURN FALSE;
     END;
     iLength := Length (file);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FileFunc.CloseFile(file);
          RETURN FALSE;
     END;

     FileFunc.ReadBlock(file,pstrBuffer^,iLength);
     FileFunc.CloseFile(file);

     WINUSER.SetWindowText (hwndEdit, pstrBuffer^);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Read;

(*++++****************************************************************)
PROCEDURE Write (hwndEdit     :  WIN32.HWND;
                 pstrFileName :  WIN32.PSTR ) : WIN32.BOOL;
(*********************************************************************)
VAR
     file         : FILE;
     iLength      : CARDINAL;
     pstrBuffer   : WIN32.PSTR;
BEGIN
     FileFunc.CreateFile(file,pstrFileName^);
     IF (file.status # 0) THEN
          RETURN FALSE;
     END;
     iLength := WINUSER.GetWindowTextLength (hwndEdit);

     Storage.ALLOCATE(pstrBuffer,iLength+1);
     IF (pstrBuffer = NIL) THEN
          FileFunc.CloseFile(file);
          RETURN FALSE;
     END;

     WINUSER.GetWindowText (hwndEdit, pstrBuffer^, iLength + 1);

     FileFunc.WriteBlock(file,pstrBuffer^,iLength);
     IF(file.count#iLength) THEN
          FileFunc.CloseFile(file);
          Storage.DEALLOCATE(pstrBuffer,iLength+1);
          RETURN FALSE;
     END;

     FileFunc.CloseFile(file);
     Storage.DEALLOCATE(pstrBuffer,iLength+1);

     RETURN TRUE;
END Write;
BEGIN
END PopFile.
