<*/NOWARN:F*>
IMPLEMENTATION MODULE PopPrnt;
(*----------------------------------------------
   POPPRNT.C -- Popup Editor Printing Functions
  ----------------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINGDI;
IMPORT COMMDLG;
IMPORT SYSTEM;
IMPORT h2d_PopPad;

VAR
  bUserAbort :  WIN32.BOOL;
  hDlgPrint  :  WIN32.HWND;
VAR di  :  WINGDI.DOCINFO;
    pd  :  COMMDLG.PRINTDLG;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE PrintDlgProc (hDlg   : WIN32.HWND;
                  msg          : WIN32.UINT;
                  wParam       : WIN32.WPARAM;
                  lParam       : WIN32.LPARAM) : WIN32.BOOL [EXPORT];
(**********************************************************************)
BEGIN
     CASE (msg) OF
          | WINUSER.WM_INITDIALOG :
               WINUSER.EnableMenuItem (WINUSER.GetSystemMenu (hDlg, FALSE), WINUSER.SC_CLOSE,
                                                            WINUSER.MF_GRAYED);
               RETURN TRUE;

          | WINUSER.WM_COMMAND :
               bUserAbort := TRUE;
               WINUSER.EnableWindow (WINUSER.GetParent (hDlg), TRUE);
               WINUSER.DestroyWindow (hDlg);
               hDlgPrint := SYSTEM.CAST(WIN32.HWND,0);
               RETURN TRUE;
     ELSE
       RETURN FALSE;
     END;
END PrintDlgProc;
<*/POP*>


<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE AbortProc (hPrinterDC     : WIN32.HDC;
                        iCode       : INTEGER) : WIN32.BOOL [EXPORT];
(**********************************************************************)
VAR
  msg   :  WINUSER.MSG;
BEGIN
     WHILE (bUserAbort=FALSE) AND (WINUSER.PeekMessage (msg, NIL, 0, 0, WINUSER.PM_REMOVE)=TRUE) DO
          IF (hDlgPrint=SYSTEM.CAST(WIN32.HWND,0)) OR (WINUSER.IsDialogMessage (hDlgPrint,msg)=FALSE) THEN
               WINUSER.TranslateMessage (msg);
               WINUSER.DispatchMessage (msg);
          END;
     END;
     RETURN NOT bUserAbort;
END AbortProc;
<*/POP*>


(*++++*****************************************************************)
PROCEDURE PrintFile (hInst        : WIN32.HINSTANCE;
                     hwnd         : WIN32.HWND;
                     hwndEdit     : WIN32.HWND;
                     szTitleName  : WIN32.LPSTR) : WIN32.BOOL;
(**********************************************************************)
VAR
  bSuccess       : WIN32.BOOL;
  pstrBuffer     : WIN32.LPCTSTR;
  yChar          : INTEGER;
  iCharsPerLine  : INTEGER;
  iLinesPerPage  : INTEGER;
  iTotalLines    : INTEGER;
  iTotalPages    : INTEGER;
  iPage          : INTEGER;
  iLine          : INTEGER;
  iLineNum       : INTEGER;
  tm             : WINGDI.TEXTMETRIC;
  iColCopy       : CARDINAL;
  iNoiColCopy    : CARDINAL;
  i              : CARDINAL;
  j              : CARDINAL;
  rc             : INTEGER;
BEGIN
     di :=  WINGDI.DOCINFO{ SIZE (WINGDI.DOCINFO), NIL,NIL};
     pd.lStructSize         := SIZE (COMMDLG.PRINTDLG);
     pd.hwndOwner           := hwnd;
     pd.hDevMode            := NIL;
     pd.hDevNames           := NIL;
     pd.hDC                 := NIL;
     pd.Flags               := COMMDLG.PD_ALLPAGES BOR COMMDLG.PD_COLLATE BOR COMMDLG.PD_RETURNDC;
     pd.nFromPage           := 1;           (* Korrektur von G. Born    *)
     pd.nToPage             := 0FFFFh;      (* Werte von 0 auf 1 bzw.   *)
     pd.nMinPage            := 1;           (* 0xFFFF gesetzt, damit    *)
     pd.nMaxPage            := 0FFFFh;      (* Sortieren funktioniert   *)
     pd.nCopies             := 1;
     pd.hInstance           := NIL;
     pd.lCustData           := 0000h;
     pd.lpfnPrintHook       := SYSTEM.CAST(COMMDLG.LPPRINTHOOKPROC,NIL);
     pd.lpfnSetupHook       := SYSTEM.CAST(COMMDLG.LPSETUPHOOKPROC,NIL);
     pd.lpPrintTemplateName := NIL;
     pd.lpSetupTemplateName := NIL;
     pd.hPrintTemplate      := NIL;
     pd.hSetupTemplate      := NIL;

     IF ( NOT COMMDLG.PrintDlg (pd)) THEN
          RETURN TRUE;
     END;  (* *)
     iTotalLines := SYSTEM.CAST(WIN32.SHORT, WINUSER.SendMessage (hwndEdit, WINUSER.EM_GETLINECOUNT, 0, 0000h));

     IF (iTotalLines = 0) THEN
          RETURN TRUE;
     END;
     WINGDI.GetTextMetrics (pd.hDC, tm);
     yChar := tm.tmHeight + tm.tmExternalLeading;

     iCharsPerLine := WINGDI.GetDeviceCaps (pd.hDC, WINGDI.HORZRES) / tm.tmAveCharWidth;
     iLinesPerPage := WINGDI.GetDeviceCaps (pd.hDC, WINGDI.VERTRES) / yChar;
     iTotalPages   := (iTotalLines + iLinesPerPage - 1) / iLinesPerPage;

     pstrBuffer := SYSTEM.CAST(WIN32.LPCTSTR,WIN32.HeapAlloc (WIN32.GetProcessHeap (),
                                               WIN32.HEAP_NO_SERIALIZE, iCharsPerLine + 1));

     WINUSER.EnableWindow (hwnd, FALSE);

     bSuccess   := TRUE;
     bUserAbort := FALSE;

     hDlgPrint := WINUSER.CreateDialog (hInst,"PrintDlgBox", hwnd, PrintDlgProc);
     WINUSER.SetDlgItemText (hDlgPrint, h2d_PopPad.IDD_FNAME, szTitleName^);

     rc := WINGDI.SetAbortProc (pd.hDC, SYSTEM.CAST(WINGDI.ABORTPROC,AbortProc));

     WINUSER.GetWindowText (hwnd, di.lpszDocName^, SIZE (WIN32.PTSTR));

     IF (WINGDI.StartDoc (pd.hDC, di) > 0) THEN
          IF((SYSTEM.CAST(WIN32.WORD,pd.Flags - COMMDLG.PD_COLLATE))#0) THEN
            i := VAL(CARDINAL,pd.nCopies);
          ELSE
            i := 1;
          END;

          iColCopy := 0;
          LOOP
               iPage := 0;
               LOOP
                 IF(pd.Flags - COMMDLG.PD_COLLATE#0) THEN
                   j := VAL(CARDINAL,pd.nCopies);
                 ELSE
                   j := 1;
                 END;
                    iNoiColCopy := 0;
                    LOOP
                         IF (WINGDI.StartPage (pd.hDC) < 0) THEN
                              bSuccess := FALSE;
                            EXIT;
                         END;

                         iLine := 0;
                         LOOP

                              iLineNum := iLinesPerPage * iPage + iLine;

                              IF (iLineNum > iTotalLines) THEN
                                 EXIT;
                              END;
                              pstrBuffer := SYSTEM.CAST(WIN32.LPCTSTR,SYSTEM.ADR(iCharsPerLine));  

                              WINGDI.TextOut (pd.hDC, 0, yChar * iLine, pstrBuffer^,
                                   WINUSER.SendMessage (hwndEdit, WINUSER.EM_GETLINE,
                                   iLineNum,
                                   SYSTEM.CAST(WIN32.WPARAM,pstrBuffer)));
                              INC(iLine);
                              IF(iLine>iLinesPerPage) THEN
                                EXIT;
                              END;
                         END;
                         INC(iNoiColCopy);
                         IF(iNoiColCopy>j) THEN
                           EXIT;
                         END;
                         IF (WINGDI.EndPage (pd.hDC) < 0) THEN
                              bSuccess := FALSE;
                              EXIT;
                         END;

                         IF (bUserAbort) THEN
                              EXIT;
                         END;
                    END;
                    IF ( NOT bSuccess OR bUserAbort) THEN
                         EXIT;
                    END;
                    INC(iPage);
                    IF(iPage>=iTotalPages) THEN
                      EXIT;
                    END;
               END;
               IF ( NOT bSuccess OR bUserAbort) THEN
                    EXIT;
               END;
               INC(iColCopy);
               IF(iColCopy>i-1) THEN
                 EXIT;
               END;
          END;
     ELSE
          bSuccess := FALSE;
     END;
     IF (bSuccess) THEN
          WINGDI.EndDoc (pd.hDC);
     END;
     IF ( NOT bUserAbort) THEN
          WINUSER.EnableWindow (hwnd, TRUE);
          WINUSER.DestroyWindow (hDlgPrint);
     END;

     WIN32.HeapFree (WIN32.GetProcessHeap (), 0, SYSTEM.CAST(WIN32.LPVOID,pstrBuffer));
     WINGDI.DeleteDC (pd.hDC);

     RETURN bSuccess AND NOT bUserAbort;
END PrintFile;

BEGIN
END PopPrnt.
