<*/NOWARN:F*>
MODULE ClipView;
(*-----------------------------------------
   CLIPVIEW.C      --- Simple Clipboard Viewer
                   (c) Charles Petzold, 1996
   ClipView.mod    --- Translation to Stony Brook Modula-2
                   (c) Peter Stadler,   1997
  -----------------------------------------*)

IMPORT WINUSER;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;
IMPORT SYSTEM;

CONST
  szAppName=  "ClipView";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;

   hwndNextViewer  :  WIN32.HWND;
   hGMem           :  WIN32.HGLOBAL;
   hdc             :  WIN32.HDC;
   pGMem           :  WIN32.PSTR;
   ps              :  WINUSER.PAINTSTRUCT;
   rect            :  WIN32.RECT;
   rc              :  WIN32.RECT;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];

BEGIN

  CASE (iMsg)  OF
          | WINUSER.WM_CREATE :
               hwndNextViewer := WINUSER.SetClipboardViewer (hwnd);
               RETURN 0;

          | WINUSER.WM_CHANGECBCHAIN :
               IF (SYSTEM.CAST(WIN32.HWND,wParam) = hwndNextViewer) THEN
                    hwndNextViewer := SYSTEM.CAST(WIN32.HWND,lParam);

               ELSIF (hwndNextViewer#NIL) THEN
                    WINUSER.SendMessage (hwndNextViewer, iMsg, wParam, lParam);
               END;
               RETURN 0;

          | WINUSER.WM_DRAWCLIPBOARD :
               IF (hwndNextViewer#NIL) THEN
                    WINUSER.SendMessage (hwndNextViewer, iMsg, wParam, lParam);
               END;
               WINUSER.InvalidateRect (hwnd, rc, TRUE);
               RETURN 0;

          | WINUSER.WM_PAINT :
               hdc := WINUSER.BeginPaint (hwnd, ps);
               WINUSER.GetClientRect (hwnd, rect);
               WINUSER.OpenClipboard (hwnd);

               hGMem := SYSTEM.CAST(WIN32.HGLOBAL,WINUSER.GetClipboardData (WINUSER.CF_TEXT));

               IF (hGMem # NIL) THEN
                    pGMem := SYSTEM.CAST(WIN32.PSTR,WIN32.GlobalLock (hGMem));
                    WINUSER.DrawText (hdc, pGMem^, -1, rect, WINUSER.DT_EXPANDTABS);
                    WIN32.GlobalUnlock (hGMem);
               END;
               WINUSER.CloseClipboard ();
               WINUSER.EndPaint (hwnd, ps);
               RETURN 0;

          | WINUSER.WM_DESTROY :
               WINUSER.ChangeClipboardChain (hwnd, hwndNextViewer);
               WINUSER.PostQuitMessage (0);
               RETURN 0;
     ELSE
               RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam);
     END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)
BEGIN

  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW   + WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := NIL;
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);
  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (
                       szAppName,                      (* window class name            *)
                       "Simple Clipboard Viewer (Text only): Stony Brook Modula-2",
                                                       (* window caption               *)
                       WINUSER.WS_OVERLAPPEDWINDOW,    (* window style                 *)
                       WINUSER.CW_USEDEFAULT,          (* initial x position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial y position           *)
                       WINUSER.CW_USEDEFAULT,          (* initial x size               *)
                       WINUSER.CW_USEDEFAULT,          (* initial y size               *)
                       NIL,                            (* parent window handle         *)
                       NIL,                            (* window menu handle           *)
                       wc.hInstance,                   (* program instance handle      *)
                       NIL);                           (* creation parameters          *)

  IF hwnd = NIL THEN
    RETURN FALSE;
  END;
  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END ClipView.
