IMPLEMENTATION MODULE Helper;

IMPORT SysClock;
IMPORT TimeFunc;
IMPORT h2d_ddepop;
(*++++*****************************************************************)
PROCEDURE CalcPops();
(**********************************************************************)
VAR
  i         :  INTEGER;
  lTime     :  CARDINAL;
  SBM2Date  :  SysClock.DateTime;
BEGIN
     SysClock.GetClock(SBM2Date);
     TimeFunc.DateTimeToC(SBM2Date,lTime);
                                                      (* time in seconds since 1\1\70        *)
     lTime := lTime - (92h(*L*) * 24 * 60 * 60);      (* time in seconds since 4\1\70        *)

     FOR i := 0 TO h2d_ddepop.NUM_STATES DO
          h2d_ddepop.pop[i].lPop := VAL(INTEGER,h2d_ddepop.pop[i].a * FLOAT(lTime) * FLOAT(lTime) +
                                    h2d_ddepop.pop[i].b * FLOAT(lTime) +
                                    h2d_ddepop.pop[i].c);
     END;
END CalcPops;

(*++++*****************************************************************)
PROCEDURE InitPops();
(**********************************************************************)
VAR
  i       :  INTEGER;
  ldSec80 :  LONGREAL;
  ldSec90 :  LONGREAL;
BEGIN
     ldSec80 := 3653.0 * 24. * 60. * 60.;  (* seconds from 4\1\70 to 4\1\80       *)
     ldSec90 := 7305.0 * 24. * 60. * 60.;  (* seconds from 4\1\70 to 4\1\90       *)

     FOR i := 0 TO h2d_ddepop.NUM_STATES  DO
          h2d_ddepop.pop[i].a := (ldSec90 * FLOAT(h2d_ddepop.pop[i].lPop80 - h2d_ddepop.pop[i].lPop70) +
                      ldSec80 * FLOAT(h2d_ddepop.pop[i].lPop70 - h2d_ddepop.pop[i].lPop90)) /
                     (ldSec90 * ldSec80 * (ldSec80 - ldSec90));

          h2d_ddepop.pop[i].b := (ldSec90 * ldSec90 * FLOAT(h2d_ddepop.pop[i].lPop70 - h2d_ddepop.pop[i].lPop80) +
                      ldSec80 * ldSec80 * FLOAT(h2d_ddepop.pop[i].lPop90 - h2d_ddepop.pop[i].lPop70)) /
                     (ldSec90 * ldSec80 * (ldSec80 - ldSec90));

          h2d_ddepop.pop[i].c := FLOAT(h2d_ddepop.pop[i].lPop70);
     END;

     CalcPops ();
END InitPops;
END Helper.
