MODULE EDRTest;
(*--------------------------------------------------------
   EDRTEST.C      --- Program using EDRLIB dynamic link library
                  (c) Charles Petzold, 1996
   EDRTest.MOD    --- Translation to Stony Brook Modula-2
                  (c) Peter Stadler,   1997
  --------------------------------------------------------*)

IMPORT WINUSER;
IMPORT EDRStuff;
IMPORT SYSTEM;
IMPORT WIN32;
IMPORT WINX;
IMPORT WINGDI;

CONST
     szAppName = "StrgProg";
VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
   hdc             :  WIN32.HDC;
   ps              :  WINUSER.PAINTSTRUCT;
   rect            :  WIN32.RECT;

<*/PUSH*>
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
                   iMsg        : WIN32.UINT;
                   wParam      : WIN32.WPARAM;
                   lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
BEGIN
  CASE (iMsg) OF
    | WINUSER.WM_PAINT :
         hdc := WINUSER.BeginPaint (hwnd, ps) ;

         WINUSER.GetClientRect (hwnd, rect) ;

         EDRStuff.EdrCenterText (hdc, SYSTEM.ADR(rect),
                        SYSTEM.ADR("This string was displayed by a DLL")) ;

         WINUSER.EndPaint (hwnd, ps) ;
         RETURN 0 ;

    | WINUSER.WM_DESTROY :
         WINUSER.PostQuitMessage (0) ;
         RETURN 0 ;
  ELSE
    RETURN WINUSER.DefWindowProc (hwnd, iMsg, wParam, lParam) ;
  END;
END WndProc;
<*/POP*>

(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)

BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := WINUSER.CS_HREDRAW  BOR WINUSER.CS_VREDRAW;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon (NIL, WINUSER.IDI_APPLICATION^);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW^);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, WINGDI.GetStockObject (WINGDI.WHITE_BRUSH));
  wc.lpszMenuName  := NIL;
  wc.lpszClassName := SYSTEM.ADR(szAppName);
  wc.hIconSm       := WINUSER.LoadIcon (NIL,WINUSER.IDI_APPLICATION^);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindow (szAppName,
                        "DLL Demonstration Program: Translation to Stony Brook Modula-2",
                        WINUSER.WS_OVERLAPPEDWINDOW,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        WINX.Instance,
                        NIL);

  WINUSER.ShowWindow (hwnd, WINUSER.SW_SHOWDEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;

BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END EDRTest.
