<*/NOWARN:F*>

MODULE Caller;
(*---------------------------------------------
   CALLER.C    -- Call into private OLE component
                  (c) Paul Yao, 1996
   Caller.mod  -- Translation to Stony Brook Modula-2
                  (c) Peter Stadler, 1997
  ---------------------------------------------*)
%IF WIN32 %THEN
    <*/Resource:CALLER.RES*>
%ELSE
%END
IMPORT WINUSER;
IMPORT WINGDI;
IMPORT WIN32;
IMPORT WINX;
IMPORT SYSTEM;
IMPORT h2d_Caller;
IMPORT h2d_Imalloc;

CONST szWndClass = "CallerWindow";
CONST szAppName  = "Malloc Caller";

VAR
   hwnd            :  WIN32.HWND;
   msg             :  WINUSER.MSG;
   wc              :  WINUSER.WNDCLASSEX;
VAR
     iCurLine   : INTEGER = 0;
     pMalloc    : LPMALLOC = NIL;
     szLine     : ARRAY[0..9] OF LPSTR;
     rHit       : ARRAY[0..9] OF RECT;
(*******************************************************************-          *)
%IF WIN32 %THEN
    <*/CALLS:WIN32SYSTEM*>
%ELSE
    <*/CALLS:WINSYSTEM*>
%END
(*++++*****************************************************************)
PROCEDURE WndProc (hwnd        : WIN32.HWND;
(**********************************************************************)
          iMsg        : WIN32.UINT;
          wParam      : WIN32.WPARAM;
          lParam      : WIN32.LPARAM) : WIN32.LRESULT [EXPORT];
VAR
  i     :  INTEGER;
  x     :  INTEGER;
  y     :  INTEGER;
  pUnk  :  LPUNKNOWN;
  hr    :  HRESULT;
  pt    :  POINT;
  szBuff             :  ARRAY[0..9] OF CHAR;
  szBuff             :  ARRAY[0..9] OF CHAR;
  crText, crBack     :  COLORREF;
  hdc                :  HDC;
  cc                 :  INTEGER;
  i                  :  INTEGER;
  XCount, XText, Y   :  INTEGER;
  cyLineHeight       :  INTEGER;
  ps                 :  PAINTSTRUCT
  rOpaque            :  RECT
  tm                 :  TEXTMETRIC
BEGIN
     CASE (iMsg) OF
          | WINUSER.WM_CREATE :
               (* Initialize data pointer array                                *)
               ZeroMemory (szLine, SIZE (szLine));
               RETURN 0;

          | WINUSER.WM_COMMAND :
               CASE (WINUSER.LOWORD (wParam))                                                                                                                                                          OF
                    | IDM_CREATE :
                         pMalloc := CreateAllocator ();
                         IF (pMalloc = NIL) THEN
                              MessageBox (hwnd, "Error: No allocator",
                                          szAppName, MB_OK);
                              RETURN 0;
                         END;

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_DESTROY :
                         (* Mark allocated blocks as invalid                   *)
                         FOR i := 0 TO 10-1 DO
                              IF ((szLine[i] # NIL) AND
                                  (pMalloc^.lpVtbl^.DidAlloc (pMalloc,
                                                              szLine[i]))) THEN
                                   szLine[i] := NIL;
                              END;

                         (* Disconnect from | free allocator                   *)
                         pMalloc^.lpVtbl^.Release (pMalloc);
                         pMalloc := NIL;

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_IUNKNOWN :
                         hr := pMalloc^.lpVtbl^.QueryInterface (pMalloc,
                                                               IID_IUnknown,
                                                              (*(void **) SYSTEM.ADR(pUnk));
                         IF (SUCCEEDED (hr) THEN)
                              pUnk^.lpVtbl^.Release (pUnk);
                              MessageBox (hwnd, "IUnknown supported",
                                          szAppName, MB_OK);
                         ELSE
                              MessageBox (hwnd, "IUnknown not supported",
                                          szAppName, MB_OK);
                         RETURN 0;

                    | IDM_IMALLOC :
                         hr := pMalloc^.lpVtbl^.QueryInterface (pMalloc,
                                                               IID_IMalloc,
                                                               (*void **) SYSTEM.ADR(pUnk));
                         IF (SUCCEEDED (hr)) THEN
                              pUnk^.lpVtbl^.Release (pUnk);
                              MessageBox (hwnd, "IMalloc supported",
                                          szAppName, MB_OK);
                         ELSE
                              MessageBox (hwnd, "IMalloc not supported",
                                          szAppName, MB_OK);
                         RETURN 0;

                    | IDM_IMARSHAL :
                         hr := pMalloc^.lpVtbl^.QueryInterface (pMalloc,
                                                               IID_IMarshal,
                                                               (void **) SYSTEM.ADR(pUnk));
                         IF (SUCCEEDED (hr) THEN)
                              pUnk^.lpVtbl^.Release (pUnk);
                              MessageBox (hwnd, "IMarshal supported",
                                          szAppName, MB_OK);
                         ELSE
                              MessageBox (hwnd, "IMarshal not supported",
                                          szAppName, MB_OK);
                         END;
                         RETURN 0;

                    | IDM_ALLOCATE_CUSTOM :
                         IF (szLine[iCurLine] # NIL) THEN
                              MessageBox (hwnd, "Error: Free First",
                                          szAppName, MB_OK);
                              RETURN 0;
                         END;

                         (* Allocate from IAllocate interface                  *)
                         szLine[iCurLine] :=
                              (*char *) pMalloc^.lpVtbl^.Alloc (pMalloc, 100);
                         lstrcpy (szLine[iCurLine], "*IMalloc memory*");

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_ALLOCATE_DEFAULT :
                         IF (szLine[iCurLine] # NIL) THEN
                              MessageBox (hwnd, "Error: Free First",
                                          szAppName, MB_OK);
                              RETURN 0;
                         END;

                         (* Allocate from default heap                         *)
                         szLine[iCurLine] := (*char *) malloc (100);
                         lstrcpy (szLine[iCurLine], "-Malloc memory-");

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_FREE :
                         IF (szLine[iCurLine] = NIL) THEN
                              MessageBox (hwnd, "Error: Nothing to free",
                                          szAppName, MB_OK);
                              RETURN 0;
                         END;

                         IF (pMalloc = NIL) THEN
(*
                              goto FreeMalloc;
*)
                         END;
                         (* Free allocated object                              *)
                         IF (pMalloc^.lpVtbl^.DidAlloc (pMalloc,
                                                        szLine[iCurLine])) THEN
                              pMalloc^.lpVtbl^.Free (pMalloc,
                                                     szLine[iCurLine]);
                         ELSE
             (*FreeMalloc:    *)
                              free (szLine[iCurLine]);
                         END;

                         szLine[iCurLine] := NIL;

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

          | WINUSER.WM_DESTROY :
               (* Disconnect from | free allocator                             *)
               IF (pMalloc) THEN
                    pMalloc^.lpVtbl^.Release (pMalloc);
                    pMalloc := NIL;
               END;

               PostQuitMessage (0);  (* Handle application shutdown           *)
               RETURN 0;

          | WINUSER.WM_INITMENU :
               HMENU hMenu := (HMENU) wParam;
               IF (pMalloc) THEN
                    EnableMenuItem (hMenu, IDM_CREATE,          MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_DESTROY,         MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_ALLOCATE_CUSTOM, MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IUNKNOWN,        MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IMALLOC,         MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IMARSHAL,        MF_ENABLED);
               ELSE
                    EnableMenuItem (hMenu, IDM_CREATE,          MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_DESTROY,         MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_ALLOCATE_CUSTOM, MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_IUNKNOWN,        MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_IMALLOC,         MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_IMARSHAL,        MF_GRAYED);
               END;
               RETURN 0;


          | WINUSER.WM_LBUTTONDOWN :
               x := WINUSER.LOWORD (lParam);
               y := WINUSER.HIWORD (lParam);
               pt := POINT{ x, y };
               i := 0
               LOOP
               FOR i := 0 TO 10-1 DO
                    IF (PtInRect (SYSTEM.ADR(rHit[i]), pt) THEN)
                         IF (iCurLine # i) THEN  (* Minimize screen blink          *)
                              InvalidateRect (hwnd, SYSTEM.ADR(rHit[iCurLine]), TRUE);
                              InvalidateRect (hwnd, SYSTEM.ADR(rHit[i]), TRUE);
                              iCurLine := i;
                              EXIT;
                         END;
                    END;
                    RETURN 0;
               END;

          | WINUSER.WM_PAINT :

               hdc := BeginPaint (hwnd, SYSTEM.ADR(ps));

               (* Fetch line height                                            *)
               GetTextMetrics (ps.hdc, SYSTEM.ADR(tm));
               cyLineHeight := tm.tmHeight + tm.tmExternalLeading;

               (* Fetch current text colors                                    *)
               crText := GetTextColor (ps.hdc);
               crBack := GetBkColor (ps.hdc);

               XCount := tm.tmAveCharWidth * 3;
               XText  := XCount + tm.tmAveCharWidth * 7;
               Y      := tm.tmHeight;

               FOR  i := 0 TO 10-1 DO
                    Y := Y + cyLineHeight;
                    (* Set colors to highlight current line                    *)
                    IF (i = iCurLine) THEN
                         SetTextColor (ps.hdc, crBack);
                         SetBkColor (ps.hdc, crText);

                         SetRect (SYSTEM.ADR(rOpaque), 0, Y, 9999, Y + cyLineHeight);
                         ExtTextOut (ps.hdc, 0, 0, ETO_OPAQUE, SYSTEM.ADR(rOpaque),
                                     NIL, 0, NIL );
                    ELSE
                         SetTextColor (ps.hdc, crText);
                         SetBkColor (ps.hdc, crBack);
                    END;

                    (* Display line count                                      *)
                    cc := wsprintf (szBuff, "Line %d", i);
                    TextOut (ps.hdc, XCount, Y, szBuff, cc);

                    (* Display text if a string has been defined               *)
                    IF (szLine[i] # NIL) THEN
                         cc := lstrlen (szLine[i]);
                         TextOut (ps.hdc, XText, Y, szLine[i], cc);
                    END;

                    (* Calculate hit test rectangle                            *)
                    SetRect (SYSTEM.ADR(rHit[i]), 0, Y, 9999, Y + cyLineHeight);
               END;

               EndPaint (hwnd, SYSTEM.ADR(ps));
               RETURN 0;
          ELSE
               RETURN DefWindowProc (hwnd, iMsg, wParam, lParam);
          END;
END WndProc;
<*/POP*>
(*++++*****************************************************************)
PROCEDURE InitApplication () : BOOLEAN;
(**********************************************************************)

BEGIN
  wc.cbSize        := SIZE(wc);
  wc.style         := 0;
  wc.lpfnWndProc   := WndProc;
  wc.cbClsExtra    := 0;
  wc.cbWndExtra    := 0;
  wc.hInstance     := WINX.Instance;
  wc.hIcon         := WINUSER.LoadIcon(NIL,WINUSER.IDI_APPLICATION);
  wc.hCursor       := WINUSER.LoadCursor (NIL, WINUSER.IDC_ARROW);
  wc.hbrBackground := SYSTEM.CAST(WIN32.HBRUSH, COLOR_WINDOW+1));
  wc.lpszMenuName  := "MAIN";
  wc.lpszClassName := SYSTEM.ADR(szWndClass);
  wc.hIconSm       := WINUSER.LoadIcon(NIL,WINUSER.IDI_APPLICATION);

  RETURN WINUSER.RegisterClassEx(wc)#0;
END InitApplication;

(*++++*****************************************************************)
PROCEDURE InitMainWindow () : BOOLEAN;
(**********************************************************************)
BEGIN
  hwnd := WINUSER.CreateWindowEx (0h,szWndClass,
                        szAppName,
                        WINUSER.WS_OVERLAPPEDWINDOW,
                        WINUSER.CW_USEDEFAULT, WINUSER.CW_USEDEFAULT,
                        WINUSER.CW_USEDEFAULT, WINUSER.CW_USEDEFAULT,
                        NIL,
                        NIL,
                        WINX.Instance,
                        NIL);

  WINUSER.ShowWindow (hwnd, WINUSER.SW_DEFAULT);
  WINUSER.UpdateWindow (hwnd);
  RETURN TRUE;
END InitMainWindow;


BEGIN
  IF InitApplication()  AND  InitMainWindow() THEN
    WHILE (WINUSER.GetMessage(msg,NIL,0,0)) DO
      WINUSER.TranslateMessage(msg);
      WINUSER.DispatchMessage(msg);
    END;
  END;
END Caller.
