(*---------------------------------------------
   CALLPUB.C -- Call into public OLE component
                (c) Paul Yao, 1996
  ---------------------------------------------*)
#include <windows.h>
#include <initguid.h>
#include "pubmem.h"
#include "callpub.h"

LRESULT CALLBACK WndProc (hwnd, UINT, WPARAM, LPARAM) ;

char szWndClass[] := "CallerWindow";
char szAppName[]  := "Calls Public Malloc";

(*-------------------------------------------------------------------          *)
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR lpszCmdLine, int cmdShow)
     {
     hwnd        hwnd;
     MSG         msg;
     WNDCLASSEX  wc;

	 wc.cbSize        := sizeof (wc);
     wc.lpszClassName := szWndClass;
     wc.hInstance     := hInstance;
     wc.lpfnWndProc   := WndProc;
     wc.hCursor       := LoadCursor (NIL, IDC_ARROW);
     wc.hIcon         := LoadIcon (NIL, IDI_APPLICATION);
     wc.lpszMenuName  := "MAIN";
     wc.hbrBackground := (HBRUSH) (COLOR_WINDOW + 1);
     wc.style         := 0;
     wc.cbClsExtra    := 0;
     wc.cbWndExtra    := 0;
	 wc.hIconSm       := LoadIcon (NIL, IDI_APPLICATION);

     RegisterClassEx (SYSTEM.ADR(wc));

     hwnd := CreateWindowEx (0L, szWndClass, szAppName,
                            WS_OVERLAPPEDWINDOW,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            CW_USEDEFAULT, CW_USEDEFAULT,
                            NIL, NIL, hInstance, NIL);
     ShowWindow (hwnd, cmdShow);
     UpdateWindow (hwnd);

     (* Connect to OLE libraries                                               *)
     HRESULT hr := CoInitialize (NIL);
     IF (FAILED (hr) THEN)
          {
          (* Fail app initialization                                           *)
          RETURN FALSE;
          }

     while (GetMessage (SYSTEM.ADR(msg), NIL, 0, 0))
          {
          TranslateMessage (SYSTEM.ADR(msg));
          DispatchMessage (SYSTEM.ADR(msg));
          }

     (* Disconnect from OLE libraries                                          *)
     CoUninitialize ();

     RETURN msg.wParam;
     }

(*******************************************************************-          *)
LRESULT CALLBACK
WndProc (hwnd hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
     {
     static int       iCurLine := 0;
     static LPMALLOC  pMalloc := NIL;
     static LPSTR     szLine[10];
     static RECT      rHit[10];

     CASE (iMsg)                                                                                                                                                                                       OF
          {
          | WINUSER.WM_CREATE :
               (* Initialize data pointer array                                *)
               ZeroMemory (szLine, SIZE (szLine));
               RETURN 0;

          | WINUSER.WM_COMMAND :
               CASE (WINUSER.LOWORD (wParam))                                                                                                                                                          OF
                    {
                    | IDM_CREATE :
                         {
                         HRESULT hr :=
                              CoCreateInstance (CLSID_ALLOCATOR,
                                                NIL,
                                                CLSCTX_INPROC_SERVER,
                                                IID_IMalloc,
                                                (void **) SYSTEM.ADR(pMalloc));

                         IF (FAILED (hr) THEN)
                              {
                              MessageBox (hwnd, "Error: No allocator",
                                          szAppName, MB_OK);
                              RETURN 0;
                              }

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;
                         }

                    | IDM_DESTROY :
                         {
                         int i;

                         (* Mark allocated blocks as invalid                   *)
                         FOR (i := 0; i < 10; i++) DO
                              {
                              IF ((szLine[i] # NIL) THEN AND
                                  (pMalloc^.lpVtbl^.DidAlloc (pMalloc,
								                              szLine[i])))
                                   {
                                   szLine[i] := NIL;
                                   }
                              }

                         (* Disconnect from BAND free allocator                   *)
                         pMalloc^.lpVtbl^.Release (pMalloc);
                         pMalloc := NIL;

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;
                         }

                    | IDM_IUNKNOWN :
                         {
                         LPUNKNOWN pUnk;
                         HRESULT hr :=
                              pMalloc^.lpVtbl^.QueryInterface (pMalloc,
							                                   IID_IUnknown,
							                                   (void **) SYSTEM.ADR(pUnk));
                         IF (SUCCEEDED (hr) THEN)
                              {
                              pUnk^.lpVtbl^.Release (pUnk);
                              MessageBox (hwnd, "IUnknown supported",
                                          szAppName, MB_OK);
                              }
                         ELSE
                              {
                              MessageBox (hwnd, "IUnknown not supported",
                                          szAppName, MB_OK);
                              }
                         RETURN 0;
                         }

                    | IDM_IMALLOC :
                         {
                         LPUNKNOWN pUnk;
                         HRESULT hr :=
                              pMalloc^.lpVtbl^.QueryInterface (pMalloc,
							                                   IID_IMalloc,
							                                   (void **) SYSTEM.ADR(pUnk));

                         IF (SUCCEEDED (hr) THEN)
                              {
                              pUnk^.lpVtbl^.Release (pUnk);
                              MessageBox (hwnd, "IMalloc supported",
                                          szAppName, MB_OK);
                              }
                         ELSE
                              {
                              MessageBox (hwnd, "IMalloc not supported",
                                          szAppName, MB_OK);
                              }
                         RETURN 0;
                         }

                     | IDM_IMARSHAL :
                          {
                          LPUNKNOWN pUnk;
                          HRESULT hr :=
                               pMalloc^.lpVtbl^.QueryInterface (pMalloc,
							                                    IID_IMarshal,
							                                    (void **) SYSTEM.ADR(pUnk));
                          IF (SUCCEEDED (hr) THEN)
                               {
                               pUnk^.lpVtbl^.Release (pUnk);
                               MessageBox (hwnd, "IMarshal supported",
                                           szAppName, MB_OK);
                               }
                          ELSE
                               {
                               MessageBox (hwnd, "IMarshal not supported",
                                           szAppName, MB_OK);
                               }
                          RETURN 0;
                          }

                    | IDM_ALLOCATE_CUSTOM :
                         IF (szLine[iCurLine] # NIL) THEN
                              {
                              MessageBox (hwnd, "Error: Free First",
                                          szAppName, MB_OK);
                              RETURN 0;
                              }

                         (* Allocate from IMalloc interface                    *)
                         szLine[iCurLine] :=
							  (char *) pMalloc^.lpVtbl^.Alloc (pMalloc, 100);
                         lstrcpy (szLine[iCurLine], "*IMalloc memory*");

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_ALLOCATE_DEFAULT :
                         IF (szLine[iCurLine] # NIL) THEN
                              {
                              MessageBox (hwnd, "Error: Free First",
                                          szAppName, MB_OK);
                              RETURN 0;
                              }

                         (* Allocate from default heap                         *)
                         szLine[iCurLine] := (char *) malloc (100);
                         lstrcpy (szLine[iCurLine], "-Malloc memory-");

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;

                    | IDM_FREE :
                         IF (szLine[iCurLine] = NIL) THEN
                              {
                              MessageBox (hwnd, "Error: Nothing to free",
                                          szAppName, MB_OK);
                              RETURN 0;
                              }

                         IF (pMalloc = NIL) THEN
                              {
                              goto FreeMalloc;
                              }

                         (* Free allocated object                              *)
                         if (pMalloc^.lpVtbl^.DidAlloc (pMalloc,
							                            szLine[iCurLine]))
                              {
                              pMalloc^.lpVtbl^.Free (pMalloc,
								                     szLine[iCurLine]);
                              }
                         ELSE
                              {
               FreeMalloc:
                              free (szLine[iCurLine]);
                              }

                         szLine[iCurLine] := NIL;

                         InvalidateRect (hwnd, NIL, TRUE);
                         RETURN 0;
                    }

          | WINUSER.WM_DESTROY :
               (* Disconnect from BAND free allocator                             *)
               IF (pMalloc) THEN
                    {
                    pMalloc^.lpVtbl^.Release (pMalloc);
                    pMalloc := NIL;
                    }

               PostQuitMessage (0);  (* Handle application shutdown           *)
               RETURN 0;

          | WINUSER.WM_INITMENU :
               {
               HMENU hMenu := (HMENU) wParam;
               IF (pMalloc) THEN
                    {
                    EnableMenuItem (hMenu, IDM_CREATE,          MF_GRAYED);
                    EnableMenuItem (hMenu, IDM_DESTROY,         MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_ALLOCATE_CUSTOM, MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IUNKNOWN,        MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IMALLOC,         MF_ENABLED);
                    EnableMenuItem (hMenu, IDM_IMARSHAL,        MF_ENABLED);
                    }
               ELSE
                    {
                    EnableMenuItem(hMenu, IDM_CREATE,          MF_ENABLED);
                    EnableMenuItem(hMenu, IDM_DESTROY,         MF_GRAYED);
                    EnableMenuItem(hMenu, IDM_ALLOCATE_CUSTOM, MF_GRAYED);
                    EnableMenuItem(hMenu, IDM_IUNKNOWN,        MF_GRAYED);
                    EnableMenuItem(hMenu, IDM_IMALLOC,         MF_GRAYED);
                    EnableMenuItem(hMenu, IDM_IMARSHAL,        MF_GRAYED);
                    }
               RETURN 0;
               }

          | WINUSER.WM_LBUTTONDOWN :
               {
               int i;
               int x := WINUSER.LOWORD (lParam);
               int y := WINUSER.HIWORD (lParam);
               POINT pt := { x, y };

               FOR (i := 0; i < 10; i++) DO
                    {
                    IF (PtInRect (SYSTEM.ADR(rHit[i]), pt) THEN)
                         {
                         IF (iCurLine # i) THEN  (* Minimize screen blink          *)
                              {
                              InvalidateRect (hwnd, SYSTEM.ADR(rHit[iCurLine]), TRUE);
                              InvalidateRect (hwnd, SYSTEM.ADR(rHit[i]), TRUE);
                              iCurLine := i;
                              }
                         break;
                         }
                    }
               RETURN 0;
               }

          | WINUSER.WM_PAINT :
               {
               char         szBuff[10];
               COLORREF     crText, crBack;
               HDC          hdc;
               int          cc;
               int          i;
               int          XCount, XText, Y;
               int          cyLineHeight;
               PAINTSTRUCT  ps;
               RECT         rOpaque;
               TEXTMETRIC   tm;

               hdc := BeginPaint (hwnd, SYSTEM.ADR(ps));

               (* Fetch line height                                            *)
               GetTextMetrics (ps.hdc, SYSTEM.ADR(tm));
               cyLineHeight := tm.tmHeight + tm.tmExternalLeading;

               (* Fetch current text colors                                    *)
               crText := GetTextColor (ps.hdc);
               crBack := GetBkColor (ps.hdc);

               XCount := tm.tmAveCharWidth * 3;
               XText  := XCount + tm.tmAveCharWidth * 7;
               Y      := tm.tmHeight;

               FOR (i := 0; i < 10; i++, Y += cyLineHeight) DO
                    {
                    (* Set colors to highlight current line                    *)
                    IF (i = iCurLine) THEN
                         {
                         SetTextColor (ps.hdc, crBack);
                         SetBkColor (ps.hdc, crText);

                         SetRect (SYSTEM.ADR(rOpaque), 0, Y, 9999, Y + cyLineHeight);
                         ExtTextOut(ps.hdc, 0, 0, ETO_OPAQUE, SYSTEM.ADR(rOpaque),
                                    NIL, 0, NIL );
                         }
                    ELSE
                         {
                         SetTextColor (ps.hdc, crText);
                         SetBkColor (ps.hdc, crBack);
                         }

                    (* Display line count                                      *)
                    cc := wsprintf (szBuff, "Line %d", i);
                    TextOut (ps.hdc, XCount, Y, szBuff, cc);

                    (* Display text if a string has been defined               *)
                    IF (szLine[i] # NIL) THEN
                         {
                         cc := lstrlen (szLine[i]);
                         TextOut (ps.hdc, XText, Y, szLine[i], cc);
                         }

                    (* Calculate hit test rectangle                            *)
                    SetRect (SYSTEM.ADR(rHit[i]), 0, Y, 9999, Y + cyLineHeight);
                    }

               EndPaint (hwnd, SYSTEM.ADR(ps));
               RETURN 0;
               }

          ELSE
               RETURN DefWindowProc (hwnd, iMsg, wParam, lParam);
          }
     }
