IMPLEMENTATION MODULE FIOR;

FROM Strings IMPORT
    Concat;

FROM ExStrings IMPORT
    EqualI, AppendCharCond;

FROM FileFunc IMPORT
    FileSpecString, FileNameParts,
    ParseFileName, AssembleParts, ConstructFileName,
    ExpandFileSpec;

PROCEDURE AddExtension(VAR spec : ARRAY OF CHAR; ext : ARRAY OF CHAR);
BEGIN
    ConstructFileName(spec, ext, spec);
END AddExtension;

PROCEDURE ChangeExtension(VAR spec : ARRAY OF CHAR; ext : ARRAY OF CHAR);
BEGIN
    ConstructFileName(ext, spec, spec);
END ChangeExtension;

PROCEDURE RemoveExtension(VAR spec : ARRAY OF CHAR);
VAR
    parts	: FileNameParts;
BEGIN
    ParseFileName(spec, parts);
    parts.extension := "";
    AssembleParts(parts, spec);
END RemoveExtension;

PROCEDURE ExpandPath(path : ARRAY OF CHAR; VAR fullPath : ARRAY OF CHAR);
BEGIN
    fullPath := path;
    ExpandFileSpec(fullPath);
END ExpandPath;

PROCEDURE IsExtension(spec : ARRAY OF CHAR; ext : ExtStr) : BOOLEAN;
VAR
    parts	: FileNameParts;
BEGIN
    ParseFileName(spec, parts);
    RETURN EqualI(ext, parts.extension);
END IsExtension;

PROCEDURE MakePath(VAR path : ARRAY OF CHAR;
		       head, tail : ARRAY OF CHAR);
VAR
    temp	: FileSpecString;
BEGIN
    temp := head;
    AppendCharCond('\', temp);
    Concat(temp, tail, path);
END MakePath;

PROCEDURE SplitPath(path : ARRAY OF CHAR;
		    VAR head, tail : ARRAY OF CHAR);
VAR
    parts	: FileNameParts;
BEGIN
    ParseFileName(path, parts);
    Concat(parts.drive, parts.path, head);
    Concat(parts.name, parts.extension, tail);
END SplitPath;

END FIOR.
