IMPLEMENTATION MODULE IO;

FROM Strings IMPORT
    Equal;

FROM FileFunc IMPORT
    File, AccessModes, FileTypes,
    FakeFileOpen, OpenFile, CloseFile,
    ReadBlock, WriteBlock,
    FileType;

FROM StdHandles IMPORT
    StdInputHandle, StdOutputHandle;

FROM Str IMPORT
    StrToInt, StrToCard, StrToReal,
    IntToStr, CardToStr, RealToStr, FixRealToStr;

TYPE
    InputString		= ARRAY [0..MaxRdLength-1] OF CHAR;
    OutputString	= ARRAY [0..79] OF CHAR;

VAR
    InFile		: File;
    OutFile		: File;

    Line		: InputString;
    Bp, Be		: CARDINAL;
    Empty		: BOOLEAN;

PROCEDURE ReadFile(VAR str : ARRAY OF CHAR);
BEGIN
    IF Prompt AND
       Empty AND
       (FileType(InFile) = FileTypeChar)
    THEN
	WrChar('?');
    END;

    ReadBlock(InFile, str, HIGH(str)+1);
    IF InFile.count <> (HIGH(str)+1) THEN
	str[InFile.count] := 0C;
    END;
    Empty := TRUE;
END ReadFile;

PROCEDURE WriteFile(str : ARRAY OF CHAR);
BEGIN
    IF str[0] <> 0C THEN
	Empty := FALSE;
	WriteBlock(OutFile, str, LENGTH(str));
    END;
END WriteFile;

PROCEDURE FillBuffer;
VAR
    len	: CARDINAL;
BEGIN
    RdStrRedirect(Line);
    len := LENGTH(Line);
    IF len < MaxRdLength THEN
	Line[len] := 0C;
	INC(len);
    END;
    Bp := 0;
    Be := len;
END FillBuffer;

PROCEDURE RedirectInput(fileName : ARRAY OF CHAR);
VAR
    f	: File;
BEGIN
    OpenFile(f, fileName, ReadOnlyDenyWrite);
    IF f.status = 0 THEN
	IF InFile.handle <> StdInputHandle() THEN
	    CloseFile(InFile);
	END;
	InFile := f;
	InputRedirected := FileType(InFile) <> FileTypeChar;
    END;
END RedirectInput;

PROCEDURE RedirectOutput(fileName : ARRAY OF CHAR);
VAR
    f	: File;
BEGIN
    OpenFile(f, fileName, ReadOnlyDenyWrite);
    IF f.status = 0 THEN
	IF OutFile.handle <> StdOutputHandle() THEN
	    CloseFile(OutFile);
	END;
	OutFile := f;
	OutputRedirected := FileType(OutFile) <> FileTypeChar;
    END;
END RedirectOutput;

PROCEDURE RdStr(VAR str : ARRAY OF CHAR);
VAR
    l	: CARDINAL;
BEGIN
    RdStrRedirect(str);
    l := LENGTH(str);
    IF l > 0 THEN
        IF str[l-1] = CHR(10) THEN
            str[l-1] := 0C;
	    DEC(l);
	    IF (l > 0) AND (str[l-1] = CHR(13)) THEN
		str[l-1] := 0C;
            END;
        ELSIF str[l-1] = CHR(13) THEN
            str[l-1] := 0C;
	END;
    END;
    OK := TRUE;
END RdStr;

PROCEDURE EndOfRd(skip : BOOLEAN) : BOOLEAN;
BEGIN
    IF skip THEN
	WHILE (Bp < Be) AND (Line[Bp] IN Separators) DO
	    INC(Bp);
	END;
    END;
    OK := TRUE;
    RETURN Bp = Be;
END EndOfRd;

PROCEDURE RdLn;
BEGIN
    Bp := Be;
    OK := TRUE;
END RdLn;

PROCEDURE RdChar() : CHAR;
BEGIN
    IF Bp = Be THEN
	FillBuffer;
    END;

    OK := TRUE;
    INC(Bp);
    RETURN Line[Bp-1];
END RdChar;

PROCEDURE RdBool() : BOOLEAN;
VAR
    str		: InputString;
BEGIN
    RdItem(str);
    RETURN Equal(str, "TRUE");
END RdBool;

PROCEDURE RdShtInt() : SHORTINT;
VAR
    str		: InputString;
    num		: LONGINT;
BEGIN
    RdItem(str);
    num := StrToInt(str, 10, OK);
    OK := OK AND
	  (
	   (num >= MIN(SHORTINT)) AND (num <= MAX(SHORTINT))
	  );
    RETURN num;
END RdShtInt;

PROCEDURE RdInt() : INTEGER;
VAR
    str		: InputString;
    num		: LONGINT;
BEGIN
    RdItem(str);
    num := StrToInt(str, 10, OK);
    OK := OK AND
	  (
	   (num >= MIN(INTEGER)) AND (num <= MAX(INTEGER))
	  );
    RETURN num;
END RdInt;

PROCEDURE RdLngInt() : LONGINT;
VAR
    str		: InputString;
    num		: LONGINT;
BEGIN
    RdItem(str);
    num := StrToInt(str, 10, OK);
    RETURN num;
END RdLngInt;

PROCEDURE RdShtCard() : SHORTCARD;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 10, OK);
    OK := OK AND
	  (
	   (num >= MIN(SHORTCARD)) AND (num <= MAX(SHORTCARD))
	  );
    RETURN num;
END RdShtCard;

PROCEDURE RdCard() : CARDINAL;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 10, OK);
    OK := OK AND
	  (
	   (num >= MIN(CARDINAL)) AND (num <= MAX(CARDINAL))
	  );
    RETURN num;
END RdCard;

PROCEDURE RdLngCard() : CARDINAL32;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 10, OK);
    RETURN num;
END RdLngCard;

PROCEDURE RdShtHex() : SHORTCARD;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 16, OK);
    OK := OK AND
	  (
	   (num >= MIN(SHORTCARD)) AND (num <= MAX(SHORTCARD))
	  );
    RETURN num;
END RdShtHex;

PROCEDURE RdHex() : CARDINAL;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 16, OK);
    OK := OK AND
	  (
	   (num >= MIN(CARDINAL)) AND (num <= MAX(CARDINAL))
	  );
    RETURN num;
END RdHex;

PROCEDURE RdLngHex() : CARDINAL32;
VAR
    str		: InputString;
    num		: CARDINAL32;
BEGIN
    RdItem(str);
    num := StrToCard(str, 16, OK);
    RETURN num;
END RdLngHex;

PROCEDURE RdReal() : REAL;
VAR
    str		: InputString;
    num		: LONGREAL;
BEGIN
    RdItem(str);
    num := StrToReal(str, OK);
    OK := OK AND
	  (
	   (num >= MIN(REAL)) AND (num <= MAX(REAL))
	  );
    RETURN num;
END RdReal;

PROCEDURE RdLngReal() : LONGREAL;
VAR
    str		: InputString;
    num		: LONGREAL;
BEGIN
    RdItem(str);
    num := StrToReal(str, OK);
    RETURN num;
END RdLngReal;

PROCEDURE RdItem(VAR str : ARRAY OF CHAR);
VAR
    i	: CARDINAL;
BEGIN
    REPEAT
	IF Bp = Be THEN
	    FillBuffer;
	END;

	WHILE (Bp < Be) AND (Line[Bp] IN Separators) DO
	    INC(Bp);
	END;

	i := 0;
	WHILE (Bp < Be) AND
	      (NOT (Line[Bp] IN Separators)) AND
	      (i <= HIGH(str))
	DO
	    str[i] := Line[Bp];
	    INC(Bp);
	    INC(i);
	END;
	IF i <= HIGH(str) THEN
	    str[i] := 0C;
	END;
    UNTIL str[0] <> 0C;
    OK := TRUE;
END RdItem;

PROCEDURE WrStr(str : ARRAY OF CHAR);
BEGIN
    IF RdLnOnWr THEN
	RdLn;
    END;

    WrStrRedirect(str);
    OK := TRUE;
END WrStr;

PROCEDURE WrStrAdj(str : ARRAY OF CHAR; len : INTEGER);
VAR
    delta	: INTEGER;
    i		: INTEGER;
BEGIN
    IF RdLnOnWr THEN
	RdLn;
    END;

    delta := ABS(len) - INT(LENGTH(str));

    IF (delta < 0) AND ChopOff THEN
	FOR i := 1 TO ABS(len) DO
	    WrStrRedirect("?");
	END;
	OK := FALSE;
    ELSE
	OK := TRUE;
	IF (delta > 0) AND (len > 0) THEN
	    FOR i := 1 TO delta DO
		WrStrRedirect(PrefixChar);
	    END;
	END;
	WrStrRedirect(str);
	IF (delta > 0) AND (len < 0) THEN
	    FOR i := 1 TO delta DO
		WrStrRedirect(SuffixChar);
	    END;
	END;
    END;
END WrStrAdj;

PROCEDURE WrLn;
TYPE
    a2	= ARRAY [0..1] OF CHAR;
CONST
    crlf = a2{CHR(13), CHR(10)};
BEGIN
    WrStr(crlf);
    Empty := TRUE;
END WrLn;

PROCEDURE WrChar(ch : CHAR);
BEGIN
    IF RdLnOnWr THEN
	RdLn;
    END;
    WrStrRedirect(ch);
    OK := TRUE;
END WrChar;

PROCEDURE WrBool(bool : BOOLEAN; len : INTEGER);
BEGIN
    IF bool THEN
	WrStrAdj("TRUE", len);
    ELSE
	WrStrAdj("FALSE", len);
    END;
END WrBool;

PROCEDURE WrShtInt(num : SHORTINT; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    IntToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrShtInt;

PROCEDURE WrInt(num : INTEGER; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    IntToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrInt;

PROCEDURE WrLngInt(num : LONGINT; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    IntToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrLngInt;

PROCEDURE WrShtCard(num : SHORTCARD; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrShtCard;

PROCEDURE WrCard(num : CARDINAL; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrCard;

PROCEDURE WrLngCard(num : CARDINAL32; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 10, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrLngCard;

PROCEDURE WrShtHex(num : SHORTCARD; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 16, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrShtHex;

PROCEDURE WrHex(num : CARDINAL; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 16, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrHex;

PROCEDURE WrLngHex(num : CARDINAL32; len : INTEGER);
VAR
    str		: OutputString;
BEGIN
    CardToStr(num, str, 16, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrLngHex;

PROCEDURE WrReal(num : REAL; precision : CARDINAL; len : INTEGER);
VAR
    str	: OutputString;
BEGIN
    RealToStr(num, precision, Eng, str, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrReal;

PROCEDURE WrLngReal(num : LONGREAL; precision : CARDINAL; len : INTEGER);
VAR
    str	: OutputString;
BEGIN
    RealToStr(num, precision, Eng, str, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrLngReal;

PROCEDURE WrFixReal(num : REAL; precision : CARDINAL; len : INTEGER);
VAR
    str	: OutputString;
BEGIN
    FixRealToStr(num, precision, str, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrFixReal;

PROCEDURE WrFixLngReal(num : LONGREAL; precision : CARDINAL; len : INTEGER);
VAR
    str	: OutputString;
BEGIN
    FixRealToStr(num, precision, str, OK);
    IF OK THEN
	WrStrAdj(str, len);
    END;
END WrFixLngReal;

PROCEDURE WrCharRep(ch : CHAR; count : CARDINAL);
VAR
    i	: CARDINAL;
BEGIN
    IF RdLnOnWr THEN
	RdLn;
    END;

    FOR i := 1 TO count DO
	WrStrRedirect(ch);
    END;
    OK := TRUE;
END WrCharRep;

BEGIN
    FakeFileOpen(InFile, StdInputHandle(), ReadOnlyDenyWrite);
    FakeFileOpen(OutFile, StdOutputHandle(), WriteOnlyDenyAll);

    Empty := TRUE;
    Bp := 0;
    Be := 0;

    RdStrRedirect := ReadFile;
    WrStrRedirect := WriteFile;
    InputRedirected := FALSE;;
    OutputRedirected := FALSE;

    RdLnOnWr := FALSE;
    Prompt := FALSE;

    Separators := CHARSET{CHR(9), CHR(10), CHR(13), CHR(26), ' '};
    OK := TRUE;
    ChopOff := FALSE;
    Eng := FALSE;
    PrefixChar := ' ';
    SuffixChar := ' ';
END IO.
