IMPLEMENTATION MODULE Lib;

FROM SYSTEM IMPORT
    ADDRESS, BYTE, WORD,
    EXITCODE, CPU, FPP,
    ADDADR, SUBADR, DIFADR,
    FUNC, UNREFERENCED_PARAMETER;

%IF DOS %OR FlashTek %THEN
FROM SYSTEM IMPORT
    REGISTERS, INTR;
%END

FROM Environment IMPORT
    GetSymbol, GetCommandLine;

FROM RunProg IMPORT
    RunProgram, PerformCommand, SyncExec;

FROM MemUtils IMPORT
    FillMemBYTE, FillMemWORD, ScanMemBYTE, ScanMemNeBYTE, MoveMem;

IMPORT RandomNumbers, RealRandomNumbers;

FROM SysClock IMPORT
    DateTime, maxSecondParts, GetClock, SetClock;

IMPORT ElapsedTime;

PROCEDURE AddAddr(a : ADDRESS; incr : CARDINAL) : ADDRESS;
BEGIN
    RETURN ADDADR(a, incr);
END AddAddr;

PROCEDURE SubAddr(a : ADDRESS; incr : CARDINAL) : ADDRESS;
BEGIN
    RETURN SUBADR(a, incr);
END SubAddr;

PROCEDURE IncAddr(VAR a : ADDRESS; incr : CARDINAL);
BEGIN
    a := ADDADR(a, incr);
END IncAddr;

PROCEDURE DecAddr(VAR a : ADDRESS; incr : CARDINAL);
BEGIN
    a := SUBADR(a, incr);
END DecAddr;

PROCEDURE Compare(src, dest : ADDRESS; len : CARDINAL) : CARDINAL;
VAR
    ptrS, ptrD	: POINTER TO BYTE;
BEGIN
    ptrS := src;
    ptrD := dest;
    LOOP
	IF (len <> 0) AND (ptrS^ = ptrD^) THEN
	    DEC(len);
	    ptrS := ADDADR(ptrS, SIZE(ptrS^));
	    ptrD := ADDADR(ptrD, SIZE(ptrD^));

	    IF (len <> 0) AND (ptrS^ = ptrD^) THEN
		DEC(len);
		ptrS := ADDADR(ptrS, SIZE(ptrS^));
		ptrD := ADDADR(ptrD, SIZE(ptrD^));
	    ELSE
		EXIT;
	    END;
	ELSE
	    EXIT;
	END;
    END;
    RETURN DIFADR(ptrD, dest);
END Compare;

PROCEDURE CpuId(VAR id : CpuRec);
CONST
    cpuVal	: ARRAY OF CpuKind =
	{
	 cpu_Unknown, cpu_8086, cpu_80286, cpu_80386, cpu_80486, cpu_Pentium
	};
    fpuVal	: ARRAY OF FpuKind =
	{
	 fpu_none, fpu_8087, fpu_80287, fpu_80387
	};
BEGIN
    id.cpu := cpuVal[CPU];
    id.fpu := fpuVal[FPP];
END CpuId;

PROCEDURE Delay(amount : CARDINAL);
BEGIN
    ElapsedTime.Delay(amount);
END Delay;

%IF DOS %OR FlashTek %THEN
PROCEDURE Dos(VAR R : REGISTERS);
BEGIN
    INTR(21h, R);
END Dos;
%END

PROCEDURE Exec(command, params : ARRAY OF CHAR; env : ExecEnvPtr) : CARDINAL;
VAR
    stat	: CARDINAL;
BEGIN
    IF env = NIL THEN
	IF NOT RunProgram(command, params, SyncExec, stat) THEN
	    stat := MAX(CARDINAL);
	END;
    ELSE
	stat := MAX(CARDINAL);
    END;
    RETURN stat;
END Exec;

PROCEDURE ExecCmd(command : ARRAY OF CHAR) : CARDINAL;
VAR
    stat	: CARDINAL;
BEGIN
    IF NOT PerformCommand(command, (*SyncExec,*) stat) THEN
	stat := MAX(CARDINAL);
    END;
    RETURN stat;
END ExecCmd;

PROCEDURE EnvironmentFind(name : ARRAY OF CHAR;
			  VAR result : ARRAY OF CHAR);
BEGIN
    result := "";
    FUNC GetSymbol(name, result);
END EnvironmentFind;

PROCEDURE Fill(dest : ADDRESS; count : CARDINAL; db : BYTE);
BEGIN
    FillMemBYTE(dest^, count, db);
END Fill;

PROCEDURE GetDate(VAR year, month, day : CARDINAL;
		  VAR dayOfWeek : DayType);
VAR
    dt	: DateTime;
BEGIN
    GetClock(dt);
    year := dt.year;
    month := dt.month;
    day := dt.day;
    dayOfWeek := Monday;
END GetDate;

PROCEDURE GetTime(VAR hrs, mins, secs, hsecs : CARDINAL);
VAR
    dt	: DateTime;
BEGIN
    GetClock(dt);
    hrs := dt.hour;
    mins := dt.minute;
    secs := dt.second;
    IF maxSecondParts = 99 THEN
	hsecs := dt.fractions;
    ELSE
	hsecs := dt.fractions / 10;
    END;
END GetTime;

PROCEDURE SetDate(year, month, day : CARDINAL; dayOfWeek : DayType);
VAR
    dt	: DateTime;
BEGIN
    UNREFERENCED_PARAMETER(dayOfWeek);

    GetClock(dt);
    dt.year := year;
    dt.month := month;
    dt.day := day;
    SetClock(dt);
END SetDate;

PROCEDURE SetTime(hrs, mins, secs, hsecs : CARDINAL);
VAR
    dt	: DateTime;
BEGIN
    GetClock(dt);
    dt.hour := hrs;
    dt.minute := mins;
    dt.second := secs;
    dt.fractions := hsecs;
    IF maxSecondParts > 99 THEN
	dt.fractions := dt.fractions * 10;
    END;
    SetClock(dt);
END SetTime;

PROCEDURE HashString(str : ARRAY OF CHAR; range : CARDINAL) : CARDINAL;
VAR
    hv	: CARDINAL;
    i	: CARDINAL;
BEGIN
    hv := 0;
    FOR i := 1 TO LENGTH(str) DO
	<*/PUSH/NOCHECK:O*>
	hv := hv + hv + ORD(str[i]);
	<*/POP*>
    END;
    IF range <> 0 THEN
	hv := hv REM range;
    END;
    RETURN hv;
END HashString;

%IF DOS %OR FlashTek %THEN
PROCEDURE Intr(VAR R : REGISTERS; intNum : CARDINAL);
BEGIN
    INTR(intNum, R);
END Intr;
%END

PROCEDURE Move(src, dest : ADDRESS; count : CARDINAL);
BEGIN
    MoveMem(dest^, src^, count);
END Move;

PROCEDURE ParamCount() : CARDINAL;
VAR
    cmdLine	: ARRAY [0..255] OF CHAR;
    i, l	: CARDINAL;
    count	: CARDINAL;
BEGIN
    GetCommandLine(cmdLine);
    count := 0;
    i := 0;
    l := LENGTH(cmdLine);
    WHILE i < l DO
	WHILE (i < l) AND
	      (
	       (cmdLine[i] = ' ') OR (cmdLine[i] = CHR(9))
	      )
	DO
	    INC(i);
	END;
	IF i < l THEN
	    INC(count);
	    WHILE (i < l) AND
		  (
		   (cmdLine[i] <> ' ') AND (cmdLine[i] <> CHR(9))
		  )
	    DO
		INC(i);
	    END;
	END;
    END;
    RETURN count;
END ParamCount;

PROCEDURE ParamStr(VAR str : ARRAY OF CHAR; n : CARDINAL);
VAR
    cmdLine	: ARRAY [0..255] OF CHAR;
    i, j, l	: CARDINAL;
    count	: CARDINAL;
BEGIN
    GetCommandLine(cmdLine);
    str := "";
    count := 0;
    i := 0;
    l := LENGTH(cmdLine);
    WHILE i < l DO
	WHILE (i < l) AND
	      (
	       (cmdLine[i] = ' ') OR (cmdLine[i] = CHR(9))
	      )
	DO
	    INC(i);
	END;
	IF i < l THEN
	    INC(count);
	    j := 0;
	    WHILE (i < l) AND
		  (
		   (cmdLine[i] <> ' ') AND (cmdLine[i] <> CHR(9))
		  )
	    DO
		IF count = n THEN
		    IF j <= HIGH(str) THEN
			str[j] := cmdLine[i];
			INC(j);
		    END;
		END;
		INC(i);
	    END;
	    IF count = n THEN
		IF j <= HIGH(str) THEN
		    str[j] := 0C;
		END;
		RETURN;
	    END;
	END;
    END;
END ParamStr;

PROCEDURE QSort(numItems : CARDINAL;
		less : CompareProc;
		swap : SwapProc);
CONST
    cutoffValue	= 10;

    PROCEDURE quick(left, right : CARDINAL);
    VAR
	j		: CARDINAL;
	k		: CARDINAL;
    BEGIN
	WHILE (left < right) AND ((right-left) > cutoffValue) DO
	    (* median of three optimization *)

	    swap((left+right) / 2, left+1);

	    IF less(right, left+1) THEN
		swap(right, left+1);
	    END;
	    IF less(right, left) THEN
		swap(right, left);
	    END;
	    IF less(left, left+1) THEN
		swap(left, left+1);
	    END;

	    (* split the sequence *)
	    (* this can be faster if a <= comparison were available *)

	    j := left+1;
	    k := right;

	    LOOP
		WHILE (j < k) AND less(j, k) DO
		    INC(j);
		END;
		IF j = k THEN
		    EXIT;
		END;
		swap(j, k);
		DEC(k);
		WHILE (j < k) AND less(j, k) DO
		    DEC(k);
		END;
		IF j = k THEN
		    EXIT;
		END;
		swap(j, k);
		INC(j);
	    END;

	    (* tail recursion optimization *)

	    IF (k-left) < (right-k) THEN
		quick(left, k-1);
		left := k+1;
	    ELSE
		quick(k+1, right);
		right := k-1;
	    END;
	END;
    END quick;

    PROCEDURE insertSort(upper : CARDINAL);
    VAR
	i	: CARDINAL;
	j	: CARDINAL;
    BEGIN
	FOR i := 2 TO upper DO
	    j := i;
	    WHILE (j > 1) AND less(j, j-1) DO
		swap(j, j-1);
		DEC(j);
	    END;
	END;
    END insertSort;

BEGIN
    IF numItems > 1 THEN
	quick(1, numItems);
	insertSort(numItems);
    END;
END QSort;

PROCEDURE HSort(numItems : CARDINAL;
		less : CompareProc;
		swap : SwapProc);

    PROCEDURE restoreHeap(idx, last_element : CARDINAL);
    VAR
	l	: CARDINAL;
	r	: CARDINAL;
	largest	: CARDINAL;
    BEGIN
	LOOP
	    l := 2*idx;
	    IF (l <= last_element) AND less(idx, l) THEN
		largest := l;
	    ELSE
		largest := idx;
	    END;

	    r := l+1(*2*idx+1*);
	    IF (r <= last_element) AND less(largest, r) THEN
		largest := r;
	    END;

	    IF largest <> idx THEN
		swap(idx, largest);
		idx := largest;
	    ELSE
		EXIT;
	    END;
	END;
    END restoreHeap;

VAR
    i		 : CARDINAL;
BEGIN
    (* Convert to Heap *)

    FOR i := (numItems / 2) TO 1 BY -1 DO
	restoreHeap(i, numItems);
    END;

    (* Sort *)

    FOR i := numItems TO 2 BY -1 DO
	swap(1, i);
	restoreHeap(1, i-1);
    END;
END HSort;

<*/PUSH/NOOPT*>
PROCEDURE RAND() : REAL;
VAR
    r	: REAL;
BEGIN
    (* the optimizer is turned off to make sure the *)
    (* longreal returned from the function is trunced to a *)
    (* real value *)
    (* the optimizer will try to maintain a higher precision *)

    r := RealRandomNumbers.Random();
    RETURN r;
END RAND;
<*/POP*>

PROCEDURE RANDOM(range : CARDINAL) : CARDINAL;
BEGIN
    RETURN RandomNumbers.Rnd(range);
END RANDOM;

PROCEDURE RANDOMIZE;
BEGIN
    RandomNumbers.Randomize(0);
    RealRandomNumbers.Randomize(0);
END RANDOMIZE;

PROCEDURE ScanL(dest : ADDRESS; count : CARDINAL; db : BYTE) : CARDINAL;
BEGIN
    RETURN ScanR(SUBADR(dest, count), count, db);
END ScanL;

PROCEDURE ScanNeL(dest : ADDRESS; count : CARDINAL; db : BYTE) : CARDINAL;
BEGIN
    RETURN ScanNeR(SUBADR(dest, count), count, db);
END ScanNeL;

PROCEDURE ScanNeR(dest : ADDRESS; count : CARDINAL; db : BYTE) : CARDINAL;
BEGIN
    RETURN ScanMemNeBYTE(dest^, count, db);
END ScanNeR;

PROCEDURE ScanR(dest : ADDRESS; count : CARDINAL; db : BYTE) : CARDINAL;
BEGIN
    RETURN ScanMemBYTE(dest^, count, db);
END ScanR;

PROCEDURE SetReturnCode(code : CARDINAL);
BEGIN
    EXITCODE := code;
END SetReturnCode;

VAR
    UserHalt	: PROC;

PROCEDURE Terminate(p : PROC; VAR old : PROC);
BEGIN
    old := UserHalt;
    UserHalt := p;
END Terminate;

PROCEDURE WordFill(dest : ADDRESS; count : CARDINAL; dw : WORD);
BEGIN
    FillMemWORD(dest^, count, dw);
END WordFill;

PROCEDURE WordMove(src, dest : ADDRESS; count : CARDINAL);
BEGIN
    MoveMem(dest^, src^, count*2);
END WordMove;

PROCEDURE NullProc;
BEGIN
END NullProc;

PROCEDURE DefaultHandler(addr : CARDINAL32;
			 num : CARDINAL;
			 mess : ARRAY OF CHAR);
BEGIN
    UNREFERENCED_PARAMETER(addr);
    UNREFERENCED_PARAMETER(num);
    UNREFERENCED_PARAMETER(mess);
    HALT(EXITCODE);
END DefaultHandler;

BEGIN
    RandomNumbers.Randomize(1023);
    RealRandomNumbers.Randomize(1023);
    UserHalt := NullProc;
    RunTimeError := DefaultHandler;
FINALLY
    UserHalt;
END Lib.
